<?php

/*
    Plugin Name:        Dragonizer - WordPress Performance and Acceleration Enhancer
    Plugin URI:         https://www.rtl-theme.com/dragonizer-wordpress-plugin
    Description:        <strong>Dragonizer</strong> transforms your WordPress site's performance, making it a model of speed and efficiency. Utilizing the latest in page and object caching, file optimization, and image lazy loading, it significantly cuts down your website’s loading times. But there's more - beyond just speed, Dragonizer allows for deep customization across your site, tailoring every aspect to your needs. Get ready to elevate your WordPress site to unprecedented levels of performance, security, and user interaction with Dragonizer’s tailored optimization.❤️
    Version:            1.7.73
    Author:             Dynamatic
    Author URI:         https://www.rtl-theme.com/author/mahyardyn
    License:            Single Site License
    License URI:        http://www.gnu.org/licenses/gpl-3.0.html
    Text Domain:        dragonizer
    Domain Path:        /languages
    Tested up to:       6.7.1
    Requires at least:  5.3
    Requires PHP:       7.4
 
    ╭━━━╮╭━━━╮╭━━━╮╭━━━╮╭━━━╮╭━╮╱╭╮╭━━╮╭━━━━╮╭━━━╮╭━━━╮
    ╰╮╭╮┃┃╭━╮┃┃╭━╮┃┃╭━╮┃┃╭━╮┃┃┃╰╮┃┃╰┫┣╯╰━━╮━┃┃╭━━╯┃╭━╮┃
    ╱┃┃┃┃┃╰━╯┃┃┃╱┃┃┃┃╱╰╯┃┃╱┃┃┃╭╮╰╯┃╱┃┃╱╱╱╭╯╭╯┃╰━━╮┃╰━╯┃
    ╱┃┃┃┃┃╭╮╭╯┃╰━╯┃┃┃╭━╮┃┃╱┃┃┃┃╰╮┃┃╱┃┃╱╱╭╯╭╯╱┃╭━━╯┃╭╮╭╯
    ╭╯╰╯┃┃┃┃╰╮┃╭━╮┃┃╰┻━┃┃╰━╯┃┃┃╱┃┃┃╭┫┣╮╭╯━╰━╮┃╰━━╮┃┃┃╰╮
    ╰━━━╯╰╯╰━╯╰╯╱╰╯╰━━━╯╰━━━╯╰╯╱╰━╯╰━━╯╰━━━━╯╰━━━╯╰╯╰━╯
*/

// Define constants for the Dragonizer plugin
defined('DRAGONIZER_NAME') || define('DRAGONIZER_NAME', 'dragonizer');
defined('DRAGONIZER_VER')  || define('DRAGONIZER_VER' , '1.7.73');
defined('DRAGONIZER_URL')  || define('DRAGONIZER_URL' , plugin_dir_url(__FILE__));
defined('DRAGONIZER_DIR')  || define('DRAGONIZER_DIR' , plugin_dir_path(__FILE__));
defined('DRAGONIZER_BASE') || define('DRAGONIZER_BASE', plugin_basename(__FILE__));
defined('DRAGONIZER_FILE') || define('DRAGONIZER_FILE', __FILE__);

// Let's get this party started
include_once(DRAGONIZER_DIR . '/app/starter.php');
