<?php

// If this file is called directly, abort.
defined('WPINC') || die();

class Dragonizer_Public extends Dragonizer_Core
{
	private $front_font;
	private $title_font;

	public function __construct(string $front_font, string $title_font)
	{
		parent::__construct();

		$this->front_font = $front_font;
		$this->title_font = $title_font;
	}

	public function enqueue_styles(): void
	{
		if ($this->get('disabled')) return;

		if (is_user_logged_in()) {
			wp_register_style(DRAGONIZER_NAME . '-top-menu', false);
			wp_enqueue_style(DRAGONIZER_NAME . '-top-menu');
			wp_add_inline_style(DRAGONIZER_NAME .  '-top-menu', '#wp-admin-bar-elementor_edit_page:hover>div{display:block!important}#wp-admin-bar-dragonizer-adminbar-features{box-shadow:inset 0 0 400px 110px rgba(0,0,0,.2);padding-top:3px!important;padding-bottom:3px!important}#wp-admin-bar-dragonizer-adminbar::after{clear:both}#wp-admin-bar-dragonizer-adminbar .ab-item .dashicons.dashicons-star-filled{color:#ffb900}#wp-admin-bar-dragonizer-adminbar .ab-item .dashicons{font:400 20px/1 dashicons!important;font-size:15px!important;padding:6px 0!important}.dragonizer-logo-wrap{padding:5px!important;line-height:normal!important}.dragonizer-logo-wrap:hover .dragonizer-logo-wrap-hover{fill:inherit}');
		}
		
		if ($this->front_font === 'default') return;

		$css_contents = DRFS::read(_dr(DRAGONIZER_ASE_DIR, 'css', "dragonizer-font-global-rtl.min.css"));

		if (!$css_contents) return;

		$css_contents = str_replace(['DRAGONIZER_ASE_URL', 'DRAGONIZER_FONT_NAME', 'DRAGONIZER_TITLE_FONT_NAME', 'body.rtl '], [DRAGONIZER_ASE_URL, $this->front_font, $this->title_font, ''], $css_contents);

		wp_register_style(DRAGONIZER_NAME . '-front-font', false);
		wp_enqueue_style(DRAGONIZER_NAME . '-front-font');
		wp_add_inline_style(DRAGONIZER_NAME .  '-front-font', $css_contents);
	}

	public function enqueue_scripts(): void
	{
		if ($this->get('disabled')) return;

		if ($this->true('minify', 'common', 'passive_events')) {
			wp_enqueue_script(DRAGONIZER_NAME . '-passive-events', dr_url_to_relative(_dr(DRAGONIZER_ASE_URL, 'js', 'dragonizer-passive-events.min.js'), true), array(), DRAGONIZER_VER, true);
		}

		// Exit if the current user has 'manage_options' capability (usually an administrator)
		if (current_user_can('manage_options')) {
			return;
		}

		/* Checks if copyright section should work on this page. */
		if ($this->true('modules_status', 'copyright')) {
			wp_enqueue_script(DRAGONIZER_NAME . '-copyright', dr_url_to_relative(_dr(DRAGONIZER_ASE_URL, 'js', 'dragonizer-copyright.min.js'), true), array(), DRAGONIZER_VER);
			wp_localize_script(DRAGONIZER_NAME . '-copyright', 'dragonizer_copyright', [
				'dra_select_all'     => $this->get('copyright', 'select_all'),     // Disable Select All.
				'dra_copy'           => $this->get('copyright', 'copy'),           // Disable Copy.
				'dra_cut'            => $this->get('copyright', 'cut'),            // Disable Cut.
				'dra_paste'          => $this->get('copyright', 'paste'),          // Disable Paste.
				'dra_save'           => $this->get('copyright', 'save'),           // Disable Save.
				'dra_view_source'    => $this->get('copyright', 'view_source'),    // Disable View Source.
				'dra_print_page'     => $this->get('copyright', 'print_page'),     // Disable Print Page.
				'dra_developer_tool' => $this->get('copyright', 'developer_tool'), // Disable Developer Tool.
				'dra_reader_mode'    => $this->get('copyright', 'reader_mode'),    // Disable Safari Reader Mode.
				'dra_right_click'    => $this->get('copyright', 'right_click'),    // Disable Right Click.
				'dra_text_selection' => $this->get('copyright', 'text_selection'), // Disable Text Selection.
				'dra_image_dragging' => $this->get('copyright', 'image_dragging'), // Disable Image Dragging.
				'script_location'    => dr_url_to_relative(_dr(DRAGONIZER_ASE_URL, 'js', 'dragonizer-copyright.min.js'), true)
			]);
		}
	}

	public function javascript_required()
	{
		if ($this->get('disabled')) return;
		if ($this->true('minify', 'html', 'noscript')) return;

		$js_msg = wp_kses_post($this->get('copyright', 'javascript', 'value')) ?? __('Please Enable <strong><span style="color: #800080;">JavaScript</span></strong> in your Browser to Visit this Site', 'dragonizer');
		echo "<noscript> <div id='dragonizer-js-disabled'> <div>$js_msg</div> </div> <style> #dragonizer-js-disabled { position: fixed; top: 0; left: 0; height: 100%; width: 100%; z-index: 999999; text-align: center; background-color: #FFFFFF; color: #000000; font-size: 40px; display: flex; align-items: center; justify-content: center; } </style> </noscript>";
	}
}
