<?php

// If user not in admin area, abort.
defined('DRAGONIZER_ADMIN_INIT') || die();

class Dragonizer_Admin extends Dragonizer_Core
{
	private $hidden_menus;
	private $font;

	public function __construct(array $hidden_menus, string $font)
	{
		parent::__construct();

		$this->font = $font;
		$this->hidden_menus = $hidden_menus;
	}

	public function enqueue_styles($hook): void
	{
		$screen_id = get_current_screen()->id ?: '';

		if ($hook === 'plugins.php') {
			$url = dr_url_to_relative(_dr(DRAGONIZER_ASE_URL, 'images', 'logo', 'main.png')) . '?ver=' . DRAGONIZER_VER;
			wp_register_style(DRAGONIZER_NAME . '-plugins-logo', false);
			wp_enqueue_style(DRAGONIZER_NAME . '-plugins-logo');
			wp_add_inline_style(DRAGONIZER_NAME . '-plugins-logo', "tr[data-plugin='dragonizer/dragonizer.php'] td.plugin-title strong{padding:7px 10px 7px 35px;border-radius:7px;display:inline-block;font-weight:bold;margin-bottom:10px;position:relative}.rtl tr[data-plugin='dragonizer/dragonizer.php'] td.plugin-title strong{padding:7px 35px 7px 10px!important}tr[data-plugin='dragonizer/dragonizer.php'] td.plugin-title strong:before{content:'';background-image:url($url);background-size:28px 26px;position:absolute;left:4px;top:0;width:28px;height:26px}.rtl tr[data-plugin='dragonizer/dragonizer.php'] td.plugin-title strong:before{right:5px!important;top:4px!important}");
		}

		wp_enqueue_style('wp-admin');

		wp_register_style(DRAGONIZER_NAME . '-top-menu', false);
		wp_enqueue_style(DRAGONIZER_NAME . '-top-menu');
		wp_add_inline_style(DRAGONIZER_NAME .  '-top-menu', '#wp-admin-bar-dragonizer-adminbar-features{box-shadow:inset 0 0 400px 110px rgba(0,0,0,.2);padding-top:3px!important;padding-bottom:3px!important}#wp-admin-bar-dragonizer-adminbar::after{clear:both}#wp-admin-bar-dragonizer-adminbar .ab-item .dashicons.dashicons-star-filled{color:#ffb900}#wp-admin-bar-dragonizer-adminbar .ab-item .dashicons{font:400 20px/1 dashicons!important;font-size:15px!important;padding:6px 0!important}.dragonizer-logo-wrap{padding:5px!important;line-height:normal!important}.dragonizer-logo-wrap:hover .dragonizer-logo-wrap-hover{fill:inherit}');

		if (strpos($screen_id, 'dragonizer') !== false) {
			wp_enqueue_style('wp-color-picker');
			wp_enqueue_style(DRAGONIZER_NAME . '-main', dr_url_to_relative(_dr(DRAGONIZER_ASE_URL, 'css', 'dragonizer-main.min.css'), true), array(), DRAGONIZER_VER, 'all');
			$this->font = $this->font !== 'default' ? $this->font : 'IRANYekanX-Regular';

			$floatingCss = '.floating-submit{position:fixed!important;background:rgb(255,255,255)!important;background:%%GRADI%% bottom:0!important;padding:25px 0!important;padding-%%SIDE%%:%%PADD%%!important;text-align:%%SIDE%%!important;z-index:168!important;%%SIDE%%:0!important;width:40%!important;margin:0!important}.submit{text-align:%%SIDE%%!important}.submit-placeholder{max-width:100%!important;padding:2.5em 0!important;margin:5px 0!important}';

			$gradientRtl = 'linear-gradient(90deg, rgba(255, 255, 255, 0) 0%, rgb(62 26 26 / 15%) 5%, rgb(144 112 112 / 42%) 10%, rgb(144 122 122 / 35%) 30%, rgba(255, 255, 255, 0) 100%) !important;';
			$gradientLtr = 'linear-gradient(90deg, rgba(255, 255, 255, 0) 0%, rgb(144 122 122 / 35%) 70%, rgb(144 112 112 / 42%) 90%, rgb(62 26 26 / 15%) 95%, rgba(255, 255, 255, 0) 100%) !important;';
			$floatingCss = str_replace('%%GRADI%%', is_rtl() ? $gradientRtl : $gradientLtr, $floatingCss);
			$floatingCss = str_replace('%%SIDE%%', is_rtl() ? 'left' : 'right', $floatingCss);
			$floatingCss = str_replace('%%PADD%%', is_rtl() ? '70px' : '64px', $floatingCss);

			wp_register_style(DRAGONIZER_NAME . '-floating-button', false);
			wp_enqueue_style(DRAGONIZER_NAME . '-floating-button');
			wp_add_inline_style(DRAGONIZER_NAME .  '-floating-button', $floatingCss);
		} else {
			if (
				!$this->true('disabled') and
				$this->true('modules_status', 'wp_tweaks') and
				$this->true('wp_tweaks', 'dashboard', 'status')
			) {
				wp_enqueue_style(DRAGONIZER_NAME . '-global', dr_url_to_relative(_dr(DRAGONIZER_ASE_URL, 'css', 'dragonizer-global.min.css')), array(), DRAGONIZER_VER, 'all');
			}
		}

		if ($this->font === 'default') return;

		$css_contents = DRFS::read(_dr(DRAGONIZER_ASE_DIR, 'css', "dragonizer-font-global-rtl.min.css"));

		if (!$css_contents) return;

		$css_contents = str_replace(['DRAGONIZER_ASE_URL', 'DRAGONIZER_FONT_NAME', 'DRAGONIZER_TITLE_FONT_NAME'], [DRAGONIZER_ASE_URL, $this->font, $this->font], $css_contents);

		wp_register_style(DRAGONIZER_NAME . '-font', false);
		wp_enqueue_style(DRAGONIZER_NAME . '-font');
		wp_add_inline_style(DRAGONIZER_NAME .  '-font', $css_contents);

		add_filter('tiny_mce_before_init', function ($init_array) {
			$css_file_path = DRAGONIZER_ASE_DIR . '/css/dragonizer-font-mce.min.css';

			$css_contents = file_get_contents($css_file_path);
			if (!$css_contents) {
				return $init_array;
			}

			$custom_css = str_replace(['DRAGONIZER_ASE_URL', 'DRAGONIZER_FONT_NAME', 'DRAGONIZER_TITLE_FONT_NAME'], [DRAGONIZER_ASE_URL, $this->font, $this->font], $css_contents);

			if (isset($init_array['content_style'])) {
				$init_array['content_style'] .= ' ' . $custom_css;
			} else {
				$init_array['content_style'] = $custom_css;
			}

			return $init_array;
		});
	}

	public function enqueue_scripts(): void
	{
		$screen_id = get_current_screen()->id ?: '';

		if (strpos($screen_id, 'dragonizer') !== false) {
			wp_enqueue_media();
			wp_enqueue_script('jquery');
			wp_enqueue_script('wp-color-picker');

			wp_enqueue_script(DRAGONIZER_NAME . '-addons', dr_url_to_relative(_dr(DRAGONIZER_ASE_URL, 'js', 'dragonizer-addons.min.js'), true), array(), DRAGONIZER_VER);
			wp_enqueue_script(DRAGONIZER_NAME . '-ajax', dr_url_to_relative(_dr(DRAGONIZER_ASE_URL, 'js', 'dragonizer-ajax.min.js'), true), array('jquery'), DRAGONIZER_VER);

			wp_localize_script(
				DRAGONIZER_NAME . '-ajax',
				'dragonizer_ajax_object',
				array(
					'is_rtl' => is_rtl(),

					'ajax_url'   => admin_url('admin-ajax.php'),
					'option_url' => admin_url('options.php'),
					'site_title' => get_bloginfo('name'),

					'msg_success_title' => __('Success', 'dragonizer'),
					'msg_success'       => __('Settings saved successfully', 'dragonizer'),
					'msg_failed_title'  => __('Failed', 'dragonizer'),
					'msg_failed'        => __('Saving settings failed', 'dragonizer'),
				)
			);
		}

		wp_enqueue_script(DRAGONIZER_NAME . '-menu', dr_url_to_relative(_dr(DRAGONIZER_ASE_URL, 'js', 'dragonizer-menu.min.js'), true), array('jquery'), DRAGONIZER_VER);
		wp_localize_script(DRAGONIZER_NAME . '-menu', 'dragonizer_menu_object', array('pro_tabs' => $this->hidden_menus));
	}
}
