<?php

// If this file is called directly, abort.
defined('WPINC') || die();

function display_maintenance($html_content, $settings)
{

	if ('maintenance' === $settings->site_status) {
		header('HTTP/1.1 503 Service Temporarily Unavailable');
		header('Status: 503 Service Temporarily Unavailable');
		header('Retry-After: 86400'); // Retry in a day.
	}

	$css_contents = DRFS::read(_dr(DRAGONIZER_ASE_DIR, 'css', 'dragonizer-font-global-rtl.min.css')) ?: '';
	$css_contents = str_replace(['DRAGONIZER_ASE_URL', 'DRAGONIZER_FONT_NAME', 'DRAGONIZER_TITLE_FONT_NAME', 'body.rtl '], [DRAGONIZER_ASE_URL, 'Estedad', 'Estedad', ''], $css_contents);

?>
	<!-- noptimize-page -->
	<!DOCTYPE html>
	<html>

	<head>
		<title><?php echo esc_html($html_content['title']); ?></title>
		<meta charset="UTF-8">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<?php if ('coming_soon' === $settings->site_status) : ?>
			<meta name="robots" content="noindex,follow" />
		<?php endif; ?>
		<link rel='stylesheet' id='colors-css' href='<?= DRAGONIZER_URL . 'assets/css/dragonizer-maintenance.min.css' ?>?ver=<?= DRAGONIZER_VER ?>' media='all' />
		<?php if (is_rtl()) { ?>
			<style type='text/css'>
				<?= $css_contents ?>
			</style>
		<?php } ?>
	</head>

	<body id="maintenance_page" class="<?php echo esc_attr($html_content['body_class']) ?: ''; ?>">
		<div id="content" class="<?php echo esc_attr($html_content['content_class']); ?>">
			<?= wp_kses_post(force_balance_tags($html_content['body'])); ?>
		</div>
		<img src="<?= DRAGONIZER_URL . 'app/partials/maintenance-template/maintenance.png' ?>">
	</body>

	</html>
<?php

}
