<?php

// If user not in admin area, abort.
defined('DRAGONIZER_ADMIN_INIT') || die();

function display_woo_optimizer($obj)
{
    $dragonizer_allowed_description_tags = array(
        'br'   => array(),
        'span' => array(
            'style' => array(),
        ),
    );

?>

    <input type="hidden" name="dragonizer_settings[woo_optimizer]" value="">

    <p class="dragon-hidden"><?php _e('This section has options to speed up and improve your store\'s performance, but it\'s up to you to decide which unnecessary features should be disabled.', 'dragonizer'); ?></p>

    <br>

    <!-- Bloat Section -->
    <h3 class="dragon-hidden"><?php esc_html_e('Remove Bloat', 'dragonizer'); ?>
        <span class="dragonizer_security_badge dragonizer_warning_badge">
            <?php esc_html_e('Usually safe', 'dragonizer'); ?>
        </span>
    </h3>
    <p class="dragon-hidden">
        <?php esc_html_e('Disable unnecessary WooCommerce features and functionality that may be slowing down your store. These options are generally safe to enable as they only remove optional features.', 'dragonizer'); ?>
    </p>

    <table class="dragon-hidden wp-list-table widefat fixed striped posts dragonizer_options-table dragonizer_cleanup-table">
        <thead>
            <tr>
                <td class="manage-column column-cb check-column "><input style="margin-top:4px!important" type="checkbox" name="check_all" <?php @checked(true, $obj->all_options_checked($obj->woo_optimizer_bloat, 'woo_optimizer'), true); ?>></td>
                <th class="column-title manage-column column-primary"><strong><?php esc_html_e('Options', 'dragonizer'); ?></strong></th>
                <th>
                    <string><?php esc_html_e('Explanation', 'dragonizer'); ?></string>
                </th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($obj->woo_optimizer_bloat as $dragonizer_option_slug => $dragonizer_option) { ?>
                <tr>
                    <th scope="row" class="check-column">
                        <input type="checkbox" name="dragonizer_settings[woo_optimizer][<?= $dragonizer_option_slug ?>]" id="<?php echo esc_attr($dragonizer_option_slug . '_fld'); ?>" <?php @checked(true, array_key_exists($dragonizer_option_slug, (is_array($obj->settings['woo_optimizer'] ?? null) ? $obj->settings['woo_optimizer'] : [])), true); ?>>
                    </th>
                    <td class="column-title column-primary"><strong><?php echo __($dragonizer_option['title'], 'dragonizer'); ?></strong>
                        <button type="button" class="toggle-row"><span class="screen-reader-text"><?php __('Show more details', 'dragonizer'); ?></span></button>
                    </td>
                    <td class="explanation-column" data-colname="<?php echo esc_attr(_e('Explanation', 'dragonizer')); ?>"><?php echo wp_kses(__($dragonizer_option['description'], 'dragonizer'), $dragonizer_allowed_description_tags); ?></td>
                </tr>

            <?php } ?>

        </tbody>
    </table>

    <!-- Interface Section -->
    <h3 class="dragon-hidden"><?php esc_html_e('Admin Interface', 'dragonizer'); ?>
        <span class="dragonizer_security_badge dragonizer_warning_badge">
            <?php esc_html_e('Usually safe', 'dragonizer'); ?>
        </span>
    </h3>
    <p class="dragon-hidden">
        <?php esc_html_e('Streamline your WordPress admin panel by removing unnecessary WooCommerce interface elements, notices, and widgets. These changes only affect the admin experience.', 'dragonizer'); ?>
    </p>

    <table class="dragon-hidden wp-list-table widefat fixed striped posts dragonizer_options-table dragonizer_cleanup-table">
        <thead>
            <tr>
                <td class="manage-column column-cb check-column "><input style="margin-top:4px!important" type="checkbox" name="check_all" <?php @checked(true, $obj->all_options_checked($obj->woo_optimizer_interface, 'woo_optimizer'), true); ?>></td>
                <th class="column-title manage-column column-primary"><strong><?php esc_html_e('Options', 'dragonizer'); ?></strong></th>
                <th>
                    <string><?php esc_html_e('Explanation', 'dragonizer'); ?></string>
                </th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($obj->woo_optimizer_interface as $dragonizer_option_slug => $dragonizer_option) { ?>
                <tr>
                    <th scope="row" class="check-column">
                        <input type="checkbox" name="dragonizer_settings[woo_optimizer][<?= $dragonizer_option_slug ?>]" id="<?php echo esc_attr($dragonizer_option_slug . '_fld'); ?>" <?php @checked(true, array_key_exists($dragonizer_option_slug, (is_array($obj->settings['woo_optimizer'] ?? null) ? $obj->settings['woo_optimizer'] : [])), true); ?>>
                    </th>
                    <td class="column-title column-primary"><strong><?php echo __($dragonizer_option['title'], 'dragonizer'); ?></strong>
                        <button type="button" class="toggle-row"><span class="screen-reader-text"><?php __('Show more details', 'dragonizer'); ?></span></button>
                    </td>
                    <td class="explanation-column" data-colname="<?php echo esc_attr(_e('Explanation', 'dragonizer')); ?>"><?php echo wp_kses(__($dragonizer_option['description'], 'dragonizer'), $dragonizer_allowed_description_tags); ?></td>
                </tr>

            <?php } ?>

        </tbody>
    </table>

    <!-- Performance Section -->
    <h3 class="dragon-hidden"><?php esc_html_e('Frontend Performance', 'dragonizer'); ?>
        <span class="dragonizer_security_badge dragonizer_danger_badge">
            <?php esc_html_e('Handle with care', 'dragonizer'); ?>
        </span>
    </h3>
    <p class="dragon-hidden">
        <?php esc_html_e('Optimize frontend performance by managing scripts, styles, and features that affect your store\'s public pages. These options can significantly impact site speed but should be tested thoroughly.', 'dragonizer'); ?>
    </p>
    <table class="dragon-hidden wp-list-table widefat fixed striped posts dragonizer_options-table dragonizer_cleanup-table">
        <thead>
            <tr>
                <td class="manage-column column-cb check-column "><input style="margin-top:4px!important" type="checkbox" name="check_all" <?php @checked(true, $obj->all_options_checked($obj->woo_optimizer_performance, 'woo_optimizer'), true); ?>></td>
                <th class="column-title manage-column column-primary"><strong><?php esc_html_e('Options', 'dragonizer'); ?></strong></th>
                <th>
                    <string><?php esc_html_e('Explanation', 'dragonizer'); ?></string>
                </th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($obj->woo_optimizer_performance as $dragonizer_option_slug => $dragonizer_option) { ?>
                <tr>
                    <th scope="row" class="check-column">
                        <input type="checkbox" name="dragonizer_settings[woo_optimizer][<?= $dragonizer_option_slug ?>]" id="<?php echo esc_attr($dragonizer_option_slug . '_fld'); ?>" <?php @checked(true, array_key_exists($dragonizer_option_slug, (is_array($obj->settings['woo_optimizer'] ?? null) ? $obj->settings['woo_optimizer'] : [])), true); ?>>
                    </th>
                    <td class="column-title column-primary"><strong><?php echo __($dragonizer_option['title'], 'dragonizer'); ?></strong>
                        <button type="button" class="toggle-row"><span class="screen-reader-text"><?php __('Show more details', 'dragonizer'); ?></span></button>
                    </td>
                    <td class="explanation-column" data-colname="<?php echo esc_attr(_e('Explanation', 'dragonizer')); ?>"><?php echo wp_kses(__($dragonizer_option['description'], 'dragonizer'), $dragonizer_allowed_description_tags); ?></td>
                </tr>

            <?php } ?>

        </tbody>
    </table>

    <!-- Advanced Section -->
    <h3 class="dragon-hidden"><?php esc_html_e('Core & Database Optimization', 'dragonizer'); ?>
        <span class="dragonizer_security_badge dragonizer_danger_badge">
            <?php esc_html_e('Handle with care', 'dragonizer'); ?>
        </span>
    </h3>
    <p class="dragon-hidden">
        <?php esc_html_e('Advanced optimizations that modify WooCommerce\'s core behavior, database queries, and data handling. These options can dramatically improve performance for large stores but should be thoroughly tested as they modify fundamental WooCommerce operations.', 'dragonizer'); ?>
    </p>

    <table class="dragon-hidden wp-list-table widefat fixed striped posts dragonizer_options-table dragonizer_cleanup-table">
        <thead>
            <tr>
                <td class="manage-column column-cb check-column "><input style="margin-top:4px!important" type="checkbox" name="check_all" <?php @checked(true, $obj->all_options_checked($obj->woo_optimizer_performance, 'woo_optimizer'), true); ?>></td>
                <th class="column-title manage-column column-primary"><strong><?php esc_html_e('Options', 'dragonizer'); ?></strong></th>
                <th>
                    <string><?php esc_html_e('Explanation', 'dragonizer'); ?></string>
                </th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($obj->woo_optimizer_advanced as $dragonizer_option_slug => $dragonizer_option) { ?>
                <tr>
                    <th scope="row" class="check-column">
                        <input type="checkbox" name="dragonizer_settings[woo_optimizer][<?= $dragonizer_option_slug ?>]" id="<?php echo esc_attr($dragonizer_option_slug . '_fld'); ?>" <?php @checked(true, array_key_exists($dragonizer_option_slug, (is_array($obj->settings['woo_optimizer'] ?? null) ? $obj->settings['woo_optimizer'] : [])), true); ?>>
                    </th>
                    <td class="column-title column-primary"><strong><?php echo __($dragonizer_option['title'], 'dragonizer'); ?></strong>
                        <button type="button" class="toggle-row"><span class="screen-reader-text"><?php __('Show more details', 'dragonizer'); ?></span></button>
                    </td>
                    <td class="explanation-column" data-colname="<?php echo esc_attr(_e('Explanation', 'dragonizer')); ?>"><?php echo wp_kses(__($dragonizer_option['description'], 'dragonizer'), $dragonizer_allowed_description_tags); ?></td>
                </tr>

            <?php } ?>

        </tbody>
    </table>

    <p class="dragon-hidden"><?php wp_kses(_e('<span style="color: #d94f4f">Notice: </span>Reload the page after saving changes to see the results!', 'dragonizer'), $dragonizer_allowed_description_tags); ?></p>

<?php
}
