<?php

// If user not in admin area, abort.
defined('DRAGONIZER_ADMIN_INIT') || die();

function display_ssl_secure($obj)
{
    $dragonizer_allowed_description_tags = array(
        'em'     => array(),
        'strong' => array(),
        'br'     => array(),
        'span'   => array(
            'style' => array()
        ),
        'a'      => array(
            'href' => array()
        ),
        'p'      => array(
            'style' => array()
        ),
        'bdo'    => array(
            'style' => array()
        )
    );
?>

    <input type="hidden" name="dragonizer_settings[ssl_secure]" value="">

    <?php

    if (dr_is_ssl()) : ?>

        <?php if (!DRFS::is_iis()) {


            if (!DRFS::is_openlitespeed() && (DRFS::is_apache() || DRFS::is_litespeed())) {
                $webserver = DRFS::get_webserver_name();
                $configfile = '.htaccess';
                $settings_arr = $obj->ssl_secure_options +  $obj->ssl_secure_configs_apache;
            } else {
                $webserver = DRFS::get_webserver_name();
                $settings_arr = $obj->ssl_secure_options +  $obj->ssl_secure_configs_apache;
                // $settings_arr = $obj->ssl_secure_options +  $obj->ssl_secure_configs_nginx;
                // handled in class-dragonizer-settings.php
            }

        ?>
            <input type="hidden" name="dragonizer_settings[ssl_secure][home]" value="<?= strtok(dr_simple_url(network_site_url()), '/') ?>">
            <input type="hidden" name="dragonizer_settings[ssl_secure][enabled]" value="on">

            <h3 class="dragon-hidden"><?php esc_html_e('HTTPS options', 'dragonizer'); ?> <span class="dragonizer_security_badge dragonizer_notice_badge"><?php esc_html_e('Mostly safe', 'dragonizer'); ?></span></h3>
            <p class="dragon-hidden"><?php esc_html_e("Control and fix site's HTTPS settings and URLs.", 'dragonizer'); ?></p>

            <table class="dragon-hidden wp-list-table widefat fixed striped posts dragonizer_options-table dragonizer_tweaks-table">
                <thead>
                    <tr>
                        <td class="manage-column column-cb check-column "><input style="margin-top:4px!important" type="checkbox" name="check_all" <?php @checked(true, $obj->all_options_checked($obj->ssl_secure_options, 'ssl_secure', ['htaccess_php', 'nginx_php']), true); ?>></td>
                        <th class="column-title manage-column column-primary"><strong><?php esc_html_e('Options', 'dragonizer'); ?></strong></th>
                        <th>
                            <string><?php esc_html_e('Explanation', 'dragonizer'); ?></string>
                        </th>
                    </tr>
                </thead>

                <tbody>
                    <?php foreach ($settings_arr as $dragonizer_option_slug => $dragonizer_option) {

                        if (empty($dragonizer_option['type'])) {

                            $disable = '';
                            if ($dragonizer_option_slug == 'htaccess_remove_www' && dr_starts_with(strtolower(dr_to_https(site_url())), 'https://www')) {
                                $title = 'title="' . __('The default address of your site is www, so it is not recommended to remove www from the address', 'dragonizer') . '"';
                                $disable = ($dragonizer_option_slug == 'htaccess_remove_www') ? $title . ' disabled locked' : '';
                            }

                            // Instead of using @checked, perform an isset check and then use checked.
                            $is_checked = isset($obj->settings['ssl_secure'][$dragonizer_option_slug]) && $obj->settings['ssl_secure'][$dragonizer_option_slug] === 'on';
                            $checked_attribute = $disable === '' ? checked(true, $is_checked, false) : 'disabled="disabled"';

                    ?>
                            <tr>
                                <th scope="row" class="check-column">
                                    <input type="checkbox" name="dragonizer_settings[ssl_secure][<?= $dragonizer_option_slug ?>]" <?= $disable ?> id="<?= esc_attr($dragonizer_option_slug . '_fld') ?>" <?= $checked_attribute ?>>

                                </th>
                                <td class="column-title column-primary"><strong><?php echo __($dragonizer_option['title'], 'dragonizer'); ?></strong>
                                    <button type="button" class="toggle-row"><span class="screen-reader-text"><?php __('Show more details', 'dragonizer'); ?></span></button>
                                </td>
                                <td class="explanation-column" data-colname="<?php echo esc_attr(_e('Explanation', 'dragonizer')); ?>"><?php echo wp_kses(__($dragonizer_option['description'], 'dragonizer'), $dragonizer_allowed_description_tags); ?></td>
                            </tr>
                        <?php
                        } elseif ($dragonizer_option['type'] === 'select') {

                        ?>
                            <tr>
                                <th scope="row" class="check-column">
                                    <input type="checkbox" checked disabled locked id="<?php echo esc_attr($dragonizer_option_slug . '_fld_chk'); ?>">
                                </th>
                                <td class="column-title column-primary">
                                    <strong><?php echo __($dragonizer_option['title'], 'dragonizer'); ?></strong>
                                    <button type="button" class="toggle-row">
                                        <span class="screen-reader-text"><?php __('Show more details', 'dragonizer'); ?></span>
                                    </button>
                                </td>
                                <td class="explanation-column" data-colname="<?php echo esc_attr(_e('Explanation', 'dragonizer')); ?>">
                                    <select name="dragonizer_settings[ssl_secure][<?= $dragonizer_option_slug ?>]">
                                        <?php
                                        foreach ($dragonizer_option['types'] as $value) {
                                            $is_selected = isset($obj->settings['ssl_secure'][$dragonizer_option_slug]) && $obj->settings['ssl_secure'][$dragonizer_option_slug] == $value;
                                        ?>
                                            <option value='<?= $value ?>' <?= selected($is_selected, true, false) ?>><?= $value ?></option>
                                        <?php
                                        }
                                        ?>
                                    </select> <span style="color:green!important"><?= $dragonizer_option['description'] ?></span>
                                </td>
                            </tr>
                    <?php
                        }
                    } ?>
                </tbody>
            </table>

            <?php

            if (!DRFS::is_openlitespeed() && (DRFS::is_apache() || DRFS::is_litespeed())) { ?>
                <p class="dragon-hidden" style="margin-top:-40px;margin-bottom:60px;"><?php printf(__("<span style='color: #d94f4f'>Notice: </span>Your site powered on <bdo style='direction:ltr'><strong>%s</strong></bdo> webserver and configs of this section will be saved in the <bdo style='direction:ltr'><strong>%2s</strong></bdo> file.", 'dragonizer'), $webserver, $configfile); ?></p>
            <?php } else { ?>
                <p class="dragon-hidden" style="margin-top:-40px;margin-bottom:60px;"><?php printf(__("<span style='color: #d94f4f'>Notice: </span>Your site powered on <bdo style='direction:ltr'><strong>%s</strong></bdo> webserver and configs of this section handle by <bdo style='direction:ltr'><strong>advanced-http-headers.php</strong></bdo> file.", 'dragonizer'), $webserver); ?></p>
            <?php } ?>
        <?php } ?>

        <h3 class="dragon-hidden"><?php esc_html_e('Secure HTTP headers', 'dragonizer'); ?> <span class="dragonizer_security_badge dragonizer_safe_badge"><?php esc_html_e('Completely safe', 'dragonizer'); ?></span></h3>

        <p class="dragon-hidden"><?php esc_html_e("This step is important to submit your website and/or domain to an approved HSTS list. Google officially compiles this list and it is used by Chrome, Firefox, Opera, Safari, IE11 and Edge. It will also help you mitigate attacks on your Wordpress site.", 'dragonizer'); ?></p>

        <table class="dragon-hidden wp-list-table widefat fixed striped posts dragonizer_options-table dragonizer_tweaks-table">
            <thead>
                <tr>
                    <td class="manage-column column-cb check-column "><input style="margin-top:4px!important" type="checkbox" name="check_all" <?php @checked(true, $obj->all_options_checked($obj->ssl_secure_settings, ['ssl_secure', 'http_headers']), true); ?>></td>
                    <th class="column-title manage-column column-primary"><strong><?php esc_html_e('Options', 'dragonizer'); ?></strong></th>
                    <th>
                        <string><?php esc_html_e('Explanation', 'dragonizer'); ?></string>
                    </th>
                </tr>
            </thead>

            <tbody>
                <?php foreach ($obj->ssl_secure_settings as $dragonizer_option_slug => $dragonizer_option) { ?>
                    <tr>
                        <th scope="row" class="check-column">
                            <?php if ($dragonizer_option_slug === 'permissions_policy') { ?>
                                <input type="checkbox" name="dragonizer_settings[ssl_secure][http_headers][<?= $dragonizer_option_slug  ?>][status]" id="<?php echo esc_attr($dragonizer_option_slug . '_fld'); ?>" <?php @checked(true, $obj->true('ssl_secure', 'http_headers', 'permissions_policy', 'status'), true);  ?>>
                            <?php } else { ?>
                                <input type="checkbox" name="dragonizer_settings[ssl_secure][http_headers][<?= $dragonizer_option_slug  ?>]" id="<?php echo esc_attr($dragonizer_option_slug . '_fld'); ?>" <?php @checked(true, $obj->true('ssl_secure', 'http_headers', $dragonizer_option_slug), true); ?>>
                            <?php }  ?>
                        </th>
                        <td class="column-title column-primary"><strong><?php echo __($dragonizer_option['title'], 'dragonizer'); ?><?php if ($dragonizer_option_slug === 'permissions_policy') { ?><a id="set_permissions_policy" href="#"><span class="dashicons dashicons-admin-settings" style="font-size: 24px;padding: 5px;margin-top: -7px;"></span></a> <?php } ?></strong>

                            <button type="button" class="toggle-row"><span class="screen-reader-text"><?php __('Show more details', 'dragonizer'); ?></span></button>
                        </td>
                        <td class="explanation-column" data-colname="<?php echo esc_attr(_e('Explanation', 'dragonizer')); ?>"><?php echo wp_kses(__($dragonizer_option['description'], 'dragonizer'), $dragonizer_allowed_description_tags); ?></td>
                    </tr>
                <?php } ?>
            </tbody>

        </table>

        <?php

        $https_home_url =  get_home_url(false, '', 'https');

        if (!dr_is_localhost()) {
            $security_headers = "https://securityheaders.com/?q=$https_home_url&hide=on&followRedirects=on";
            $text = sprintf(__('<span style="color: #d94f4f">Notice: </span>Click this <a href="%s" target="_blank" style="text-decoration:none;background-color:lightgoldenrodyellow;border-radius:5px;">link</a> (securityheaders.com) for <strong>check</strong> the HTTP <strong>security headers</strong> of your site.', 'dragonizer'), $security_headers);
        ?><p class="dragon-hidden" style="margin-top:-2rem"><?= $text ?></p><br><br>

        <?php } ?>

        <style type="text/css">
            .drag-dr-modal {
                position: fixed;
                text-align: center;
                z-index: 99999999;
                top: 0;
                right: 0;
                bottom: 0;
                left: 0;
                display: none;
                background: -webkit-radial-gradient(top left, rgba(0, 0, 0, 0.6), rgba(0, 0, 0, 0.05));
                background: -moz-radial-gradient(top left, rgba(0, 0, 0, 0.6), rgba(0, 0, 0, 0.05));
                background: radial-gradient(to bottom right, rgba(0, 0, 0, 0.6), rgba(0, 0, 0, 0.05));
                backdrop-filter: blur(3px);
                box-sizing: border-box;
                overflow: hidden
            }

            .drag-dr-modal table {
                margin-left: auto;
                margin-right: auto;
                border-collapse: collapse;
                border-spacing: 30px;
                padding: 5px;
                border-spacing: 10px;
            }

            .drag-dr-modal table td {
                padding: 3px;
            }

            .drag-dr-modal * {
                box-sizing: border-box
            }

            .drag-dr-modal-wrap {
                max-width: 480px;
                width: 100%;
                position: relative;
                margin-left: auto;
                margin-right: auto;
                margin-top: 5%;
                background: #fff;
                border-radius: 8px;
                overflow: hidden
            }

            .drag-dr-modal-header {
                border-bottom: 1px solid #E8E8E8;
                padding: 20px 20px 18px 20px
            }

            .drag-dr-modal-header h3 {
                line-height: 1.8;
                margin: 0;
                color: #4A5568
            }

            .drag-dr-modal-body {
                padding: 5px 20px 20px 20px
            }

            .drag-dr-modal-footer {
                border-top: 1px solid #E8E8E8;
                padding: 20px;
                text-align: center
            }

            .drag-dr-button-secondary {
                border: 1px solid #EBEBEB;
                border-radius: 3px;
                font-size: 13px;
                line-height: 1.5;
                padding: 5px 12px;
                cursor: pointer;
                background-color: transparent;
                text-decoration: none
            }

            .drag-dr-submit-modal {
                border: 1px solid #9d0110;
                background-color: #9d0110;
                border-radius: 3px;
                font-size: 13px;
                line-height: 1.5;
                color: #fff;
                padding: 5px 12px;
                cursor: pointer;
                margin-left: 4px
            }

            .drag-dr-hidden {
                opacity: 0;
                display: none
            }

            .drag-dr-over-disabled {
                height: 100%;
                width: 100%;
                opacity: 0.5;
                background-color: #c3c4c7;
                position: absolute;
                z-index: 999999
            }
        </style>

        <div class="drag-dr-modal" id="dragonizer-drag-dr-modal">
            <div class="drag-dr-modal-wrap">
                <div class="drag-dr-over-disabled drag-dr-hidden"></div>
                <div class="drag-dr-modal-header">
                    <h3><?php _e('You can change the value for each directive.', 'dragonizer'); ?></h3>
                </div>

                <div class="drag-dr-modal-body">
                    <table>
                        <tbody>
                            <tr style="line-height: 45px;">
                                <th><strong><?= __('Feature', 'dragonizer') ?></strong></th>
                                <th style="min-width:50px;"><strong><?= __('allowed', 'dragonizer') ?></strong></th>
                                <th style="min-width:50px;"><strong><?= __('self', 'dragonizer') ?></strong></th>
                                <th style="min-width:50px;"><strong><?= __('none', 'dragonizer') ?></strong></th>
                            </tr>

                            <?php

                            $def = ['accelerometer' => 'self', 'autoplay' => 'self', 'camera' => 'self', 'encrypted-media' => 'self', 'fullscreen' => 'self', 'geolocation' => 'self', 'gyroscope' => 'self', 'magnetometer' => 'self', 'microphone' => 'self', 'midi' => 'self', 'payment' => 'self', 'picture-in-picture' => 'self', 'sync-xhr' => 'self', 'usb' => 'self'];
                            $dbb = $obj->get('ssl_secure', 'http_headers', 'permissions_policy', 'values') ?: [];
                            unset($dbb['status']);
                            $sett = array_merge($def, $dbb);

                            foreach ($obj->ssl_secure_permissions_policies as $dragonizer_option_slug => $dragonizer_option) {

                                $a_allowed = (isset($sett[$dragonizer_option_slug]) && $sett[$dragonizer_option_slug] === 'allowed');
                                $a_self    = (isset($sett[$dragonizer_option_slug]) && $sett[$dragonizer_option_slug] === 'self');
                                $a_none    = (isset($sett[$dragonizer_option_slug]) && $sett[$dragonizer_option_slug] === 'none');
                            ?>
                                <tr>
                                    <td><strong><?php echo __($dragonizer_option['title'], 'dragonizer'); ?></strong></td>
                                    <td><input type="radio" name="<?= $dragonizer_option_slug ?>" data-name="dragonizer_settings[ssl_secure][http_headers][permissions_policy][values][<?= $dragonizer_option_slug ?>]" value="allowed" <?php @checked(true, $a_allowed, true); ?>></td>
                                    <td><input type="radio" name="<?= $dragonizer_option_slug ?>" data-name="dragonizer_settings[ssl_secure][http_headers][permissions_policy][values][<?= $dragonizer_option_slug ?>]" value="self" <?php @checked(true, $a_self, true); ?>></td>
                                    <td><input type="radio" name="<?= $dragonizer_option_slug ?>" data-name="dragonizer_settings[ssl_secure][http_headers][permissions_policy][values][<?= $dragonizer_option_slug ?>]" value="none" <?php @checked(true, $a_none, true); ?>></td>
                                </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>

                <div class="drag-dr-modal-footer">
                    <button type="button" class="drag-dr-submit-modal"><?php _e('Save permission polic', 'dragonizer'); ?></button>
                    <button type="button" class="drag-dr-cancel-modal drag-dr-button-secondary"><?php _e('Cancel', 'dragonizer'); ?></button>
                </div>
            </div>
        </div>

        <script type="text/javascript">
            (function($) {

                $(document).ready(function() {

                    var dra_loader = $('.dragonizer_tab_group #loader-wrapper');

                    $.fn.shake = function(interval = 100, distance = 10, times = 4) {
                        var jTarget = $(this);
                        jTarget.css('position', 'relative');
                        for (var iter = 0; iter < (times + 1); iter++) {
                            jTarget.animate({
                                left: ((iter % 2 == 0 ? distance : distance * -1))
                            }, interval);
                        }
                        return jTarget.animate({
                            left: 0
                        }, interval);
                    }

                    // Force checkbox checked
                    $('#htaccess_php_fld_chk').prop("checked", true);

                    var modal = $('#dragonizer-drag-dr-modal');
                    var wrap = $('.drag-dr-modal-wrap');

                    // Open modal
                    $('#set_permissions_policy').on('click', function(e) {
                        e.preventDefault();
                        modal.fadeIn('250');
                    });

                    // Close modal; Cancel
                    modal.on('click', 'button.drag-dr-cancel-modal', function(e) {
                        e.preventDefault();
                        modal.fadeOut('250');
                    })

                    modal.on('click', function(e) {
                        e.preventDefault();
                        wrap.shake();
                    }).on('click', 'div', function(e) {
                        e.stopPropagation();
                    });

                    // Submit normal
                    modal.on('click', 'button.drag-dr-submit-modal', function(e) {
                        e.preventDefault();

                        var button = $(this);

                        var permissions_array = {};

                        $('input[type="radio"][data-name^="dragonizer_settings[ssl_secure][http_headers][permissions_policy][values]"]:checked').each(function(index, item) {
                            var dataName = $(item).attr('data-name').replace('dragonizer_settings[ssl_secure][http_headers][permissions_policy][values][', '').replace(']', '')
                            var value = $(item).val();
                            permissions_array[dataName] = value;
                            permissions_array[dataName] = value;

                        });

                        // $(".drag-dr-modal-wrap").find("div").first().removeClass("drag-dr-hidden");

                        $.ajax({
                            url: ajaxurl,
                            type: 'POST',
                            data: {
                                action: 'dragonizer_submit_permissions_policy',
                                permissions_array: permissions_array
                            },
                            beforeSend: function() {
                                dra_loader.removeClass('loaded');
                                button.text('<?= __('Processing...', 'dragonizer') ?>');
                                button.addClass('disabled');
                            },
                            complete: function() {
                                dra_loader.addClass('loaded');
                                button.text('<?= __('Save permission polic', 'dragonizer') ?>');
                                button.removeClass('disabled');
                            },
                            error: function error(err) {
                                console.log("Error code: ", err.status + " - Error msg : " + err.statusText);
                                toastr["error"]("<?= __('Saving settings failed', 'dragonizer') ?>", "<?= __('Failed', 'dragonizer') ?>");
                            },
                            success: function success(response) {
                                toastr["success"]("<?= __('Settings saved successfully', 'dragonizer') ?>", "<?= __('Success', 'dragonizer') ?>");
                            }

                        });

                    });
                });
            }(jQuery));
        </script>

        <?php

        function get_certificate_info()
        {
            $certinfo = false;

            $url = home_url(null, 'https');
            $orignal_parse = parse_url($url, PHP_URL_HOST);

            set_error_handler(function ($errno, $errstr, $errfile, $errline) {
                throw new ErrorException($errstr, 0, $errno, $errfile, $errline);
            }, E_WARNING);

            try {
                $get = stream_context_create(array("ssl" => array("capture_peer_cert" => TRUE)));

                if ($get == 0 || empty($get) || $get == null || $get == false) {
                    throw new Exception('error');
                }

                $read = stream_socket_client("ssl://" . $orignal_parse . ":443", $errno, $errstr, 30, STREAM_CLIENT_CONNECT, $get);
                $cert = stream_context_get_params($read);
                $certificate = openssl_x509_parse($cert['options']['ssl']['peer_certificate']);

                $time = $certificate['validTo_time_t'];

                $year  = date("Y", $time);
                $month = date("m", $time);
                $day   = date("d", $time);

                $full  = date("Y/m/d", $time);
                $today = date('Y/m/d');

                $diference = @(new DateTime($full))->diff(new DateTime($today))->days ?? '-1';

                $my_domain  = explode('/', dr_simple_url(dr_current_url()))[0];
                $ssl_domain = $certificate['subject']['CN'];
                $domain     = $my_domain === $ssl_domain ? $my_domain : "*.$my_domain";

                $certinfo = array(
                    'isvalid' => true,
                    'issuer'  => $certificate['issuer']['O'],
                    'domain'  => $domain,
                    'expiry'  => (get_locale() === 'fa_IR' ? dr_to_shamsi($year, $month, $day) : $full) . sprintf(__("  (%s Days)", 'dragonizer'), $diference),
                );
            } catch (Exception $e) {

                $tmp = explode(':', $e->getMessage());
                $parts = array_pop($tmp);

                // $parts = array_pop(explode(':', $msg));
                $certinfo = array(
                    'isvalid'            =>    false,
                    'domain'            =>    $_SERVER['HTTP_HOST'],
                    'message'            =>    $parts,
                );
            }

            return $certinfo;
        }

        $certinfo = get_certificate_info();
        $direcx   = is_rtl() ? 'right' : 'left';
        $padd     = is_rtl() ? 'padding:5px 0 5px 15px;' : 'padding:5px 15px 5px 0;';

        ?>

        <?php if (!empty($certinfo['isvalid'])) : ?>
            <div class="dragon-hidden" style="text-align: center;">
                <div style="vertical-align: middle;border:1px #cccccc solid; border-radius: 8px; <?= $padd ?>display:inline-block;">
                    <div style="float:<?= $direcx ?>">
                        <span style=" width:100%;font-size: 90px; color:green!important;" class="dashicons dashicons-lock"></span>
                    </div>
                    <div style="float:left;">
                        <div style="line-height:2em">
                            <bdo style="font-weight:bold; font-size:150%;direction:ltr"><?php echo str_replace('www.', '', $certinfo['domain']); ?></bdo><br />
                            <?php echo sprintf(__('Issued by: %s', 'dragonizer'), $certinfo['issuer']); ?><br />
                            <?php echo sprintf(__('Expires: %s', 'dragonizer'), $certinfo['expiry']); ?><br />
                            <span class="dragonizer-success"><i class="dashicons dashicons-saved"></i> <?php _e('Certificate is valid', 'dragonizer'); ?></span>
                        </div>
                    </div>
                    <br class="clear" />
                </div>
            </div>
        <?php else : ?>
            <div class="dragon-hidden" style="text-align: center;">
                <div style="vertical-align: middle;border:1px #cccccc solid; border-radius: 8px;<?= $padd ?> display:inline-block;">
                    <div style="float:<?= $direcx ?>">
                        <span style=" width:100%;font-size: 90px; color: red;" class="dashicons dashicons-unlock"></span>
                    </div>
                    <div style="float:left;">
                        <p>
                            <bdo style="font-weight:bold; font-size:150%;direction:ltr"><?php echo str_replace('www.', '', $certinfo['domain']); ?></bdo><br />
                            <br />
                            <span class="dragonizer-error"><i class="dashicons dashicons-no-alt"></i> <?php _e('Certificate is not valid', 'dragonizer'); ?></span>
                        </p>
                    </div>
                    <br class="clear" />
                </div>
            </div>
        <?php endif; ?>

        <?php else :

        $settings['ssl_secure'] = $obj->get('ssl_secure');

        if (is_array($settings['ssl_secure'])) {
            $settings['ssl_secure']['enabled'] = 'off';
            $obj->save_settings($settings);
        }

        $callback = is_multisite() ? 'is_plugin_active_for_network' : 'is_plugin_active';

        $plugins = array_filter($obj->bad_plugins['ssl'], $callback);

        if (count($plugins) > 0) { ?>
            <p class="dragon-hidden" style="font-size: larger;"><i style="margin:5px;color:orange" class="dashicons dashicons-admin-plugins"></i><?php _e('To use this section, please <strong>disable</strong> the following plugins first. There are all features of these plugins with better performance in Dragonizer.', 'dragonizer'); ?></p>
            <table class="dragon-hidden" style="margin:0 auto; border-spacing: 5px;text-align: left;">
                <tbody>
                    <?php
                    foreach ($plugins as $plugin) {
                        $plugin_data = get_plugin_data(WP_PLUGIN_DIR . DIRECTORY_SEPARATOR . $plugin);
                    ?>
                        <tr>
                            <td><strong><span style="text-decoration: line-through;text-decoration-color: red;"><?= esc_attr($plugin_data['Name']) ?></span></strong></td>
                            <td><a href="<?= esc_url_raw(wp_nonce_url(admin_url('admin-post.php?action=deactivate_plugin&plugin=' . rawurlencode($plugin)), 'deactivate_plugin')) ?>" style="line-height: 22px!important;" class="button button-secondaty deactive-bad-plugins"><?= esc_html__('Deactivate', 'dragonizer') ?><span class="dashicons dashicons-trash"></span></a></td>
                        </tr>
                    <?php
                    }
                    ?>
                </tbody>
            </table>

            <script>
                (function($) {
                    $(function() {
                        $('a.deactive-bad-plugins').on('click', function() {
                            $('.dragonizer_tab_group #loader-wrapper').removeClass('loaded');
                        });
                    });
                })(jQuery);
            </script>

        <?php
        } else {

        ?>
            <div class="notice notice-warning">
                <h3><?php esc_html_e('Secure Connection Required', 'dragonizer'); ?></h3>
                <p><?php esc_html_e('To access and modify SSL settings, you must access this page using HTTPS. Please switch to a secure connection.', 'dragonizer'); ?></p>

                <div class="wrap about-wrap dragonizer-ssl dragonizer-ssl-setup">
                    <div class="feature-section">
                        <p>
                            <?php
                            $secure_url = str_replace('http://', 'https://', esc_url($_SERVER['REQUEST_URI']));
                            printf(
                                /* translators: %s: Secure URL */
                                esc_html__('Click here to access this page securely: %s', 'dragonizer'),
                                sprintf(
                                    '<a href="%s">%s</a>',
                                    esc_url($secure_url),
                                    esc_html__('Secure Access', 'dragonizer')
                                )
                            );
                            ?>
                        </p>
                        <p class="description">
                            <?php esc_html_e('SSL/HTTPS is required to ensure secure communication when configuring SSL settings.', 'dragonizer'); ?>
                        </p>
                    </div>
                </div>
            </div>
    <?php
        }

    endif; ?>

<?php
}
