<?php

// If user not in admin area, abort.
defined('DRAGONIZER_ADMIN_INIT') || die();

function display_object_cache($obj)
{
    $dragonizer_allowed_description_tags = array(
        'br'   => array(),
        'bdo' => array(
            'style' => array(),
        ),
        'span' => array(
            'style' => array(),
        ),
    );

    $callback = is_multisite() ? 'is_plugin_active_for_network' : 'is_plugin_active';

    $plugins = array_filter($obj->bad_plugins['object_cache'], $callback);

    if (count($plugins) > 0) {
        $obj->modules_status['object_cache'] = '0';
        $obj->save_settings(['modules_status' => $obj->modules_status]);
?>
        <p style="font-size: larger;"><i style="margin:5px;color:orange" class="dashicons dashicons-admin-plugins"></i><?php _e('To use this section and avoid any possible disruption, you must first <strong>disable</strong> the following plugins.', 'dragonizer'); ?></p>
        <table style="margin:0 auto; border-spacing: 5px;text-align: left;">
            <tbody>
                <?php
                foreach ($plugins as $plugin) {
                    $plugin_data = get_plugin_data(WP_PLUGIN_DIR . DIRECTORY_SEPARATOR . $plugin);
                ?>
                    <tr>
                        <td><strong><span style="text-decoration: line-through;text-decoration-color: red;"><?= esc_attr($plugin_data['Name']) ?></span></strong></td>
                        <td><a href="<?= esc_url_raw(wp_nonce_url(admin_url('admin-post.php?action=deactivate_plugin&plugin=' . rawurlencode($plugin)), 'deactivate_plugin')) ?>" style="line-height: 22px!important;" class="button button-secondaty deactive-bad-plugins"><?= esc_html__('Deactivate', 'dragonizer') ?><span class="dashicons dashicons-trash"></span></a></td>
                    </tr>
                <?php
                }
                ?>
            </tbody>
        </table>

        <script>
            (function($) {
                $(function() {
                    $('div.toggle-btn').remove();
                    $('p.submit').remove();
                    $('div.pro-disabled').removeClass('pro-disabled');
                    $('a.deactive-bad-plugins').on('click', function() {
                        $('.dragonizer_tab_group #loader-wrapper').removeClass('loaded');
                    });
                });
            })(jQuery);
        </script>

    <?php
    } else {

    ?>
        <style>
            input[type="text"],
            input[type="number"],
            select,
            textarea {
                direction: ltr !important;
                text-align: left !important;
            }

            .textarea-container {
                position: relative;
            }

            .textarea-container textarea {
                padding: 10px;
                box-sizing: border-box;
            }

            .textarea-container .set-default {
                position: absolute;
                top: 8px;
                right: 8px;
                cursor: pointer;
                color: #555;
            }

            .textarea-container .set-default:hover {
                color: #9d0110;
            }
        </style>

        <script>
            jQuery(document).ready(function($) {

                var textareas = $('textarea');

                function adjustTextareaHeight(textarea) {
                    var extraSpace = 20; // Extra space in pixels
                    textarea.css('height', 'auto');
                    var newHeight = textarea.prop('scrollHeight') + extraSpace; // Add extra space to the scrollHeight
                    textarea.css('height', newHeight + 'px');
                }

                textareas.on('input', function() {
                    adjustTextareaHeight($(this));
                });

                $('.set-default').on('click', function() {
                    var target = $(this).data('target');
                    console.log("Setting default values for: ", target);

                    var defaultValue = '';
                    if (target === '#groups_fld') {
                        defaultValue = "rss\nusers\nuserlogins\nuseremail\nuserslugs\nusermeta\nuser_meta\nsite-transient\nsite-options\nsite-lookup\nsite-details\nblog-lookup\nblog-details\nblog-id-cache\nglobal-posts\nglobal-cache-test";
                    } else if (target === '#excluded_fld') {
                        defaultValue = "comment\ncounts\nplugins\nwc_session_id";
                    }
                    $(target).val(defaultValue);
                    adjustTextareaHeight($(target));
                });

                // Function to handle the visibility of form fields based on cache type
                function updateFormVisibility(isChange) {
                    var cacheType = $('select[name="dragonizer_settings[object_cache][object_cache_type]"]').val();

                    // Determine whether to show or hide Redis ID field and adjust port
                    switch (cacheType) {
                        case 'Redis':
                            $('#connection_test_fld').show();
                            if (isChange) $('#connection_status_fld').html('<span id="connection_status_fld" style="color:blue"><?php echo esc_js(__('Unknown', 'dragonizer')); ?></span>'); // Removed redundant span ID
                            $('#persistence_fld').closest('tr').show();
                            $('#redis_id_fld').closest('tr').show();
                            if (isChange) $('#port_fld').val('6379'); // Set port for Redis
                            break;
                        case 'Memcached':
                            $('#connection_test_fld').show();
                            if (isChange) $('#connection_status_fld').html('<span id="connection_status_fld" style="color:blue"><?php echo esc_js(__('Unknown', 'dragonizer')); ?></span>'); // Removed redundant span ID
                            $('#persistence_fld').closest('tr').show();
                            $('#redis_id_fld').closest('tr').hide();
                            if (isChange) $('#port_fld').val('11211'); // Set port for Memcached
                            break;
                        default:
                            $('#connection_test_fld').hide();
                            if (isChange) $('#connection_status_fld').html('<span id="connection_status_fld" style="color:blue"><?php echo esc_js(__('Unknown', 'dragonizer')); ?></span>'); // Removed redundant span ID
                            $('#persistence_fld').closest('tr').hide();
                            $('#redis_id_fld').closest('tr').hide();
                            $('#port_fld').val(''); // Clear port for other options
                            break;
                    }

                    // Determine visibility for hostname, port, username, and password fields
                    if (cacheType === 'Disable') {
                        $('#table_object_redis_memcached').hide();
                        $('#table_object_options').hide();
                    } else {

                        if (cacheType === 'Redis' || cacheType === 'Memcached') {
                            $('#table_object_redis_memcached').show();
                        } else {
                            $('#table_object_redis_memcached').hide();
                        }

                        if (isChange) $('#lifetime_fld').val('360');
                        $('#table_object_options').show();
                    }

                    textareas.each(function() {
                        adjustTextareaHeight($(this));
                    });
                }

                // Bind the change event to the cache type select box
                $('select[name="dragonizer_settings[object_cache][object_cache_type]"]').change(function() {
                    updateFormVisibility(true); // Call with 'true' on selection change
                });

                // Initial call without changing ports
                updateFormVisibility(false);
            });
        </script>

        <input type="hidden" name="dragonizer_settings[object_cache]" value="">

        <div id="table_object_main">
            <h3 class="dragon-hidden"><?php esc_html_e('Object Cache Settings', 'dragonizer'); ?><span class="dragonizer_security_badge dragonizer_danger_badge"><?php esc_html_e('Beta', 'dragonizer'); ?></span></h3>
            <p class="dragon-hidden"><?php esc_html_e('Enabling object caching enhances WordPress performance by storing frequent database queries in memory, reducing server load and speeding up page loads, ideal for high-traffic or database-heavy websites.', 'dragonizer'); ?></p>

            <div class="dragon-hidden dragonizer-warning-box" style="text-align:justify;padding:20px">
                <p style="font-size: 14px; line-height: 1.5; margin: 0 0 15px; color: #444;">
                    <?php _e('<strong style="color: #ff4d4d">Warning:</strong> Object caching on shared hosting is generally not recommended. It is better to enable this feature only on VPS or dedicated servers. Reasons for this recommendation include:', 'dragonizer'); ?>
                </p>
                <ul style="font-size: 14px; line-height: 1.5; margin: 0; padding-left: 20px; color: #444;">
                    <li style="list-style: circle;margin: 0 30px 10px;"><?php _e('<b>Resource limitations: </b>Object caching systems like Redis or Memcached can increase CPU usage by up to 20% and RAM consumption by up to 30%. On shared hosting, where resources are limited, this increased usage, especially during peak traffic times, can significantly reduce your site’s speed and performance.', 'dragonizer'); ?></li>
                    <li style="list-style: circle;margin: 0 30px 10px;"><?php _e('<b>Security concerns: </b>On shared hosting, one physical server is typically divided among 200 to 500 sites (depending on the configuration). Ensuring complete security and data isolation between different sites’ cached data is nearly impossible, posing a risk of unauthorized access to your sensitive information by other users (malicious actors) on the shared host.', 'dragonizer'); ?></li>
                </ul>
                <p style="font-size: 14px; line-height: 1.5; margin: 0 0 15px; color: #444;">
                    <?php _e('So it is recommended to carefully review your hosting conditions and limitations before enabling this feature, and consult with your hosting provider’s support team if necessary.', 'dragonizer'); ?>
                </p>
            </div>


            <table class="dragon-hidden wp-list-table widefat fixed striped posts dragonizer_options-table dragonizer_cleanup-table">
                <thead>
                    <tr>
                        <th style="width:10%" class="column-title manage-column column-primary"><strong><?php esc_html_e('Options', 'dragonizer'); ?></strong></th>
                        <th>
                            <string><?php esc_html_e('Explanation', 'dragonizer'); ?></string>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($obj->object_cache as $dragonizer_option_slug => $dragonizer_option) {
                        if (empty($dragonizer_option['type'])) {
                    ?>
                            <tr>

                                <td class="column-title column-primary"><strong><?php echo __($dragonizer_option['title'], 'dragonizer'); ?></strong>
                                    <button type="button" class="toggle-row"><span class="screen-reader-text"><?php __('Show more details', 'dragonizer'); ?></span></button>
                                </td>
                                <td class="explanation-column" data-colname="<?php echo esc_attr(_e('Explanation', 'dragonizer')); ?>"><?php echo wp_kses(__($dragonizer_option['description'], 'dragonizer'), $dragonizer_allowed_description_tags); ?></td>
                            </tr>
                        <?php
                        } elseif ($dragonizer_option['type'] === 'select') {
                        ?>
                            <tr>

                                <td class="column-title column-primary">
                                    <strong><?php echo __($dragonizer_option['title'], 'dragonizer'); ?></strong>
                                    <button type="button" class="toggle-row">
                                        <span class="screen-reader-text"><?php __('Show more details', 'dragonizer'); ?></span>
                                    </button>
                                </td>
                                <td class="explanation-column" data-colname="<?php echo esc_attr(_e('Explanation', 'dragonizer')); ?>">
                                    <select name="dragonizer_settings[object_cache][<?= $dragonizer_option_slug  ?>]">
                                        <?php

                                        $msg = '';

                                        if (extension_loaded('memcached')) {
                                            $is_memcached_available = extension_loaded('memcached');
                                        } else {
                                            $is_memcached_available = false;
                                            $msg .= __("<span style='color: #f28400'>Notice: </span>Memcached extension is not loaded and Caching with Memcached is not available. Ask your hosting provider for enabling it.", 'dragonizer') . "<br>";
                                        }

                                        if (extension_loaded('redis')) {
                                            $is_redis_available = extension_loaded('redis');
                                        } else {
                                            $is_redis_available = false;
                                            $msg .= __("<span style='color: #f28400'>Notice: </span>Redis extension is not loaded and Caching with Redis is not available. Ask your hosting provider for enabling it.", 'dragonizer') . "<br>";
                                        }

                                        if (!(function_exists('opcache_get_configuration') && opcache_get_configuration()['directives']['opcache.enable'])) {
                                            $msg .= __("<span style='color: #d94f4f'>Notice: </span>OPcache extension is disabled. Enabling OPcache can significantly improve your PHP execution times by caching precompiled script bytecode. Please ask your hosting provider to enable OPcache for enhanced performance.", 'dragonizer') . "<br>";
                                        }

                                        foreach ($dragonizer_option['values'] as $value) {

                                            $currentKey   = $value[0];
                                            $currentValue = $value[1];
                                            $defaultValue = $dragonizer_option['default'][0];

                                            if ($currentKey === 'Memcached' && !$is_memcached_available) {
                                                $selected = 'disabled';
                                            } elseif ($currentKey === 'Redis' && !$is_redis_available) {
                                                $selected = 'disabled';
                                            } else {
                                                if (isset($obj->settings['object_cache'][$dragonizer_option_slug])) {
                                                    if (isset($obj->settings['object_cache'][$dragonizer_option_slug]['value'])) {
                                                        $selected = @selected($obj->settings['object_cache'][$dragonizer_option_slug]['value'] ?? false, $currentKey);
                                                    } else {
                                                        $selected = @selected($obj->settings['object_cache'][$dragonizer_option_slug] ?? false, $currentKey);
                                                    }
                                                } else {
                                                    $selected = ($defaultValue == $currentKey) ? selected($defaultValue, $currentKey) : '';
                                                }
                                            }

                                        ?>
                                            <option value='<?= $currentKey ?>' <?= $selected ?>><?= $currentValue ?></option>
                                        <?php
                                        }
                                        ?>
                                    </select>

                                    <?php

                                    include_once _dr(DRAGONIZER_INC_DIR, 'class-dragonizer-object-cache.php');

                                    $mem_conn = null;
                                    if (class_exists('Dragonizer_Object_Cache')) {
                                        $mem_conn = (new Dragonizer_Object_Cache())->test_connection();
                                    }

                                    if ($mem_conn === null) {
                                        $status = '<span id="connection_status_fld" style="color:blue">' . __('Unknown', 'dragonizer') . '</span>';
                                    } elseif ($mem_conn) {
                                        $status = '<span id="connection_status_fld" style="color:green">' . __('Success', 'dragonizer') . '</span>';
                                    } else {
                                        $status = '<span id="connection_status_fld" style="color:red">' . __('Failed', 'dragonizer') . '</span>';
                                    }

                                    ?>

                                    <span id="connection_test_fld" style="font-weight:600;margin:5px">
                                        <?php _e('Connection Test: ', 'dragonizer') ?><?= $status ?>
                                        <span style="font-weight:400;color:#606060;font-size:smaller"><?php _e(' (Refresh page to update)', 'dragonizer') ?></span>
                                    </span>

                                    <br><span><?= $dragonizer_option['description'] ?></span>
                                    <br><span><?= $msg ?></span>
                                </td>
                            </tr>
                        <?php
                        } elseif ($dragonizer_option['type'] === 'text' || $dragonizer_option['type'] === 'textarea' || $dragonizer_option['type'] === 'number') {

                            $valueToDisplay = isset($obj->settings['object_cache'][$dragonizer_option_slug]) ? $obj->settings['object_cache'][$dragonizer_option_slug] : ($dragonizer_option['default'] ?? '');

                        ?>
                            <tr>

                                <td class="column-title column-primary">
                                    <strong><?php echo __($dragonizer_option['title'], 'dragonizer'); ?></strong>
                                    <button type="button" class="toggle-row">
                                        <span class="screen-reader-text"><?php __('Show more details', 'dragonizer'); ?></span>
                                    </button>
                                </td>
                                <td class="explanation-column">
                                    <?php if ($dragonizer_option['type'] === 'text') : ?>
                                        <input type="text" name="dragonizer_settings[object_cache][<?php echo $dragonizer_option_slug; ?>]" id="<?php echo esc_attr($dragonizer_option_slug . '_fld'); ?>" value="<?php echo esc_attr($valueToDisplay); ?>">
                                    <?php elseif ($dragonizer_option['type'] === 'textarea') : ?>
                                        <textarea name="dragonizer_settings[object_cache][<?php echo $dragonizer_option_slug; ?>]" id="<?php echo esc_attr($dragonizer_option_slug . '_fld'); ?>"><?php echo esc_textarea($valueToDisplay); ?></textarea>
                                    <?php elseif ($dragonizer_option['type'] === 'number') : ?>
                                        <input type="number" name="dragonizer_settings[object_cache][<?php echo $dragonizer_option_slug; ?>]" id="<?php echo esc_attr($dragonizer_option_slug . '_fld'); ?>" value="<?php echo esc_attr($valueToDisplay); ?>">
                                    <?php elseif ($dragonizer_option['type'] === 'select') : ?>
                                        <select name="dragonizer_settings[object_cache][<?php echo $dragonizer_option_slug; ?>]" id="<?php echo esc_attr($dragonizer_option_slug . '_fld'); ?>">
                                            <?php foreach ($dragonizer_option['values'] as $option_value => $option_label) : ?>
                                                <option value="<?php echo esc_attr($option_value); ?>" <?php selected($valueToDisplay, $option_value); ?>><?php echo esc_html($option_label); ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                    <?php endif; ?>
                                    <p><?php echo wp_kses($dragonizer_option['description'], 'post'); ?></p>
                                </td>
                            </tr>
                    <?php
                        }
                    }
                    ?>

                </tbody>
            </table>
        </div>

        <div id="table_object_redis_memcached">
            <h3 class="dragon-hidden"><?php esc_html_e('Redis and Memcached Settings', 'dragonizer'); ?></h3>
            <p class="dragon-hidden"><?php esc_html_e('Configure specific settings for Redis and Memcached caching types. Setting these correctly is crucial for optimizing cache performance and connectivity.', 'dragonizer'); ?></p>
            <table class="dragon-hidden wp-list-table widefat fixed striped posts dragonizer_options-table dragonizer_cleanup-table">
                <thead>
                    <tr>
                        <th class="column-title manage-column column-primary"><strong><?php esc_html_e('Options', 'dragonizer'); ?></strong></th>
                        <th>
                            <string><?php esc_html_e('Explanation', 'dragonizer'); ?></string>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($obj->object_cache_redis_memcached as $dragonizer_option_slug => $dragonizer_option) {
                        if (empty($dragonizer_option['type'])) {
                    ?>
                            <tr>

                                <td class="column-title column-primary"><strong><?php echo __($dragonizer_option['title'], 'dragonizer'); ?></strong>
                                    <button type="button" class="toggle-row"><span class="screen-reader-text"><?php __('Show more details', 'dragonizer'); ?></span></button>
                                </td>
                                <td class="explanation-column" data-colname="<?php echo esc_attr(_e('Explanation', 'dragonizer')); ?>"><?php echo wp_kses(__($dragonizer_option['description'], 'dragonizer'), $dragonizer_allowed_description_tags); ?></td>
                            </tr>
                        <?php
                        } elseif ($dragonizer_option['type'] === 'text' || $dragonizer_option['type'] === 'textarea' || $dragonizer_option['type'] === 'number') {

                            $valueToDisplay = isset($obj->settings['object_cache'][$dragonizer_option_slug]) ? $obj->settings['object_cache'][$dragonizer_option_slug] : ($dragonizer_option['default'] ?? '');

                        ?>
                            <tr>

                                <td class="column-title column-primary">
                                    <strong><?php echo __($dragonizer_option['title'], 'dragonizer'); ?></strong>
                                    <button type="button" class="toggle-row">
                                        <span class="screen-reader-text"><?php __('Show more details', 'dragonizer'); ?></span>
                                    </button>
                                </td>
                                <td class="explanation-column">
                                    <?php if ($dragonizer_option['type'] === 'text') : ?>
                                        <input type="text" name="dragonizer_settings[object_cache][<?php echo $dragonizer_option_slug; ?>]" id="<?php echo esc_attr($dragonizer_option_slug . '_fld'); ?>" value="<?php echo esc_attr($valueToDisplay); ?>">
                                    <?php elseif ($dragonizer_option['type'] === 'textarea') : ?>
                                        <textarea name="dragonizer_settings[object_cache][<?php echo $dragonizer_option_slug; ?>]" id="<?php echo esc_attr($dragonizer_option_slug . '_fld'); ?>"><?php echo esc_textarea($valueToDisplay); ?></textarea>
                                    <?php elseif ($dragonizer_option['type'] === 'number') : ?>
                                        <input type="number" name="dragonizer_settings[object_cache][<?php echo $dragonizer_option_slug; ?>]" id="<?php echo esc_attr($dragonizer_option_slug . '_fld'); ?>" value="<?php echo esc_attr($valueToDisplay); ?>">
                                    <?php elseif ($dragonizer_option['type'] === 'select') : ?>
                                        <select name="dragonizer_settings[object_cache][<?php echo $dragonizer_option_slug; ?>]" id="<?php echo esc_attr($dragonizer_option_slug . '_fld'); ?>">
                                            <?php foreach ($dragonizer_option['values'] as $option_value => $option_label) : ?>
                                                <option value="<?php echo esc_attr($option_value); ?>" <?php selected($valueToDisplay, $option_value); ?>><?php echo esc_html($option_label); ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                    <?php endif; ?>
                                    <p><?php echo wp_kses($dragonizer_option['description'], 'post'); ?></p>
                                </td>
                            </tr>
                    <?php
                        }
                    }
                    ?>

                </tbody>
            </table>
        </div>

        <div id="table_object_options">
            <h3 class="dragon-hidden"><?php esc_html_e('Common Settings', 'dragonizer'); ?></h3>
            <p class="dragon-hidden"><?php esc_html_e('Adjust these options to fine-tune how your object cache behaves, including persistence, wp-admin caching, and transient storage settings.', 'dragonizer'); ?></p>
            <table class="dragon-hidden wp-list-table widefat fixed striped posts dragonizer_options-table dragonizer_cleanup-table">
                <thead>
                    <tr>
                        <td class="manage-column column-cb check-column ">
                            <input style="margin-top:4px!important" type="checkbox" name="check_all" id="dragonizer_object_cache_checkall_fld" <?php @checked(true, $obj->all_options_checked($obj->object_cache_options, 'object_cache'), true); ?>>
                        </td>
                        <th class="column-title manage-column column-primary"><strong><?php esc_html_e('Options', 'dragonizer'); ?></strong></th>
                        <th>
                            <string><?php esc_html_e('Explanation', 'dragonizer'); ?></string>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($obj->object_cache_options as $dragonizer_option_slug => $dragonizer_option) {
                        if (empty($dragonizer_option['type'])) {
                    ?>
                            <tr>
                                <th scope="row" class="check-column">
                                    <input type="checkbox" name="dragonizer_settings[object_cache][<?= $dragonizer_option_slug ?>]" id="<?php echo esc_attr($dragonizer_option_slug . '_fld'); ?>" <?php @checked(true, array_key_exists($dragonizer_option_slug, (is_array($obj->settings['object_cache'] ?? null) ? $obj->settings['object_cache'] : [])), true); ?>>
                                </th>
                                <td class="column-title column-primary"><strong><?php echo __($dragonizer_option['title'], 'dragonizer'); ?></strong>
                                    <button type="button" class="toggle-row"><span class="screen-reader-text"><?php __('Show more details', 'dragonizer'); ?></span></button>
                                </td>
                                <td class="explanation-column" data-colname="<?php echo esc_attr(_e('Explanation', 'dragonizer')); ?>"><?php echo wp_kses(__($dragonizer_option['description'], 'dragonizer'), $dragonizer_allowed_description_tags); ?></td>
                            </tr>
                        <?php
                        } elseif ($dragonizer_option['type'] === 'text' || $dragonizer_option['type'] === 'textarea' || $dragonizer_option['type'] === 'number') {

                            $valueToDisplay = isset($obj->settings['object_cache'][$dragonizer_option_slug]) ? $obj->settings['object_cache'][$dragonizer_option_slug] : ($dragonizer_option['default'] ?? '');

                        ?>
                            <tr>
                                <th scope="row" class="check-column">
                                </th>
                                <td class="column-title column-primary">
                                    <strong><?php echo __($dragonizer_option['title'], 'dragonizer'); ?></strong>
                                    <button type="button" class="toggle-row">
                                        <span class="screen-reader-text"><?php __('Show more details', 'dragonizer'); ?></span>
                                    </button>
                                </td>
                                <td class="explanation-column">
                                    <?php if ($dragonizer_option['type'] === 'text') : ?>
                                        <input type="text" name="dragonizer_settings[object_cache][<?php echo $dragonizer_option_slug; ?>]" id="<?php echo esc_attr($dragonizer_option_slug . '_fld'); ?>" value="<?php echo esc_attr($valueToDisplay); ?>">
                                    <?php elseif ($dragonizer_option['type'] === 'textarea') : ?>

                                        <div class="textarea-container">
                                            <textarea name="dragonizer_settings[object_cache][<?php echo $dragonizer_option_slug; ?>]" id="<?php echo esc_attr($dragonizer_option_slug . '_fld'); ?>"><?php echo esc_textarea($valueToDisplay); ?></textarea>
                                            <span class="dashicons dashicons-image-rotate set-default" data-target="#<?php echo $dragonizer_option_slug; ?>_fld" title="<?php echo __('Set Default', 'dragonizer'); ?>"></span>
                                        </div>

                                    <?php elseif ($dragonizer_option['type'] === 'number') : ?>
                                        <input type="number" name="dragonizer_settings[object_cache][<?php echo $dragonizer_option_slug; ?>]" id="<?php echo esc_attr($dragonizer_option_slug . '_fld'); ?>" value="<?php echo esc_attr($valueToDisplay); ?>">
                                    <?php elseif ($dragonizer_option['type'] === 'select') : ?>
                                        <select name="dragonizer_settings[object_cache][<?php echo $dragonizer_option_slug; ?>]" id="<?php echo esc_attr($dragonizer_option_slug . '_fld'); ?>">
                                            <?php foreach ($dragonizer_option['values'] as $option_value => $option_label) : ?>
                                                <option value="<?php echo esc_attr($option_value); ?>" <?php selected($valueToDisplay, $option_value); ?>><?php echo esc_html($option_label); ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                    <?php endif; ?>
                                    <p><?php echo wp_kses($dragonizer_option['description'], 'post'); ?></p>
                                </td>
                            </tr>
                    <?php
                        }
                    }
                    ?>

                </tbody>
            </table>
        </div>
<?php
    }
}
