<?php

// If user not in admin area, abort.
defined('DRAGONIZER_ADMIN_INIT') || die();

function display_lazy_load($obj)
{
    $dragonizer_allowed_description_tags = array(
        'br'   => array(),
        'span' => array(
            'style' => array(),
        ),
    );

    $callback = is_multisite() ? 'is_plugin_active_for_network' : 'is_plugin_active';

    $plugins = array_filter($obj->bad_plugins['optimizer'], $callback);

    if (count($plugins) > 0) {
        $obj->modules_status['lazy_load'] = '0';
        $obj->save_settings(['modules_status' => $obj->modules_status]);
?>
        <p class="dragon-hidden" style="font-size: larger;"><i style="margin:5px;color:orange" class="dashicons dashicons-admin-plugins"></i><?php _e('To use this section and avoid any possible disruption, you must first <strong>disable</strong> the following plugins.', 'dragonizer'); ?></p>
        <table class="dragon-hidden" style="margin:0 auto; border-spacing: 5px;text-align: left;">
            <tbody>
                <?php
                foreach ($plugins as $plugin) {
                    $plugin_data = get_plugin_data(WP_PLUGIN_DIR . DIRECTORY_SEPARATOR . $plugin);
                ?>
                    <tr>
                        <td><strong><span style="text-decoration: line-through;text-decoration-color: red;"><?= esc_attr($plugin_data['Name']) ?></span></strong></td>
                        <td><a href="<?= esc_url_raw(wp_nonce_url(admin_url('admin-post.php?action=deactivate_plugin&plugin=' . rawurlencode($plugin)), 'deactivate_plugin')) ?>" style="line-height: 22px!important;" class="button button-secondaty deactive-bad-plugins"><?= esc_html__('Deactivate', 'dragonizer') ?><span class="dashicons dashicons-trash"></span></a></td>
                    </tr>
                <?php
                }
                ?>
            </tbody>
        </table>

        <script>
            (function($) {
                $(function() {
                    $('div.toggle-btn').remove();
                    $('p.submit').remove();
                    $('div.pro-disabled').removeClass('pro-disabled');
                    $('a.deactive-bad-plugins').on('click', function() {
                        $('.dragonizer_tab_group #loader-wrapper').removeClass('loaded');
                    });
                });
            })(jQuery);
        </script>

    <?php
    } else {

    ?>

        <input type="hidden" name="dragonizer_settings[lazy_load]" value="">

        <style>
            .number-plus-minus {
                width: 140px;
                position: relative;
                height: 40px;
                background-color: #eee;
                border-radius: 20px
            }

            .number-plus-minus input {
                width: 100%;
                height: 100%;
                background-color: transparent;
                text-align: center;
                outline: none;
                font-size: 20px !important;
                padding-right: 15px !important
            }

            .number-plus-minus input[type=number]::-webkit-inner-spin-button {
                -webkit-appearance: none
            }

            .number-plus-minus .plus,
            .number-plus-minus .minus {
                width: 36px;
                height: 36px;
                top: 2px;
                position: absolute;
                border-radius: 50%;
                cursor: pointer;
                border: none
            }

            .number-plus-minus .plus {
                background-color: #4ab866
            }

            .number-plus-minus .minus {
                background-color: #9d0110
            }

            .number-plus-minus .plus:focus,
            .number-plus-minus .minus:focus {
                outline: none;
                border: none
            }

            .number-plus-minus .minus {
                left: 3px
            }

            .number-plus-minus .minus:after {
                content: "";
                top: 50%;
                left: 20%;
                height: 2px;
                width: 60%;
                background-color: #fff;
                position: absolute;
                margin-top: -1px;
                border-radius: 1px
            }

            .number-plus-minus .plus {
                right: 3px
            }

            .number-plus-minus .plus:after {
                content: "";
                top: 50%;
                left: 20%;
                height: 2px;
                width: 60%;
                background-color: #fff;
                position: absolute;
                margin-top: -1px;
                border-radius: 2px
            }

            .number-plus-minus .plus:before {
                content: "";
                top: 50%;
                left: 20%;
                height: 2px;
                width: 60%;
                background-color: #fff;
                position: absolute;
                margin-top: -1px;
                transform: rotate(90deg);
                border-radius: 2px
            }

            .exclusion-wrap,
            .exclusion-wrap .exclusions-content {
                width: 100%;
                -webkit-box-sizing: border-box;
                box-sizing: border-box
            }

            .exclusion-wrap .dark_blue_link {
                margin-right: 10px !important;
                margin-left: auto !important;
                box-shadow: unset !important;
                line-height: 21px !important;
            }

            .exclusion-wrap .exclusions-content {
                position: relative;
                padding: 5px;
                margin-bottom: 10px;
                min-height: 110px;
                border: 1px solid #aaa;
                border: 1px solid #3c434a;
                border-radius: 8px;
                -webkit-transition: all .15s ease-in;
                -o-transition: all .15s ease-in;
                transition: all .15s ease-in;
                background-color: white
            }

            .exclusion-wrap .exclusions-content:not(.plus) {
                z-index: 1
            }

            .exclusion-wrap .exclusions-content:hover {
                border: 1px solid #3c434a
            }

            .exclusion-wrap .exclusions-content:hover .plus:after,
            .exclusion-wrap .exclusions-content:hover .plus:before {
                visibility: visible;
                opacity: 1
            }

            .exclusion-wrap .exclusions-content .plus:after,
            .exclusion-wrap .exclusions-content .plus:before {
                content: '';
                position: absolute;
                visibility: hidden;
                opacity: 0;
                top: calc(50% - 1px);
                left: calc(50% - 10px);
                width: 20px;
                height: 2px;
                background: #005908;
                -webkit-transition: opacity .15s ease-in;
                -o-transition: opacity .15s ease-in;
                transition: opacity .15s ease-in;
                z-index: 0
            }

            .exclusion-wrap .exclusions-content .plus:after {
                top: calc(50% - 10px);
                left: calc(50% - 1px);
                width: 2px;
                height: 20px
            }

            .exclusion-wrap .exclusions-content>div[data-index] {
                position: relative;
                float: left;
                margin: 2px;
                padding: 5px 30px 5px 10px;
                background: #0a4b78;
                color: #fff;
                border-radius: 8px;
                direction: ltr
            }

            .exclusion-wrap .exclusions-content span[data-action=delete] {
                cursor: pointer;
                position: absolute;
                top: calc(50% - 10px);
                right: 5px;
                height: 20px;
                width: 20px;
                border-radius: 50%;
                -moz-border-radius: 50%;
                -webkit-border-radius: 50%;
                background: #9d0110
            }

            .exclusion-wrap .exclusions-content span[data-action=delete]:after,
            .exclusion-wrap .exclusions-content span[data-action=delete]:before {
                content: '';
                position: absolute;
                display: block;
                width: 60%;
                height: 2px;
                top: calc(50% - 1px);
                right: 20%;
                background: #fff;
                -webkit-transition: all .2s ease-in-out;
                -o-transition: all .2s ease-in-out;
                transition: all .2s ease-in-out
            }

            .exclusion-wrap .exclusions-content span[data-action=delete]:before {
                -webkit-transform: rotate(45deg);
                -ms-transform: rotate(45deg);
                transform: rotate(45deg)
            }

            .exclusion-wrap .exclusions-content span[data-action=delete]:after,
            .exclusion-wrap .exclusions-content span[data-action=delete]:hover:before {
                -webkit-transform: rotate(-45deg);
                -ms-transform: rotate(-45deg);
                transform: rotate(-45deg)
            }

            .exclusion-wrap .exclusions-content span[data-action=delete]:hover:after {
                -webkit-transform: rotate(45deg);
                -ms-transform: rotate(45deg);
                transform: rotate(45deg)
            }

            .exclusion-wrap textarea {
                display: none
            }

            .exclusion-wrap .buttons-wrap select {
                min-width: 90px;
                vertical-align: unset
            }

            .exclusion-wrap .buttons-wrap button {
                min-width: 100px;
                margin-right: 0
            }

            .exclusion-wrap[data-type=urls] .buttons-wrap input {
                width: calc(100% - 214px)
            }

            .exclusion-wrap .buttons-wrap input {
                width: calc(100% - 111px);
                border: unset !important;
                box-shadow: unset !important;
                line-height: 20px !important;
            }

            .exclusion-wrap .buttons-wrap .error-message {
                margin-bottom: 10px
            }

            @media screen and (max-width:782px) {

                .deactivation-popup[data-type=wrapper] .options-wrap label,
                .exclusion-wrap .buttons-wrap select {
                    margin-bottom: 10px
                }

                .exclusion-wrap .buttons-wrap input {
                    width: 100%;
                    display: inline-block;
                    margin-right: 0;
                    margin-bottom: 10px
                }

                .exclusion-wrap[data-type=urls] .buttons-wrap input {
                    width: calc(100% - 10px)
                }
            }

            .exclusion-wrap input.error[type=text],
            .exclusion-wrap input.error[type=text]:focus,
            .exclusion-wrap textarea.error,
            .exclusion-wrap textarea.error:focus {
                border: 1px solid #dc143c;
                -webkit-box-shadow: 0 0 2px 1px rgb(220 20 60 / 15%), inset 0 0 2px 1px rgb(220 20 60 / 15%);
                box-shadow: 0 0 2px 1px rgb(220 20 60 / 15%), inset 0 0 2px 1px rgb(220 20 60 / 15%)
            }
        </style>

        <script>
            "use strict";

            function _typeof(t) {
                return (_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(t) {
                    return typeof t
                } : function(t) {
                    return t && "function" == typeof Symbol && t.constructor === Symbol && t !== Symbol.prototype ? "symbol" : typeof t
                })(t)
            }! function(U) {
                U(document).ready(function() {
                    var a = {
                        validateSelector: function(t) {
                            try {
                                return document.querySelector(t), !0
                            } catch (t) {
                                return !1
                            }
                        },
                        prepare: function() {
                            U('[ data-setting="exclusion"]').each(function() {
                                var t = U(this),
                                    a = U(this).attr("id"),
                                    e = t.data("texts"),
                                    n = t.val();
                                "object" != _typeof(e) && (e = {
                                    add: "Add",
                                    save: "Save"
                                });
                                for (var i = "string" == typeof(i = t.data("separator")) && "" !== i ? i : ",", r = "string" == typeof(r = t.data("exclusion-type")) && "" !== r ? r : "selectors", s = "string" == typeof n && "" !== n ? n.split("string" == typeof i && "" !== i ? i : ",") : [], o = "", d = 0, l = s[d]; d < s.length; l = s[++d]) o = o + '<div data-index="' + d + '" data-action="edit"><span class="selector">' + l + '</span><input type="hidden" name="dragonizer_settings[lazy_load][' + a + '][]" value="' + l + '"></input><span data-action="delete"></span></div>';
                                var p = U('<div class="exclusion-wrap" data-type="' + r + '"><div data-id="' + a + '" class="exclusions-content clearfix" data-action="add"><div class="plus"></div>' + o + '</div><div class="buttons-wrap hidden"><div class="error-message hidden"></div>' + ("urls" === r ? '<select><option value="path">Path</option><option value="regex">RegEx</option><option value="http">HTTP</option><option value="https">HTTPS</option><option value="domain">Domain</option></select> : ' : "") + '<input type="text"><button style="line-height:21px!important" type="button" class="dark_blue_link button" data-action="confirm" data-texts=' + JSON.stringify(e) + ">" + e.add + "</button></div></div>");
                                t.before(p), p.append(t)
                            })
                        },
                        actionsHandler: function(t) {
                            t.preventDefault(), t.stopPropagation();
                            var a = U(this),
                                e = ((S = a.parents("td")).find("p.warning"), a.parents(".exclusion-wrap")),
                                n = e.find("textarea"),
                                i = e.find(".buttons-wrap"),
                                r = i.find(".error-message"),
                                s = i.find("input"),
                                o = i.find("select"),
                                d = i.find("button"),
                                l = e.find(".exclusions-content"),
                                p = l.attr("data-id"),
                                c = l.find(".selector"),
                                u = l.find("div[data-index]"),
                                f = s.val(),
                                v = d.attr("data-texts"),
                                y = a.attr("data-action"),
                                g = a.attr("data-state"),
                                x = n.data("exclusion-type"),
                                f = "string" == typeof f && "" !== f ? f.trim() : "",
                                g = "confirm" === (y = "string" == typeof y && "" !== y ? y : void 0) && "string" == typeof g && "" !== g ? g : "add",
                                x = "string" == typeof x && "" !== x ? x : "selectors";
                            try {
                                v = JSON.parse(v)
                            } catch (t) {
                                v = {
                                    add: "Add",
                                    save: "Save"
                                }
                            }
                            switch (y) {
                                case "add":
                                    d.text(v.add).attr("data-state", "add").removeAttr("data-editing"), s.removeClass("error").val(""), i.slideDown("fast"), r.text("").slideUp("fast"), s.focus();
                                    break;
                                case "edit":
                                    var h = a.find(".selector");
                                    s.removeClass("error").val(h.text()), d.text(v.save).attr("data-state", "save").attr("data-editing", a.attr("data-index")), i.slideDown("fast"), r.text("").slideUp("fast"), s.focus();
                                    break;
                                case "delete":
                                    a.parents("div[data-index]").fadeOut("fast", function() {
                                        U(this).remove()
                                    }), d.removeAttr("data-editing").removeAttr("data-state"), i.slideUp("fast"), s.removeClass("error").val(""), r.text("").slideUp("fast");
                                    break;
                                case "confirm":
                                    for (var m = o.val(), b = !1, k = "urls" === x ? m + ":" + f : f, w = (w = "urls" === x ? [k] : k.split(",")).map(function(t) {
                                            return "string" == typeof t ? t.trim() : t
                                        }), h = U(c[S = 0]); S < c.length; h = U(c[++S])) {
                                        var S = h.text();
                                        if ((w = w.filter(function(t) {
                                                return "save" === g && h.parent().attr("data-index") === a.attr("data-editing") && S === t || S !== t
                                            })).length <= 0) {
                                            b = !0, s.addClass("error"), r.text("").slideUp("fast");
                                            break
                                        }
                                    }
                                    if (b) break;
                                    var _, A = function(t, a) {
                                        var e = U('<div data-index="' + (_ + a) + '" data-action="edit" class="hidden"><span class="selector">' + t + '</span><input type="hidden" name="dragonizer_settings[lazy_load][' + p + '][]" value="' + t + '"></input><span data-action="delete"></span></div>');
                                        l.append(e), e.fadeIn("fast")
                                    };
                                    "add" === g && "" !== f && 0 < w.length ? (_ = 0 < u.length ? parseInt(u.last().attr("data-index"), 10) + 1 : 0, w.map(A)) : "save" === g && "" !== f && 0 < w.length && (_ = a.attr("data-editing"), l.find('div[data-index="' + _ + '"] .selector').text(w.shift()), l.find('div[data-index="' + _ + '"] input').val(l.find('div[data-index="' + _ + '"] .selector').text()), 0 < w.length && (_ = 0 < u.length ? parseInt(u.last().attr("data-index"), 10) + 1 : 0, w.map(A))), d.removeAttr("data-editing").removeAttr("data-state"), s.removeClass("error").val(""), r.text("").slideUp("fast")
                            }
                        }
                    };
                    U(function() {
                        var t = U(this);
                        a.prepare(), t.on("click", ".exclusion-wrap [data-action]", a.actionsHandler), U(".buttons-wrap>input").keyup(function(t) {
                            13 === t.keyCode && U(this).closest(".buttons-wrap").children(".dark_blue_link").click()
                        }), U(document).on("keydown", ".buttons-wrap>input", ":input:not(textarea)", function(t) {
                            return "Enter" != t.key
                        }), U(".exclusion-wrap input").on("change focus blur input keypress", function() {}), U(".buttons-wrap").on("focusout", function() {
                            U(this).slideUp("fast")
                        }), U(".minus").click(function() {
                            var t = U(this).parent().find("input"),
                                a = (a = parseInt(t.val()) - 1) < 0 ? 0 : a;
                            return t.val(a), t.change(), !1
                        }), U(".plus").click(function() {
                            var t = U(this).parent().find("input"),
                                a = 20 < (a = parseInt(t.val()) + 1) ? 20 : a;
                            return t.val(a), t.change(), !1
                        })
                    })
                })
            }(jQuery);
        </script>

        <h3 class="dragon-hidden"><?php esc_html_e('Lazy Load settings', 'dragonizer'); ?> <span class="dragonizer_security_badge dragonizer_safe_badge"><?php esc_html_e('Completely safe', 'dragonizer'); ?></span></h3>

        <p class="dragon-hidden"><?php esc_html_e('Enable to delay the loading of iframes, images and responsive images until they are scrolled into view. This further speeds up the loading of the page and reduces http requests, 100% Compatible with WordPress 5.5 image lazy load and will enhance its coverage on this site.', 'dragonizer'); ?></p>

        <p class="dragon-hidden" style="color:#7878FF"><?php esc_html_e("To avoid any interference, disable your theme's default lazy-loading feature.", 'dragonizer'); ?></p>

        <p class="dragon-hidden" style="color:green"><?php esc_html_e('Lazy loading is currently enabled, you can add more possibilities to it with the following options:', 'dragonizer'); ?></p>

        <table class="dragon-hidden wp-list-table widefat fixed striped posts dragonizer_options-table dragonizer_cleanup-table">
            <thead>
                <tr>
                    <td class="manage-column column-cb check-column "><input style="margin-top:4px!important" type="checkbox" name="check_all" <?php @checked(true, $obj->all_options_checked($obj->lazy_load_settings, 'lazy_load'), true); ?>></td>
                    <th class="column-title manage-column column-primary"><strong><?php esc_html_e('Options', 'dragonizer'); ?></strong></th>
                    <th>
                        <string><?php esc_html_e('Explanation', 'dragonizer'); ?></string>
                    </th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($obj->lazy_load_settings as $dragonizer_option_slug => $dragonizer_option) { ?>
                    <tr>
                        <th scope="row" class="check-column">
                            <input type="checkbox" name="dragonizer_settings[lazy_load][<?= $dragonizer_option_slug ?>]" id="<?php echo esc_attr($dragonizer_option_slug . '_fld'); ?>" <?php @checked(true, array_key_exists($dragonizer_option_slug, (is_array($obj->settings['lazy_load'] ?? null) ? $obj->settings['lazy_load'] : [])), true); ?>>
                        </th>
                        <td class="column-title column-primary"><strong><?php echo __($dragonizer_option['title'], 'dragonizer'); ?></strong>
                            <button type="button" class="toggle-row"><span class="screen-reader-text"><?php __('Show more details', 'dragonizer'); ?></span></button>
                        </td>
                        <td class="explanation-column" data-colname="<?php echo esc_attr(_e('Explanation', 'dragonizer')); ?>"><?php echo wp_kses(__($dragonizer_option['description'], 'dragonizer'), $dragonizer_allowed_description_tags); ?></td>
                    </tr>

                <?php } ?>

            </tbody>
        </table>

        <h3 class="dragon-hidden"><?php esc_html_e('Lazy Load excludes', 'dragonizer'); ?> <span class="dragonizer_security_badge dragonizer_safe_badge"><?php esc_html_e('Completely safe', 'dragonizer'); ?></span></h3>

        <p class="dragon-hidden"><?php esc_html_e('With the help of this section, prevent the lazy loading of your desired content. These images with preload attribute will be sent to the browser before loading the page.', 'dragonizer'); ?></p>

        <table class="dragon-hidden wp-list-table widefat fixed striped posts dragonizer_options-table dragonizer_optimize-table">
            <thead>
                <tr>
                    <th class="column-title manage-column column-primary"><strong><?php esc_html_e('Options', 'dragonizer'); ?></strong></th>
                    <th>
                        <string><?php esc_html_e('Choose', 'dragonizer'); ?></string>
                    </th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($obj->lazy_load_excludes as $dragonizer_option_slug => $dragonizer_option) { ?>
                    <tr>
                        <td class="column-title column-primary"><strong><?php echo __($dragonizer_option['title'], 'dragonizer'); ?></strong>
                            <button type="button" class="toggle-row"><span class="screen-reader-text"><?php __('Show more details', 'dragonizer'); ?></span></button>
                        </td>
                        <td class="explanation-column" data-colname="<?php echo esc_attr(_e('Choose', 'dragonizer')); ?>">

                            <?php if (isset($dragonizer_option['type']) && $dragonizer_option['type'] == 'selector') {

                                $data = is_array($obj->get('lazy_load', $dragonizer_option_slug)) ? implode(',', $obj->get('lazy_load', $dragonizer_option_slug)) : '';

                            ?>
                                <div>
                                    <textarea style="display: none;" id="<?= $dragonizer_option_slug ?>" rows="5" data-type="string" data-exclusion-type="selectors" data-texts='{"add":"<?php _e("add", "dragonizer"); ?>","save":"<?php _e("save", "dragonizer"); ?>"}' data-setting="exclusion"><?= $data ?></textarea>
                                    <p style="margin:10px"> <?php echo wp_kses(__($dragonizer_option['description'], 'dragonizer'), $dragonizer_allowed_description_tags); ?> </p>
                                </div>

                            <?php
                            } else {

                                $data = $obj->settings['lazy_load']['excluded_leading'] ?? 0;

                            ?>
                                <div class="number-plus-minus">
                                    <input style="border: none!important" readonly type="number" name="dragonizer_settings[lazy_load][excluded_leading]" value="<?= $data ?>" />
                                    <button type="button" class="plus"></button>
                                    <button type="button" class="minus"></button>
                                </div>
                                <p style="margin:10px"> <?php echo wp_kses(__($dragonizer_option['description'], 'dragonizer'), $dragonizer_allowed_description_tags); ?> </p>
                            <?php
                            } ?>

                        </td>
                    </tr>

                <?php } ?>

            </tbody>
        </table>

<?php
    }
}
