<?php

// If user not in admin area, abort.
defined('DRAGONIZER_ADMIN_INIT') || die();

class Dragonizer_Settings extends Dragonizer_Core
{
	public $preloading;
	public $caching_other;
	public $caching_dynamic;
	public $ssl_secure_configs_nginx;
	public $ssl_secure_permissions_policies;
	public $database;
	public $login_customizer;
	public $final_settings_login_customizer;
	public $default_settings_login_customizer;
	public $lazy_load_excludes;
	public $ssl_secure_options;
	public $ssl_secure_configs_apache;
	public $ssl_secure_settings;
	public $lazy_load_settings;
	public $login_customizer_opts;
	public $copyright;
	public $object_cache;
	public $object_cache_options;
	public $object_cache_redis_memcached;
	public $caching_lifetime;
	public $caching;
	public $wp_tweaks_main;
	public $wp_tweaks_other;
	public $minify_html;
	public $minify_css;
	public $minify_js;
	public $shamsi;
	public $shamsi_woocommerce;
	public $minify_common;
	public $wp_tweaks;
	public $wp_optimizer_cleanup;
	public $wp_optimizer_optimize;
	public $wp_optimizer_core;
	public $wp_optimizer_tweaks;
	public $wp_optimizer_other;
	public $woo_optimizer_bloat;
	public $woo_optimizer_advanced;
	public $woo_optimizer_interface;
	public $woo_optimizer_performance;
	public $default_settingsـmaintenance;
	public $preview_url;
	public $preview_base_url;
	public $magic_base_url;
	public $magic_url;
	public $final_settingsـmaintenance;

	public function __construct()
	{
		parent::__construct();
		$this->init_settings();
		add_action('admin_init', array($this, 'dragonizer_settings_register'));

		include_once _dr(DRAGONIZER_INC_DIR, 'class-dragonizer-database.php');

		if (class_exists('Dragonizer_Database')) {
			new Dragonizer_Database($this->database);
		}
	}

	public function dragonizer_settings_register()
	{
		$settings_pages = [
			'wp_tweaks',
			'wp_optimizer',
			'images',
			'woo_optimizer',
			'translator',
			'benchmark',
			'db_optimizer',
			'debugging',
			'ssl_secure',
			'maintenance',
			'login_customizer',
			'shamsi',
			'lazy_load',
			'minify',
			'caching',
			'object_cache',
			'preloading',
			'copyright',
			'settings',
			'about'
		];

		$args = [
			'type' => 'array',
			'sanitize_callback' =>  [$this, 'dragonizer_settings_merger']
		];

		foreach ($settings_pages as $page) {
			$option_name = 'dragonizer_settings';
			$section_id  = /* 'dragonizer_section_' .*/ $page;
			$page_id = 'dragonizer_' . $page;

			register_setting($page_id, $option_name, $args);
			add_settings_section($section_id, null, [$this, 'dragonizer_settings_callback'], $page_id);
		}
	}

	public function dragonizer_settings_callback($args)
	{
		$section_files = [
			'benchmark'        => 'dragonizer-settings-benchmark.php',
			'caching'          => 'dragonizer-settings-caching.php',
			'object_cache'     => 'dragonizer-settings-object-cache.php',
			'preloading'       => 'dragonizer-settings-preloading.php',
			'translator'       => 'dragonizer-settings-translator.php',
			'wp_optimizer'     => 'dragonizer-settings-wp-optimizer.php',
			'wp_tweaks'        => 'dragonizer-settings-wp-tweaks.php',
			'woo_optimizer'    => 'dragonizer-settings-woo-optimizer.php',
			'db_optimizer'     => 'dragonizer-settings-db-optimizer.php',
			'debugging'        => 'dragonizer-settings-debugging.php',
			'ssl_secure'       => 'dragonizer-settings-ssl-secure.php',
			'maintenance'      => 'dragonizer-settings-maintenance.php',
			'login_customizer' => 'dragonizer-settings-login-customizer.php',
			'shamsi'           => 'dragonizer-settings-shamsi.php',
			'lazy_load'        => 'dragonizer-settings-lazy-load.php',
			'images'           => 'dragonizer-settings-images.php',
			'minify'           => 'dragonizer-settings-minify.php',
			'copyright'        => 'dragonizer-settings-copyright.php',
			'settings'         => 'dragonizer-settings-settings.php',
			'about'            => 'dragonizer-settings-about.php'
		];

		$section_id = $args['id'];
		if (isset($section_files[$section_id])) {
			include_once _dr(DRAGONIZER_PAR_DIR, $section_files[$section_id]);
			$functionName = "display_$section_id";
			function_exists($functionName) && $functionName($this);
		}
	}

	public function dragonizer_settings_merger($input)
	{
		is_array($input) || $input = [];

		if (empty($input) || count($input) > 1) return $input;

		$this->save_settings($input);
	}

	private function init_settings()
	{
		$this->preloading = array(
			'mobile' => array(
				'title' => __('Simulate mobile user agent', 'dragonizer'),
				'description' => __("By selecting this option, your site pages will be launched with mobile user agent.", 'dragonizer'),
			),
			'sitemap_check' => array(
				'title' => __('Sitemap Check', 'dragonizer'),
				'description' => __('This option specifies the interval between each check for sitemap changes', 'dragonizer'),
				'type' => 'select',
				'default' => [43200, __('Every 12 hours', 'dragonizer')],
				'values' => [[43200, __('Every 12 Hours', 'dragonizer')], [36000, __('Every 10 Hours', 'dragonizer')], [28800, __('Every 8 Hours', 'dragonizer')], [21600, __('Every 6 Hours', 'dragonizer')], [10800, __('Every 3 Hours', 'dragonizer')], [3600, __('Every 1 Hour', 'dragonizer')]]
			),
			'interval' => array(
				'title' => __('Preloading execution interval', 'dragonizer'),
				'description' => __('This option specifies the interval between each execution', 'dragonizer'),
				'type' => 'select',
				'default' => [5, __('Every 5 Minutes', 'dragonizer')],
				'values' => [[5, __('Every 5 Minutes', 'dragonizer')], [10, __('Every 10 Minutes', 'dragonizer')], [15, __('Every 15 Minutes', 'dragonizer')], [20, __('Every 20 Minutes', 'dragonizer')], [30, __('Every 30 Minutes', 'dragonizer')]]
			),
			'count' => array(
				'title' => __('Preloading execution count', 'dragonizer'),
				'description' => __('This option specifies how many pages should be preloaded in each execution<br><span style="color: #d94f4f">(choose these numbers based on your hosting/server resources to avoid problems)</span>', 'dragonizer'),
				'type' => 'select',
				'default' => [30, __('30 Pages', 'dragonizer')],
				'values' => [[5, __('5 Pages', 'dragonizer')], [10, __('10 Pages', 'dragonizer')], [20, __('20 Pages', 'dragonizer')], [30, __('30 Pages', 'dragonizer')], [40, __('40 Pages', 'dragonizer')], [50, __('50 Pages', 'dragonizer')], [60, __('60 Pages', 'dragonizer')], [70, __('70 Pages', 'dragonizer')], [80, __('80 Pages', 'dragonizer')], [90, __('90 Pages', 'dragonizer')], [100, __('100 Pages', 'dragonizer')]]
			),
		);


		// <span class="dashicons dashicons-marker" style="color:#23b900;vertical-align:middle"></span>
		// <span class="dashicons dashicons-marker" style="color:#c60900;vertical-align:middle"></span>


		// Green and Red markers
		$green_marker = "<span class=\"dashicons dashicons-marker\" style=\"color:#23b900;vertical-align:middle\"></span> ";
		$red_marker = "<span class=\"dashicons dashicons-marker\" style=\"color:#c60900;vertical-align:middle\"></span> ";

		// Check for available cache types
		$is_memcached_available = extension_loaded('memcached');
		$is_redis_available = extension_loaded('redis');


		// Define format for cache type description
		$cache_type_format = "<br>%s<b>%s</b>%s";

		// Construct descriptions
		$memcached_desc = sprintf(
			$cache_type_format,
			$is_memcached_available ? $green_marker : $red_marker,
			__('Memcached: ', 'dragonizer'),
			__("A memory-based caching system, offering quick data access by storing cache in RAM. Ideal for high-traffic WordPress sites needing fast performance.<br>", 'dragonizer')
		);
		$redis_desc = sprintf(
			$cache_type_format,
			$is_redis_available ? $green_marker : $red_marker,
			__('Redis: ', 'dragonizer'),
			__("Also memory-based, Redis excels in handling complex data structures with quick access. It's well-suited for large, high-traffic WordPress sites with demanding caching needs. (More recommended for virtual or dedicated servers)<br>", 'dragonizer')
		);

		// Modify the object_cache array
		$this->object_cache = array(
			'object_cache_type' => array(
				'title' => __('Select Type', 'dragonizer'),
				'description' => sprintf(
					"%s%s",
					$memcached_desc,
					$redis_desc
				),
				'type' => 'select',
				'default' => ['Disable', __('Disable', 'dragonizer')],
				'values' => [
					['Disable', __('Disable', 'dragonizer')],
					['Memcached', __('Memcached', 'dragonizer')],
					['Redis', __('Redis', 'dragonizer')]
				]
			),
		);

		$this->object_cache_redis_memcached = array(
			'hostname' => array(
				'title' => __('Hostname', 'dragonizer'),
				'type' => 'text',
				'default' => '127.0.0.1',
				'description' => __("Input your Memcached/Redis server's IP or domain. Use 127.0.0.1 or localhost for local or managed environments.<br>For UNIX socket usage, specify the socket path, such as <bdo style='direction:ltr'>/path/to/memcached.sock.</bdo>", 'dragonizer'),
			),
			'port' => array(
				'title' => __('Port', 'dragonizer'),
				'type' => 'number',
				'default' => '11211',
				'description' => __("Specify the port number for your caching server connection. Set to 0 for UNIX socket connections.", 'dragonizer'),
			),
			'username' => array(
				'title' => __('Username', 'dragonizer'),
				'type' => 'text',
				'description' => __("Enter the username for Memcached if SASL authentication is in place.", 'dragonizer'),
			),
			'password' => array(
				'title' => __('Password', 'dragonizer'),
				'type' => 'text',
				'description' => __("Enter the password for Memcached to authenticate via SASL.", 'dragonizer'),
			),
			'redis_id' => array(
				'title' => __('Redis DB ID', 'dragonizer'),
				'type' => 'number',
				'default' => 0,
				'description' => __("For managing separate caching environments.", 'dragonizer'),
			),
		);

		$this->object_cache_options = array(
			'persistence' => array(
				'title' => __('Connection Persistence', 'dragonizer'),
				'description' => __("Enables the cache driver to maintain persistent connections, reducing the overhead of reconnecting on subsequent requests.", 'dragonizer'),
			),
			'wp_admin' => array(
				'title' => __('wp-admin caching', 'dragonizer'),
				'description' => __("Speeds up the WordPress admin area by caching its requests, potentially leading to minor discrepancies with real-time data.<br><span style='color: #d94f4f'>(Minor side effects possible)</span>", 'dragonizer'),
			),
			'transient' => array(
				'title' => __('Transient Storage', 'dragonizer'),
				'description' => __("Enables the retention of transients within WordPress's internal handling, ensuring their availability even after object cache refreshes or expires.", 'dragonizer'),
			),
			'lifetime' => array(
				'title' => __('Cache Lifetime', 'dragonizer'),
				'type' => 'number',
				'default' => 360,
				'description' => __("Sets the expiration time for cache items that haven't been updated. A higher value means a more extended cache lifespan.", 'dragonizer'),
			),
			'groups' => array(
				'title' => __('Cache Groups', 'dragonizer'),
				'type' => 'textarea',
				'default' => "rss\nusers\nuserlogins\nuseremail\nuserslugs\nusermeta\nuser_meta\nsite-transient\nsite-options\nsite-lookup\nsite-details\nblog-lookup\nblog-details\nblog-id-cache\nglobal-posts\nglobal-cache-test",
				'description' => __("Defines cache groups that are accessible across the entire network in multisite configurations.", 'dragonizer'),
			),
			'excluded' => array(
				'title' => __('Excluded Groups', 'dragonizer'),
				'type' => 'textarea',
				'default' => "comment\ncounts\nplugins\nwc_session_id",
				'description' => __("Identifies specific cache groups to be excluded from caching operations.", 'dragonizer'),
			),

		);

		$this->caching = array(
			'cache_status' => array(
				'title' => __('Status', 'dragonizer'),
				'description' => __(
					"<br>" .
						"• <b>Guest Visitors <span style='color: green'>(Recommended)</span>:</b> Cache pages only for guest visitors. Best for most websites.<br>" .
						"• <b>All Visitors (Not Recommended):</b> Cache pages for both guests and logged-in users. May cause inconsistencies in user-specific content.<br>" .
						"• <b>Common Cache (Advanced):</b> Serves the same cached version to all users. Maximizes performance and reduces server load. <span style='color: #d94f4f'>(Ensure your theme supports this option before activating)</span>",
					'dragonizer'
				),
				'type' => 'select',
				'default' => ['Guest', __('Guest visitors', 'dragonizer')],
				'values' => [
					['Disable', __('Disable', 'dragonizer')],
					['Guest', __('Guest visitors', 'dragonizer')],
					['All', __('All visitors', 'dragonizer')],
					['Common', __('Common cache', 'dragonizer')]
				]
			),
			// 'cache_mode' => array(
			// 	'title' => __('Cache Management Mode', 'dragonizer'),
			// 	'description' => __(
			// 		"<br>" .
			// 			"• <b>Dynamic Cache <span style='color: red'>(Beta)</span>:</b> Separates and automatically manages dynamic content (such as forms, nonces, and user-specific elements) from static content. This approach ensures optimal performance with minimal cache clearing. It is ideal for sites with forms, AJAX interactions, or e-commerce features.<br>" .
			// 			"• <b>Timed Expiry:</b> A traditional caching method that caches entire pages and clears them after a set period. <span style='color: #666'>(Choose this option if you prefer a conventional caching approach or if you encounter issues with Dynamic Cache)</span>",
			// 		'dragonizer'
			// 	),
			// 	'type' => 'select',
			// 	'default' => ['timed', __('Timed Expiry', 'dragonizer')],
			// 	'values' => [
			// 		['dynamic', __('Dynamic Cache (Beta)', 'dragonizer')],
			// 		['timed', __('Timed Expiry', 'dragonizer')]
			// 	]
			// ),
			'browser_cache' => array(
				'title' => __('Browser ache', 'dragonizer'),
				'description' => __("Improves site performance and reduce repeated requests by store static files locally in the user's browser.", 'dragonizer'),
			),
			'gzip_compression' => array(
				'title' => __('Gzip Compression', 'dragonizer'),
				'description' => __('The pages will be gzip-compressed at the PHP level when this option enabled. Pre-defined configurations for .htaccess and Nginx configurations come with gzip compression.<span style="color:green">(Recommended)</span>', 'dragonizer'),
			),
			'no_cache_query_params' => array(
				'title' => __("Don't cache GET parameters", 'dragonizer'),
				'description' => __('Don’t cache pages with GET parameters. (?x=y at the end of a url)<span style="color:green">(Recommended)</span>', 'dragonizer'),
			),
			'separate_mobile_cache' => array(
				'title' => __('Mobile device custom theme', 'dragonizer'),
				'description' => __("Use separate cache file for mobile browsers and a separate file for desktop browsers.<br><span style='color: green'>(Recommended)</span>", 'dragonizer'),
			)
		);

		if (!DRFS::is_htaccess()) {
			unset($this->caching['browser_cache']);
			unset($this->caching['gzip_compression']);
		}

		$this->caching_lifetime = array(
			'cache_lifetime' => array(
				'title' => __('Cache timeout', 'dragonizer'),
				'description' => __('Choose how long to keep your cached files. We recommend using unlimited for best performance. If you experience any issues, try setting it to 10 hours.<br><span style="color: darkblue">When WordPress Nonces are updated or in the cases listed at the end of this page, your site\'s cache will be automatically deleted.</span>', 'dragonizer'),
				'type' => 'select',
				'default' => [0, __('Unlimited', 'dragonizer')],
				'values' => [
					[0, __('Unlimited', 'dragonizer')],
					[86400, __('Every 24 Hours', 'dragonizer')],
					[64800, __('Every 18 Hours', 'dragonizer')],
					[43200, __('Every 12 Hours', 'dragonizer')],
					[36000, __('Every 10 Hours', 'dragonizer')],
					[28800, __('Every 8 Hours', 'dragonizer')],
					[21600, __('Every 6 Hours', 'dragonizer')],
					[10800, __('Every 3 Hours', 'dragonizer')],
					[3600, __('Every 1 Hour', 'dragonizer')]
				]
			),
			'cache_expiry_interval' => array(
				'title' => __('Check cache timeout', 'dragonizer'),
				'description' => __('Sets the interval between checking for cache expiration and frontend WordPress Nonces changes.', 'dragonizer'),
				'type' => 'select',
				'default' => [3600, __('Every 1 Hour', 'dragonizer')],
				'values' => [
					[30, __('Every 30 Minutes', 'dragonizer')],
					[3600, __('Every 1 Hour', 'dragonizer')],
					[10800, __('Every 3 Hours', 'dragonizer')]
				]
			),
		);

		// Settings for Dynamic Cache mode
		$this->caching_dynamic = array(
			'dynamic_cache_refresh' => array(
				'title' => __('Dynamic Content Refresh Interval', 'dragonizer'),
				'description' => __('How often to check and update dynamic elements like nonces and forms. <span style="color:green">3 hours is recommended for most sites</span>. Shorter intervals make the site more dynamic and prevent issues with login and user interactions, but may slightly increase server load.', 'dragonizer'),
				'type' => 'select',
				'default' => [10800, __('Every 3 Hours', 'dragonizer')],
				'values' => [
					[21600, __('Every 6 Hours', 'dragonizer')],
					[10800, __('Every 3 Hours', 'dragonizer')],
					[7200, __('Every 2 Hours', 'dragonizer')],
					[3600, __('Every Hour', 'dragonizer')],
					[1800, __('Every 30 Minutes', 'dragonizer')],
					[900, __('Every 15 Minutes', 'dragonizer')]
				]
			)
		);

		$this->caching_other = array(
			'rejected_uri' => array(
				'title' => __('Rejected following pages', 'dragonizer'),
				'type' => 'selector',
				'description' => __('Ignore the specified pages or directories.<br><span style="color: darkblue">Use * wildcard character to match multiple characters at this position (eg. <bdo dir="ltr">/product/*</bdo>)<br>Most pages that should not be cached will be automatically excluded (eg. <bdo dir="ltr">/cart</bdo> and <bdo dir="ltr">/checkout</bdo>)</span>', 'dragonizer'),
			),
			'rejected_parameters' => array(
				'title' => __('Rejected query parameters', 'dragonizer'),
				'type' => 'selector',
				'description' => __('Never send cached results for these query parameters. (GET or POST)<br><span style="color: darkblue">(eg. <bdo style="direction:ltr">campaign=nowruz</bdo>)</span>', 'dragonizer'),
			),
			'accepted_parameters' => array(
				'title' => __('Accepted query parameters', 'dragonizer'),
				'type' => 'selector',
				'description' => __('Generate cached results for these query parameters. (GET or POST)<br><span style="color: darkblue">(eg. <bdo style="direction:ltr">campaign=nowruz</bdo>)</span>', 'dragonizer'),
			),
			'rejected_user_agent' => array(
				'title' => __('Rejected User Agents', 'dragonizer'),
				'type' => 'selector',
				'description' => __('Never send cached results for these user agents.', 'dragonizer'),
			),
			'rejected_cookies' => array(
				'title' => __('Rejected Cookies', 'dragonizer'),
				'type' => 'selector',
				'description' => __('Cookies which will prevent pages from getting cached.', 'dragonizer'),
			),
		);

		// $this->caching_rejected = array(
		// 	'home' => array(
		// 		'title' => __('Home Page', 'dragonizer'),
		// 		'description' => __('Destinition', 'dragonizer'),
		// 	),
		// 	'front' => array(
		// 		'title' => __('Front Page', 'dragonizer'),
		// 		'description' => __('Destinition', 'dragonizer'),
		// 	),
		// 	'single' => array(
		// 		'title' => __('Single Posts', 'dragonizer'),
		// 		'description' => __('Destinition', 'dragonizer'),
		// 	),
		// 	'pages' => array(
		// 		'title' => __('Pages', 'dragonizer'),
		// 		'description' => __('Destinition', 'dragonizer'),
		// 	),
		// 	'archives' => array(
		// 		'title' => __('Archives', 'dragonizer'),
		// 		'description' => __('Destinition', 'dragonizer'),
		// 	),
		// 	'tags' => array(
		// 		'title' => __('Tags', 'dragonizer'),
		// 		'description' => __('Destinition', 'dragonizer'),
		// 	),
		// 	'categories' => array(
		// 		'title' => __('Categories', 'dragonizer'),
		// 		'description' => __('Destinition', 'dragonizer'),
		// 	),
		// 	'feeds' => array(
		// 		'title' => __('Feeds', 'dragonizer'),
		// 		'description' => __('Destinition', 'dragonizer'),
		// 	),
		// 	'search' => array(
		// 		'title' => __('Search Results', 'dragonizer'),
		// 		'description' => __('Destinition', 'dragonizer'),
		// 	),
		// 	'author' => array(
		// 		'title' => __('Author Pages', 'dragonizer'),
		// 		'description' => __('Destinition', 'dragonizer'),
		// 	),
		// );

		$this->ssl_secure_options = array(
			'fix_frontend_mixed' => array(
				'title' => __('Mixed content in frontend', 'dragonizer'),
				'description' => __("Fix mixed content in the frontend on the fly (Files and/or database is not changed) by replacing <bdo style='direction:ltr'>http://</bdo> with <bdo style='direction:ltr'>https://</bdo> for linked resources.<br><span style='color: #d94f4f'>Only enable if you have mixed content error on your site</span>", 'dragonizer'),
			),
			'fix_backend_mixed' => array(
				'title' => __('Mixed content in backend', 'dragonizer'),
				'description' => __('Fix mixed content in the backend (wp-admin) on the fly (files and/or database is not changed) by replacing <bdo style="direction:ltr">http://</bdo> with <bdo style="direction:ltr">https://</bdo> for linked resources.<br><span style="color: #d94f4f">If you are not sure leave OFF</span>', 'dragonizer'),
			),
			'force_secure_cookies' => array(
				'title' => __('Force Secure Cookies', 'dragonizer'),
				'description' => __('Cookies are small packets of data stored by the website on your computer so it remembers information about you like your logged in state. But most times this information in sensitive, so you should enable this option to harden the way cookies are interacted with by your browser and to prevent anyone else from reading them.', 'dragonizer'),
			),
			// 'default_url' => array(
			// 	'title' => __('Default HTTPS URL', 'dragonizer'),
			// 	'description' => __("Change your site's default URL to https.<br><span style='color: green'>If you are not sure leave ON</span>", 'dragonizer'),
			// ),
			// 'php_redirect' => array(
			// 	'title' => __('Force HTTPS (php)', 'dragonizer'),
			// 	'description' => __('Redirect all <bdo style="direction:ltr">http://</bdo> requests to <bdo style="direction:ltr">https:// via php</bdo>. (301 redirect, seo friendly)<br><span style="color: #d94f4f">If you are not sure leave OFF (Redirect with htaccess is faster)</span>', 'dragonizer'),
			// ),
		);

		$this->ssl_secure_settings = array(
			'enable_hsts' => array(
				'title' => __('Enable HSTS', 'dragonizer'),
				'description' => __('HSTS (HTTP Strict Transport Security) is a header sent by your website to your visitor\'s browser telling it to only use HTTPS to connect to the website. If someone tried to perform a man-in-the-middle attack and redirect the visitor to their own malicious version of the domain the browser will refuse to load the website via HTTP and force them to show a valid SSL certificate for the domain, which they will not have and thus the attack will fail.', 'dragonizer'),
			),
			'x_content_options' => array(
				'title' => __('X Content Type Options', 'dragonizer'),
				'description' => __('This header prevents MIME-sniffing, which is used to disguise the content type of malicious files being uploaded to the website.', 'dragonizer'),
			),
			'referrer_policy' => array(
				'title' => __('Referrer Policy', 'dragonizer'),
				'description' => __('To prevent data leakage, only send referrer information when navigating to the same protocol (HTTPS->HTTPS) and not when downgrading (HTTPS->HTTP).', 'dragonizer'),
			),
			'x_frame_options' => array(
				'title' => __('X Frame Options', 'dragonizer'),
				'description' => __("This header prevents your site from being loaded in an iFrame on other domains. This is used to prevent clickjacking attacks.<br><span style='color: #d94f4f'>Don't select this option if each page of your site opens in another site as an iframe.</span>", 'dragonizer'),
			),
			'permissions_policy' => array(
				'title' => __('Permissions Policy', 'dragonizer'),
				'description' => __('The Permissions Policy allows you to specify which browser resources to allow on your site (i.e. microphone, webcam, etc.).', 'dragonizer'),
			),
			'block_popups' => array(
				'title' => __('Block third-party popups', 'dragonizer'),
				'description' => __("Potential attackers can't access your global object if they were to open it in a popup, preventing a set of cross-origin attacks dubbed XS-Leaks.", 'dragonizer'),
			),
			'sharing_resources' => array(
				'title' => __('Sharing resources', 'dragonizer'),
				'description' => __("Select if your site is used as a resource on other websites. Used to generate the Cross-Origin policy security header.<br><span style='color: #d94f4f'>Sites and applications that connect to your site with the REST API may be disconnected</span>", 'dragonizer'),
			),
			'embedder-Policy' => array(
				'title' => __('Cross origin policy', 'dragonizer'),
				'description' => __("Prevents a document from loading any cross-origin resources that don't explicitly grant the document permission.", 'dragonizer'),
			),
			'security-Policy' => array(
				'title' => __('Content security policy', 'dragonizer'),
				'description' => __("Allows you to control resources the user agent is allowed to load for a given page. This helps guard against cross-site scripting attacks (Cross-site_scripting).", 'dragonizer'),
			),
			'cross-Domain-Policies' => array(
				'title' => __('X-Permitted policies', 'dragonizer'),
				'description' => __("Prevents others to embed your website e.g. into adobe flash applications or PDF documents. This can be completely forbidden.", 'dragonizer'),
			),
		);

		$this->ssl_secure_configs_apache = array(
			'htaccess_redirect' => array(
				'title' => __('Force HTTPS (htaccess)', 'dragonizer'),
				'description' => __('Redirect all <bdo style="direction:ltr">http://</bdo> requests to <bdo style="direction:ltr">https:// via htaccess</bdo>. (301 redirect, seo friendly)', 'dragonizer'),
			),
			'htaccess_remove_www' => array(
				'title' => __('Remove www from url', 'dragonizer'),
				'description' => __('Remove www from all urls via .htaccess as soon as the request is received. (301 redirect, seo friendly)', 'dragonizer'),
			),
			'security' => array(
				'title' => __('Enhanced Security Rules', 'dragonizer'),
				'description' => __('Implements critical security measures including directory browsing protection, system file protection, PHP execution control, and malicious query filtering via .htaccess rules.', 'dragonizer'),
			),
			'htaccess_php' => array(
				'title' => __('How to set security headers', 'dragonizer'),
				'type' => 'select',
				'types' => ['htaccess', 'php'],
				'description' => __('Using .htaccess for send HTTP headers is faster, more efficient and compatible with caching.', 'dragonizer'),
			),
		);

		if (DRFS::is_openlitespeed()) {
			unset($this->ssl_secure_configs_apache['htaccess_php']['types']);
			$this->ssl_secure_configs_apache['htaccess_php']['types'] = ['php'];
		} elseif (!(DRFS::is_apache() || DRFS::is_litespeed())) {
			unset($this->ssl_secure_configs_apache['htaccess_redirect']);
			unset($this->ssl_secure_configs_apache['htaccess_remove_www']);
			unset($this->ssl_secure_configs_apache['htaccess_php']['types']);
			$this->ssl_secure_configs_apache['htaccess_php']['types'] = ['php'];
		}

		$this->ssl_secure_configs_nginx = array(
			// 'nginx_redirect' => array(
			// 	'title' => __('Force HTTPS (nginx.conf)', 'dragonizer'),
			// 	'description' => __('Redirect all <bdo style="direction:ltr">http://</bdo> requests to <bdo style="direction:ltr">https:// via nginx.conf</bdo>. (301 redirect, seo friendly)', 'dragonizer'),
			// ),
			// 'nginx_php' => array(
			// 	'title' => __('How to set security headers', 'dragonizer'),
			// 	'type' => 'select',
			// 	'types' => ['nginx.conf' ,'php'],
			// 	'description' => __('Using nginx.conf for send HTTP headers is faster, more efficient and compatible with caching.', 'dragonizer'),
			// ),
		);

		$this->ssl_secure_permissions_policies = array(
			'accelerometer' => array(
				'title' => __('accelerometer', 'dragonizer'),
			),
			'autoplay' => array(
				'title' => __('autoplay', 'dragonizer'),
			),
			'camera' => array(
				'title' => __('camera', 'dragonizer'),
			),
			'encrypted-media' => array(
				'title' => __('encrypted-media', 'dragonizer'),
			),
			'fullscreen' => array(
				'title' => __('fullscreen', 'dragonizer'),
			),
			'geolocation' => array(
				'title' => __('geolocation', 'dragonizer'),
			),
			'gyroscope' => array(
				'title' => __('gyroscope', 'dragonizer'),
			),
			'magnetometer' => array(
				'title' => __('magnetometer', 'dragonizer'),
			),
			'microphone' => array(
				'title' => __('microphone', 'dragonizer'),
			),
			'midi' => array(
				'title' => __('midi', 'dragonizer'),
			),
			'payment' => array(
				'title' => __('payment', 'dragonizer'),
			),
			'picture-in-picture' => array(
				'title' => __('picture-in-picture', 'dragonizer'),
			),
			'sync-xhr' => array(
				'title' => __('sync-xhr', 'dragonizer'),
			),
			'usb' => array(
				'title' => __('usb', 'dragonizer'),
			)
		);

		$this->copyright = array(
			'select_all' => array(
				'title' => __('Disable Select All', 'dragonizer'),
				'description' => __('Protect Your Text from Being Copied by Select All HotKeys.<br><span style="color:#7878FF" class="hotkeys" >This option will disable <b>Ctrl+A</b> in (Windows and Linux) and <b>⌘+A</b> in (macOS)</span>', 'dragonizer'),
			),
			'сopy' => array(
				'title' => __('Disable Copy', 'dragonizer'),
				'description' => __('Protect Your Text from Being Copied by Copy HotKeys.<br><span style="color:#7878FF" class="hotkeys">This option will disable <b>Ctrl+C</b> in (Windows and Linux) and <b>⌘+C</b> in (macOS)</span>', 'dragonizer'),
			),
			'cut' => array(
				'title' => __('Disable Cut', 'dragonizer'),
				'description' => __('Protect Your Text from Being Copied by Cut HotKeys.<br><span style="color:#7878FF" class="hotkeys">This option will disable <b>Ctrl+X</b> in (Windows and Linux) and <b>⌘+X</b> in (macOS)</span>', 'dragonizer'),
			),
			'paste' => array(
				'title' => __('Disable Paste', 'dragonizer'),
				'description' => __('Disable Paste HotKeys.<br><span style="color:#7878FF" class="hotkeys">This option will disable <b>Ctrl+V</b> in (Windows and Linux) and <b>⌘+V</b> in (macOS)</span>', 'dragonizer'),
			),
			'save' => array(
				'title' => __('Disable Save', 'dragonizer'),
				'description' => __('Protect Your Text from Being Saved by Save HotKeys.<br><span style="color:#7878FF" class="hotkeys">This option will disable <b>Ctrl+S</b> in (Windows and Linux) and <b>⌘+S</b> in (macOS)</span>', 'dragonizer'),
			),
			'view_source' => array(
				'title' => __('Disable View Source', 'dragonizer'),
				'description' => __('Disable to View Source Code of Page by HotKeys.<br><span style="color:#7878FF" class="hotkeys">This option will disable <b>Ctrl+U</b> in (Windows and Linux) and <b>⌘+U</b> in (macOS)</span>', 'dragonizer'),
			),
			'print_page' => array(
				'title' => __('Disable Print Page', 'dragonizer'),
				'description' => __('Protect Your Page from Being Printed by HotKeys.<br><span style="color:#7878FF" class="hotkeys">This option will disable <b>Ctrl+P</b> in (Windows and Linux) and <b>⌘+P</b> in (macOS)</span>', 'dragonizer'),
			),
			'developer_tool' => array(
				'title' => __('Disable Developer Tool', 'dragonizer'),
				'description' => __('Disable to View Source Code of Page by Developer Tools.<br><span style="color:#7878FF" class="hotkeys">This option will disable <b>Ctrl+Shift+I</b> or <b>F12</b> in (Windows and Linux) and <b>⌘+⌥+I</b> in (macOS)</span>', 'dragonizer'),
			),
			'right_click' => array(
				'title' => __('Disable Right Click', 'dragonizer'),
				'description' => __('Protect Your Content from Being Copied by Context Menu.<br><span style="color:#7878FF" class="hotkeys">This option will disable Mouse Right Click <b><span class="dashicons dashicons-menu-alt"></span></b>', 'dragonizer'),
			),
			'reader_mode' => array(
				'title' => __('Disable Safari Reader Mode', 'dragonizer'),
				'description' => __('Protect Your Text and Images from being copied in the Safari Reader mode.<br><span style="color:#7878FF" class="hotkeys">This option will disable Reader mode in Safari: <b>⌘+Shift+R</b> in (macOS)</span>', 'dragonizer'),
			),
			'text_selection' => array(
				'title' => __('Disable Text Selection', 'dragonizer'),
				'description' => __('Disable Text Highlight (Text Selection) by Mouse.<br><span style="color:#7878FF" class="hotkeys">This option will disable text selection <b><span class="dashicons dashicons-text"></span></b>', 'dragonizer'),
			),
			'image_dragging' => array(
				'title' => __('Disable Image Dragging', 'dragonizer'),
				'description' => __('Disable Image Dragging by Mouse.<br><span style="color:#7878FF" class="hotkeys">This option will disable Image Dragging <b><span class="dashicons dashicons-move"></span></b>', 'dragonizer'),
			),
			'javascript' => array(
				'title' => __('JavaScript Required', 'dragonizer'),
				'description' => __('<br>This message will be displayed if JavaScript is not enabled.', 'dragonizer'),
				'type' => 'editor',
				'default' => __('Please Enable <strong><span style="color: #800080;">JavaScript</span></strong> in your Browser to Visit this Site.', 'dragonizer'),
				'height' => 100,
			),
		);

		$this->database = array(
			'all' => array(
				'title' => __('Delete all', 'dragonizer'),
				'description' => __('Selecting this option will delete all items.<br><span style="color: #d94f4f">It is better to check all the following options first</span>', 'dragonizer'),
			),
			'autodraft' => array(
				'title' => __('Auto Drafts', 'dragonizer'),
				'description' => __('WordPress automatically saves Pages or Posts as a draft in Database. This is called an Auto Draft.', 'dragonizer')
			),
			'transient_feed' => array(
				'title' => __('Dashboard Transient Feed', 'dragonizer'),
				'description' => __('Transients Feed in WordPress allow developers to store information in your database with an expiration time.', 'dragonizer')
			),
			'unapproved_comments' => array(
				'title' => __('Unapproved Comments', 'dragonizer'),
				'description' => __('Unapproved Comments in WordPress are those comments which are still pending to be approved.', 'dragonizer')
			),
			'comments_meta' => array(
				'title' => __('Orphan Comments Meta', 'dragonizer'),
				'description' => __('Orphan Comments Meta in WordPress holds miscellaneous bits of extra information of comment.', 'dragonizer')
			),
			'posts_meta' => array(
				'title' => __('Orphan Posts Meta', 'dragonizer'),
				'description' => __('Orphan Posts Meta in WordPress is Meta Data belonging to posts which no longer exist.', 'dragonizer')
			),
			'relationships' => array(
				'title' => __('Orphan Relationships', 'dragonizer'),
				'description' => __('Orphan Relationships in WordPress hold junk or obsolete Category and Tag.', 'dragonizer')
			),
			'revision' => array(
				'title' => __('Revisions', 'dragonizer'),
				'description' => __('WordPress Revisions system stores a record of each saved draft or published an update.', 'dragonizer')
			),
			'remove_pingbacks' => array(
				'title' => __('Pingbacks', 'dragonizer'),
				'description' => __('In WordPress, Ping-back is a type of comment that is created when you link to another blog post where Ping backs are enabled.', 'dragonizer')
			),
			'remove_trackbacks' => array(
				'title' => __('Trackbacks', 'dragonizer'),
				'description' => __('In WordPress, Trackbacks are a way to notify legacy blog systems that you have linked to them.', 'dragonizer')
			),
			'remove_transient_options' => array(
				'title' => __('Expired Transient Options', 'dragonizer'),
				'description' => __('Transient Options are like a basic cache system used by WordPress.', 'dragonizer')
			),
			'spam' => array(
				'title' => __('Spam Comments', 'dragonizer'),
				'description' => __('Spam Comments are unwanted comments in database.', 'dragonizer')
			),
			'trash' => array(
				'title' => __('Trash Comments', 'dragonizer'),
				'description' => __('Comments which are stored in WordPress Trash after deletion.', 'dragonizer')
			),
			'draft' => array(
				'title' => __('Drafts', 'dragonizer'),
				'description' => __('Drafts are New Post or Page created as Draft in WordPress.', 'dragonizer')
			),
			'deleted_posts' => array(
				'title' => __('Deleted Posts', 'dragonizer'),
				'description' => __('Deleted Posts are posts which are removed from database.', 'dragonizer')
			),
			'duplicated_postmeta' => array(
				'title' => __('Duplicated Post Meta', 'dragonizer'),
				'description' => __('Duplicated values of Posts stored in a Posts Table in database.', 'dragonizer')
			),
			'oembed_caches' => array(
				'title' => __('oEmbed Caches in Post Meta', 'dragonizer'),
				'description' => __('oEmbed Caches in Post Meta hold data related to Embeddable Content in database.', 'dragonizer')
			),
			'duplicated_commentmeta' => array(
				'title' => __('Duplicated Comment Meta', 'dragonizer'),
				'description' => __('Holds information of Duplicate Comments in Comments Table in database.', 'dragonizer')
			),
			'orphan_user_meta' => array(
				'title' => __('Orphan User Meta', 'dragonizer'),
				'description' => __('Holds orphan data of an Usermeta table in database.', 'dragonizer')
			),
			'duplicated_usermeta' => array(
				'title' => __('Duplicated User Meta', 'dragonizer'),
				'description' => __('Holds information of Duplicate user meta data in database.', 'dragonizer')
			),
			'orphaned_term_relationships' => array(
				'title' => __('Orphaned Term Relationships', 'dragonizer'),
				'description' => __('Hold junk or obsolete term Category and Tag in database.', 'dragonizer')
			),
			'unused_terms' => array(
				'title' => __('Unused Terms', 'dragonizer'),
				'description' => __('Hold term data which are not used by WordPress.', 'dragonizer')
			)
		);

		$this->minify_html = array(
			'enable' => array(
				'title' => __('Minify HTML', 'dragonizer'),
				'description' => __('By selecting this option, html source of your site will be minified.', 'dragonizer'),
			),
			'inline_css_minify' => array(
				'title' => __('Minify Styles', 'dragonizer'),
				'description' => __('Reduce your page load time and increase your site performance by minifying your inline styles.', 'dragonizer'),
			),
			'inline_js_minify' => array(
				'title' => __('Minify JavaScripts', 'dragonizer'),
				'description' => __('Reduce your page load time and increase your site performance by minifying your inline javascript codes.', 'dragonizer'),
			),
			'closetag' => array(
				'title' => __('Remove XHTML Closing Tag', 'dragonizer'),
				'description' => __('Remove XHTML closing tag from HTML5 void elements.', 'dragonizer'),
			),
			'domain' => array(
				'title' => __('Remove The Relative Domain', 'dragonizer'),
				'description' => __('Remove the relative domain from the internal URLs.<br><span style="color: #d94f4f">If you use Ajax Loader on your site, it is better not to activate it</span>', 'dragonizer'),
			),
			'scheme' => array(
				'title' => __('Remove HTTP/HTTPS', 'dragonizer'),
				'description' => __('Remove the HTTP & HTTPS schemes from all URLs.<br><span style="color: #d94f4f">If you use Ajax Loader on the your site, it is better not to activate it</span>', 'dragonizer'),
			),
			'noscript' => array(
				'title' => __('Remove NoScript Tags', 'dragonizer'),
				'description' => __("Removes all noscript tags from your site's html source.", 'dragonizer'),
			),
			'unicode_to_utf8' => array(
				'title' => __('Convert Unicode to UTF-8', 'dragonizer'),
				'description' => __('Convert Unicode escape sequences to UTF-8 characters in the HTML source.', 'dragonizer'),
			),
			// 'stats' => array(
			// 	'title'       => __('Display Stats Comment', 'dragonizer'),
			// 	'description' => __('Display the minification stats at the bottom of the HTML source.', 'dragonizer'),
			// ),
			// 'debug' => array(
			// 	'title'       => __('Dragonizer Comment', 'dragonizer'),
			// 	'description' => __('Display the dragonizer html comments at the header and footer of the HTML source.<br><span style="color: #7340bf">To support the Dragonizer</span>', 'dragonizer'),
			// ),
		);

		$this->minify_css = array(
			'css_minify' => array(
				'title' => __('Minify Styles', 'dragonizer'),
				'description' => __('This will remove all unnecessary whitespaces and comments from CSS files to reduce the total file size.<br><span style="color: #d94f4f">If you activate it, check appearance of your site</span>', 'dragonizer'),
			),
			// 'css_merge' => array(
			// 	'title' => __('Merge Styles', 'dragonizer'),
			// 	'description' => __('This will combine all CSS files into minimum possible number.<br><span style="color: #d94f4f">With HTTP/2 you no longer need to merging</span>', 'dragonizer'),
			// ),
			'css_delivery' => array(
				'title' => __('Optimize CSS Delivery', 'dragonizer'),
				'description' => __("This will attempt to extract the critical CSS that is required to format the page above the fold and put this in a <style> element inside the <head> section of the HTML to prevent 'render-blocking'. The combined CSS will then be loaded asynchronously. <span style='color: green'>(Recommended)</span><br><span style='color: #d94f4f'>This is an expensive process.DO NOT use without cache.</span>", 'dragonizer'),
			),
			'css_delay' => array(
				'title' => __('Delay CSS Loading', 'dragonizer'),
				'description' => __("Speed up initial page load by delaying non-critical CSS. <span style='color: green'>(Recommended)</span><br><span style='color: #d94f4f'>Ensure to test your site for optimal performance and appearance.</span>", 'dragonizer'),
			),
			'exclude_css' => array(
				'title' => __('Ignore These Files', 'dragonizer'),
				'type' => 'selector',
				'description' => __("The above will be excluded from being merged or delaying<span style='color: green'>(There is no need to enter the full url, just a part of the url or name is enough)</span>", 'dragonizer'),
			),
		);

		$this->minify_js = array(
			'js_minify' => array(
				'title' => __('Minify JavaScripts', 'dragonizer'),
				'description' => __('This will remove all unnecessary whitespaces and comments from JS files to reduce the total file size.<br><span style="color: #d94f4f">If you activate it, check features of your site</span>', 'dragonizer'),
			),
			// 'js_merge' => array(
			// 	'title' => __('Merge JavaScripts', 'dragonizer'),
			// 	'description' => __('This will combine all javascript files into minimum possible number.<br><span style="color: #d94f4f">With HTTP/2 you no longer need to merging</span>', 'dragonizer'),
			// ),
			'defer' => array(
				'title' => __('Defer All JS Files', 'dragonizer'),
				'description' => __("The 'defer' attribute is added to script tags so it avoids rendering blocking and speed up the download of the web page. <span style='color: green'>(Recommended)</span>", 'dragonizer'),
			),
			'js_delay' => array(
				'title' => __('Delay JavaScript', 'dragonizer'),
				'description' => __("Delay JavaScript execution until user interaction. <span style='color: green'>(Recommended)</span><br><span style='color: #d94f4f'>Do not activate if you are using Cloudflare Rocket Loader</span><br><span style='color: #d94f4f'>If header and first section of page have animation or are made with JavaScript, the appearance of page may will be ruined before any user interacts.</span>", 'dragonizer'),
			),
			'exclude' => array(
				'title' => __('Ignore These Files', 'dragonizer'),
				'type' => 'selector',
				'description' => __("The above will be excluded from being merged and delay JavaScript execution<span style='color: green'>(There is no need to enter the full url, just a part of the url or name is enough)</span>", 'dragonizer'),
			),
		);

		$this->minify_common = array(
			'optimize_known_users' => array(
				'title' => __('Logged-in Users Optimize', 'dragonizer'),
				'description' => __('Enable assets optimizing for logged-in users.<br><span style="color: #d94f4f">Activating this option is not recommended, If you are not sure leave OFF</span>', 'dragonizer'),
			),
			'passive_events' => array(
				'title' => __('Use Passive Events', 'dragonizer'),
				'description' => __("By activating this option, Events with attribute passive perform better for touch screens and mouse wheel.", 'dragonizer'),
			),
			'preconnect' => array(
				'title' => __('preconnect And dns-prefetch', 'dragonizer'),
				'description' => __("By adding preconnect and dns-prefetch commands the browser to load resources before the site is loaded.", 'dragonizer'),
			),
			'swap_fonts' => array(
				'title' => __('Font Display Optimization', 'dragonizer'),
				'description' => __("Append font-display:swap to all @font-face rules to specify how fonts should be displayed while being downloaded.<br><span style='color: green'>For better performance, enable 'Optimize CSS Delivery' option</span>", 'dragonizer'),
			),
			'preload_fonts' => array(
				'title' => __('Preload These Fonts', 'dragonizer'),
				'description' => __("The above fonts will be preloaded for faster loading.<br><span style='color: green'>In most cases, you don't need to enter the full URL. Partial URLs or font names are sufficient.</span><br><span style='color: green'>For optimal performance, enable the 'Optimize CSS Delivery' option.</span>", 'dragonizer'),
				'type' => 'selector',
			),
		);

		$this->shamsi = array(
			'shamsi_date' => array(
				'title' => __('Persian Date', 'dragonizer'),
				'description' => __("By enabling this, Dates will convert to Persian (Jalali) dates", 'dragonizer'),
			),
			'persian_numbers' => array(
				'title' => __('Persian Numbers', 'dragonizer'),
				'description' => __('By enabling this, Numbers will convert to Persian<br><span style="color: #d94f4f">It is better to choose a font with Farsi numbers from the "Site Customizer" section instead of this option</span>', 'dragonizer'),
			),
			'permalinks' => array(
				'title' => __('Convert in permalinks', 'dragonizer'),
				'description' => __('By enabling this option, dates in archive and permalinks will be converted to Solar Hijri (Jalali) dates.<br><span style="color: darkblue">(eg. <bdo style="direction:ltr">https://example.com/2024/03/20 => https://example.com/1403/01/01</bdo>)</span>', 'dragonizer'),
			),
			'fix_gutenberg' => array(
				'title' => __('Gutenberg Compatibility', 'dragonizer'),
				'description' => __("Enabling this option makes Jalali date compatible with Gutenberg", 'dragonizer'),
			),
			'fix_gravityfroms' => array(
				'title' => __('Gravity Froms Compatibility', 'dragonizer'),
				'description' => __("Enabling this option makes Jalali date compatible with Gravity Froms", 'dragonizer'),
			),
			'fix_elementor' => array(
				'title' => __('Elementor Compatibility', 'dragonizer'),
				'description' => __("Enabling this option makes Jalali date compatible with Elementor", 'dragonizer'),
			),
			'fix_buddyboss' => array(
				'title' => __('Buddyboss Compatibility', 'dragonizer'),
				'description' => __("Enabling this option makes Jalali date compatible with Buddyboss", 'dragonizer'),
			),
			'fix_woocommerce' => array(
				'title' => __('WooCommerce Compatibility', 'dragonizer'),
				'description' => __("Enabling this option makes Jalali date compatible with WooCommerce", 'dragonizer'),
			),
		);

		$this->shamsi_woocommerce = array(
			'fix_mobile' => array(
				'title' => __('Fix mobile field', 'dragonizer'),
				'description' => __("If the user has entered Farsi numbers in the mobile field of the settlement page, English numbers will be stored in the database", 'dragonizer'),
			),
			'validate_mobile' => array(
				'title' => __('Mobile field validation', 'dragonizer'),
				'description' => __("The mobile field will be validated on the checkout page", 'dragonizer'),
			),
			'fix_postal' => array(
				'title' => __('Fix postal code field', 'dragonizer'),
				'description' => __("If the user has entered Farsi numbers in the postal code field of the settlement page, English numbers will be stored in the database", 'dragonizer'),
			),
			'validate_postal' => array(
				'title' => __('Postal code field validation', 'dragonizer'),
				'description' => __("The postal code field will be validated on the checkout page", 'dragonizer'),
			),
			'zero_to_free' => array(
				'title' => __('Convert price 0 to free', 'dragonizer'),
				'description' => __("If the price of the product is 0, the word <b>free</b> will be displayed instead", 'dragonizer'),
			),
			'empty_to_call' => array(
				'title' => __('Convert empty price to call', 'dragonizer'),
				'description' => __("If the price of a product is not entered, <b>Call</b> will be displayed instead", 'dragonizer'),
			),
			'iran_cities' => array(
				'title' => __('Cities of Iran', 'dragonizer'),
				'description' => __("Adds Iranian cities to the checkout page", 'dragonizer'),
			),
			'field_swap' => array(
				'title' => __('City and Province Swap', 'dragonizer'),
				'description' => __("Enabling this feature allows you to change the order of city and province fields (It is only needed in some themes).", 'dragonizer'),
			),
			'iran_units' => array(
				'title' => __('Iranian currency units', 'dragonizer'),
				'description' => __("Rials, thousand Rials, Tomans and thousand Tomans units will be added to WooCommerce settings (the meta tag will remain the same as IRR to identify the price by search engines)<br><span style='color: darkblue'>If you want to use this option and choose a currency other than Rial, be sure to use Rank Math plugin for seo</span>", 'dragonizer'),
			),
			'vpn_alert' => array(
				'title' => __('VPN Detection Alert', 'dragonizer'),
				'description' => __("Displays a warning message to users when detecting VPN usage during checkout to prevent payment gateway errors", 'dragonizer'),
			),
			// 'iran_gateways' => array(
			// 	'title' => __('Iranian payment gateways', 'dragonizer'),
			// 	'description' => __("Adding authentic Iranian payment portals (Zarinpal, Sepehr, Saman, Mellat, Piping, Zibal, and Aqayepardakht) with advanced features, including custom logo setting, support for various types of currency and managing payment messages<br><span style='color: darkblue'>Please test and inform support if you encounter any issues. Also, if your preferred gateway is not listed, let us know so we can consider adding it in future versions</span>", 'dragonizer'),
			// ),
		);

		$this->login_customizer = array(
			'default' => array(
				'thumbnail' => _dr(DRAGONIZER_PAR_URL, 'login-page-templates', 'thumbnails', 'default.webp'),
				'logo-image' => '',
				'css-file' => '',
			),
			'template-01' => array(
				'thumbnail' => _dr(DRAGONIZER_PAR_URL, 'login-page-templates', 'thumbnails', 'template-01.webp'),
				'logo-image' => '',
				'css-file' => '',
			),
			'template-02' => array(
				'thumbnail' => _dr(DRAGONIZER_PAR_URL, 'login-page-templates', 'thumbnails', 'template-02.webp'),
				'logo-image' => '',
				'css-file' => '',
			),
			'template-03' => array(
				'thumbnail' => _dr(DRAGONIZER_PAR_URL, 'login-page-templates', 'thumbnails', 'template-03.webp'),
				'logo-image' => '',
				'css-file' => '',
			),
			'template-04' => array(
				'thumbnail' => _dr(DRAGONIZER_PAR_URL, 'login-page-templates', 'thumbnails', 'template-04.webp'),
				'logo-image' => '',
				'css-file' => '',
			),
			'template-05' => array(
				'thumbnail' => _dr(DRAGONIZER_PAR_URL, 'login-page-templates', 'thumbnails', 'template-05.webp'),
				'logo-image' => '',
				'css-file' => '',
			),
		);

		$this->login_customizer_opts = array(
			'blur_background_image' => array(
				'title' => __('Blur background image', 'dragonizer'),
				'description' => __('Enabling this option will blur your login page background image.', 'dragonizer'),
			),
			'disable_lang_selector' => array(
				'title' => __('Remove anguage Selector', 'dragonizer'),
				'description' => __('Enabling this option will remove login language selector from login page.', 'dragonizer'),
			),
			'disable_register_link' => array(
				'title' => __('Remove Register | Lost password', 'dragonizer'),
				'description' => __('Enabling this option will remove register or lost your password link from login page.', 'dragonizer'),
			),
			'disable_back_to_site' => array(
				'title' => __('Remove Back to site', 'dragonizer'),
				'description' => __('Enabling this option will remove back to your website link from login page.', 'dragonizer'),
			),
			'disable_privacy_link' => array(
				'title' => __('Remove Privacy and policy', 'dragonizer'),
				'description' => __('Enabling this option will remove privacy and policy link from login page.', 'dragonizer'),
			),
			'last_login' => array(
				'title' => __('Last Login Column', 'dragonizer'),
				'description' => __('Log when users on the site last logged in and display the date and time in the users list table.', 'dragonizer'),
			),
			'error_login' => array(
				'title' => __('Hide wp-login errors', 'dragonizer'),
				'description' => __('Hide errors when a person try to connect to your WordPress (notably, hide your username)', 'dragonizer'),
			),
			'custom_login' => array(
				'title' => __('Change login URL', 'dragonizer'),
				'description' => __('Protect your website by changing the login URL and preventing access to the wp-login.php page and the wp-admin directory to non-connected people.<br><span style="color: #d94f4f">Write down the new url, if you forget it, you will not be able to enter the dashboard</span>', 'dragonizer'),
				'type' => 'input',
				'default' => 'securelogin',
			),
			'custom_redirect' => array(
				'title' => __('Redirect URL', 'dragonizer'),
				'description' => __('Set a URL for unauthorized login redirects. Enhances security by directing unknown users to a specific page.<br><span style="color: #d94f4f">Important: Choose a low-resource page to mitigate bot attack impacts.</span>', 'dragonizer'),
				'type' => 'input',
				'default' => 'securelogin',
			),
		);

		$this->wp_tweaks_main = array(
			'dashboard' => array(
				'title' => __('Dashboard Tweaks', 'dragonizer'),
				'type' => 'select',
				'default' => 'Special',
				'values'   => ['Special', 'Luxury', 'Vineyard', 'Nostalgia', 'Lavender', 'Seashore', 'Gray', 'Excitement', 'Calm', 'Lawn', 'Jade',  'Night', 'Gum', 'Chocolate'],
				'description' => __('Tweak styles in the admin to make it more usable and likable. <span style="color: green">(Same for all users)</span><br><span style="color: #7340bf">The dashboard style in the Dragonizer settings page will always be "Excitement"</span>', 'dragonizer'),
			),
			'adminbar' => array(
				'title' => __('Hide admin bar', 'dragonizer'),
				'description' => __('Show admin bar for admin users only', 'dragonizer'),
			),
			'logo' => array(
				'title' => __('Admin bar logo', 'dragonizer'),
				'description' => __('Remove WordPress logo from admin bar', 'dragonizer'),
			),
			'new' => array(
				'title' => __('Admin bar "+ New"', 'dragonizer'),
				'description' => __('Remove "+ New" button from admin bar', 'dragonizer'),
			),
			'howdy' => array(
				'title' => __('Admin bar "Howdy"', 'dragonizer'),
				'description' => __('Remove "Howdy" from admin bar', 'dragonizer'),
			),
			'wp_version' => array(
				'title' => __('Footer WP version', 'dragonizer'),
				'description' => __('Hide WordPress version in admin footer to all but admins', 'dragonizer'),
			),
			'help' => array(
				'title' => __('Remove help button', 'dragonizer'),
				'description' => __('Removes the help button from the top of the admin panel', 'dragonizer'),
			),
			'plugins_update' => array(
				'title' => __('Plugins Update Date', 'dragonizer'),
				'description' => __('Adds a column to the plugins page and displays the last update date', 'dragonizer'),
			),
			'footer' => array(
				'title' => __('Custom admin footer text', 'dragonizer'),
				'description' => __('Set a Custom admin footer text (HTML)', 'dragonizer'),
				'type' => 'editor',
				'default' => __('This text has been <strong><span style="color: #800080;">personalized</span> </strong>by <strong><span style="color: #ff0000;">Dragonizer</span> </strong> 👑', 'dragonizer'),
				'height' => 100,
			),
			'font' => array(
				'title' => __('Custom admin panel font', 'dragonizer'),
				'description' => '',
				'type' => 'select',
				'default' => 'YekanBakh',
				'values' => ['YekanBakh', 'IRANSansDN', 'IRANSansX', 'IRANYekanX', 'Estedad', 'Alibaba', 'Mikhak', 'Kalameh', 'Pelak', 'Peyda', 'Vazirmatn', 'Borna', 'Dana']
			),
			'login_font' => array(
				'title' => __('Custom login page font', 'dragonizer'),
				'description' => '',
				'type' => 'select',
				'default' => 'YekanBakh',
				'values' => ['YekanBakh', 'IRANSansDN', 'IRANSansX', 'IRANYekanX', 'Estedad', 'Alibaba', 'Mikhak', 'Kalameh', 'Pelak', 'Peyda', 'Vazirmatn', 'Borna', 'Dana']
			),
			'front_font' => array(
				'title' => __('Custom front font', 'dragonizer'),
				'description' => '',
				'type' => 'select',
				'default' => 'YekanBakh',
				'values' => ['YekanBakh', 'IRANSansDN', 'IRANSansX', 'IRANYekanX', 'Estedad', 'Alibaba', 'Mikhak', 'Kalameh', 'Pelak', 'Peyda', 'Vazirmatn', 'Borna', 'Dana']
			),
			'front_titles_font' => array(
				'title' => __('Custom front titles font', 'dragonizer'),
				'description' => 'By activating this option, the font of the titles will be different from the main font of the template',
				'type' => 'select',
				'default' => 'Pinar',
				'values' => ['Pinar', 'Sahel', 'Shilia']
			),
			'persian_numbers' => array(
				'title' => __('Persian Numbers', 'dragonizer'),
				'description' => __('By enabling this option, fonts with Persian numbers will be used', 'dragonizer'),
			),
		);

		__('By activating this option, the font of the titles will be different from the main font of the template');

		__('IRANSansX', 'dragonizer');
		__('Estedad', 'dragonizer');
		__('Vazirmatn', 'dragonizer');
		__('Mikhak', 'dragonizer');
		__('IRANYekanX', 'dragonizer');
		__('Dana', 'dragonizer');
		__('IRANSansDN', 'dragonizer');
		__('YekanBakh', 'dragonizer');
		__('Kalameh', 'dragonizer');
		__('Pelak', 'dragonizer');
		__('Peyda', 'dragonizer');
		__('Alibaba', 'dragonizer');
		__('Borna', 'dragonizer');

		__('Pinar', 'dragonizer');
		__('Sahel', 'dragonizer');
		__('Shilia', 'dragonizer');

		$this->wp_tweaks_other = array(
			'gutenberg' => array(
				'title' => __('Disable gutenberg', 'dragonizer'),
				'description' => __('Disable gutenberg and enable classic editor', 'dragonizer'),
			),
			'block_widgets' => array(
				'title' => __('Classic Widgets', 'dragonizer'),
				'description' => __('Disables the block editor from managing widgets.', 'dragonizer'),
			),
			'site_cm' => array(
				'title' => __('"website" field in comment', 'dragonizer'),
				'description' => __('Remove the URL field from comment forms. This may only work on the core comment form, and not on custom ones added to themes.', 'dragonizer'),
			),
			'update' => array(
				'title' => __('Hide WordPress update nag', 'dragonizer'),
				'description' => __('Hide WordPress update nag to all but admins', 'dragonizer'),
			),
			'query' => array(
				'title' => __('Disable author query', 'dragonizer'),
				'description' => __('Disables author search via url (e.g: yoursite.com/?author=1)', 'dragonizer'),
			),
			'pages' => array(
				'title' => __('Disable author pages', 'dragonizer'),
				'description' => __('Disables author pages (e.g: yoursite.com/author/admin)', 'dragonizer'),
			),
			'search_highlighting' => array(
				'title' => __('Search Highlighting', 'dragonizer'),
				'description' => __('Highlights the search phrase in search results.<br><span style="color:#7878FF" class="hotkeys" >To further modify the styling, you can add your own style, such as <bdo style="direction:ltr"><b>.dragonizer_search_matched{background:khaki!important}</b></bdo></span>', 'dragonizer'),
			),
			'search' => array(
				'title' => __('Search Redirect', 'dragonizer'),
				'description' => __('If there is a single search result then redirect to the result, rather than displaying a list of results.', 'dragonizer'),
			),
			'featured_image_column' => array(
				'title' => __('Featured Image Column', 'dragonizer'),
				'description' => __('Show featured image column on list tables', 'dragonizer'),
			),
			'show_excerpt_column' => array(
				'title' => __('Excerpt Column', 'dragonizer'),
				'description' => __('Show excerpt column on list tables', 'dragonizer'),
			),
			'enhance_list_tables' => array(
				'title' => __('Enhance List Tables', 'dragonizer'),
				'description' => __('Show ID in action rows, Remove comments column and Remove tags column (for posts)', 'dragonizer'),
			),
		);


		$this->wp_optimizer_core = array(
			'wp_updates' => array(
				'title' => __('wp core update', 'dragonizer'),
				'description' => __('Disable wordpress update <br><span style="color: #d94f4f">If you are not sure leave OFF</span>', 'dragonizer'),
			),
			'plugin_updates' => array(
				'title' => __('Plugins update', 'dragonizer'),
				'description' => __('Disable plugins update <br><span style="color: #d94f4f">If you are not sure leave OFF</span>', 'dragonizer'),
			),
			'theme_updates' => array(
				'title' => __('Themes update', 'dragonizer'),
				'description' => __('Disable Themes update <br><span style="color: #d94f4f">If you are not sure leave OFF</span>', 'dragonizer'),
			),
			'automatic_updates' => array(
				'title' => __('Automatic updates', 'dragonizer'),
				'description' => __('Disable automatic updates', 'dragonizer'),
			),
			'page-updates' => array(
				'title' => __('Updates page', 'dragonizer'),
				'description' => __('Remove Updates Page', 'dragonizer'),
			),
			'disable_updates_notices' => array(
				'title' => __('Update notices', 'dragonizer'),
				'description' => __('Disable update notices', 'dragonizer'),
			),
			'mail_updates' => array(
				'title' => __('Update emails', 'dragonizer'),
				'description' => __('Disable WordPress update notices emails', 'dragonizer'),
			),
			'user_mail' => array(
				'title' => __('New User Email', 'dragonizer'),
				'description' => __('Disables the email sent to the administrator when a new user creates an account.', 'dragonizer'),
			),
			'disable_admin_notices' => array(
				'title' => __('Admin notices', 'dragonizer'),
				'description' => __('Disable admin notices <br><span style="color: #d94f4f">If you are not sure leave OFF</span>', 'dragonizer'),
			),
			'disable_site_health' => array(
				'title' => __('Site health', 'dragonizer'),
				'description' => __('Disable Site Health screen', 'dragonizer'),
			),
			'disable_comments' => array(
				'title' => __('Comments', 'dragonizer'),
				'description' => __('Disable comments feature from blog <br><span style="color: #d94f4f">If you are not sure leave OFF</span>', 'dragonizer'),
			),
		);

		$this->wp_optimizer_optimize = array(
			'http_block' => array(
				'title' => __('Block external requests', 'dragonizer'),
				'description' => __('It will block some requests for plugins and templates to its owner servers, which will greatly increase the speed of the admin area.', 'dragonizer'),
			),
			'err_404' => array(
				'title' => __('Fast 404s', 'dragonizer'),
				'description' => __('Disable 404 pages for static files like images. (Using htaccess)', 'dragonizer'),
			),
			'widgets' => array(
				'title' => __('Dashboard widgets', 'dragonizer'),
				'description' => __('Remove some default dashboard widgets (useless for clients)', 'dragonizer'),
			),
			'welcome' => array(
				'title' => __('Dashboard "welcome panel"', 'dragonizer'),
				'description' => __('Remove Dashboard "welcome panel"', 'dragonizer'),
			),
			'disable_gravatars' => array(
				'title' => __('Disable Gravatars', 'dragonizer'),
				'description' => __('Because you have trouble accessing Gravatar in Iran, it is better to disable it.', 'dragonizer'),
			),
			'disable_google_maps' => array(
				'title' => __('Disable Google Maps', 'dragonizer'),
				'description' => __('Removes any instances of Google Maps being loaded across your entire site.', 'dragonizer'),
			),
			'disable_google_fonts' => array(
				'title' => __('Disable Google Fonts', 'dragonizer'),
				'description' => __('Removes any instances of Google Fonts being loaded across your entire site.', 'dragonizer'),
			),
			'disable_pingbacks' => array(
				'title' => __('Disable pingbacks and trackbacks', 'dragonizer'),
				'description' => __('Disable receiving update messages from other sites (pingbacks / trackbacks)', 'dragonizer'),
			),
			'emojicons' => array(
				'title' => __('Emojicons', 'dragonizer'),
				'description' => __('Remove lots of emoji styles and scripts from the header, RSS, mail function, tinyMCE editor...', 'dragonizer'),
			),
			'pdf_thumbnails' => array(
				'title' => __('PDF Thumbnails', 'dragonizer'),
				'description' => __('Starting with 4.7, WordPress tries to make thumbnails from each PDF you upload, potentially crashing your server if GhostScript and ImageMagick aren\'t properly configured. This option disables PDF thumbnails.', 'dragonizer'),
			),
			'limit_revisions' => array(
				'title' => __('Limit Post Revisions', 'dragonizer'),
				'description' => __('Limits the number of stored revisions to 5 only if WP_POST_REVISIONS constant has not been defined.', 'dragonizer'),
			),
			'slow_heartbeat' => array(
				'title' => __('Slow Heartbeat', 'dragonizer'),
				'description' => __('By default, heartbeat makes a post call every 15 seconds on post edit pages. Change to 60 seconds (less CPU usage).', 'dragonizer'),
			),
			'comments_reply_feature' => array(
				'title' => __('JS Comment reply', 'dragonizer'),
				'description' => __('Load the comment-reply JS file only when needed.', 'dragonizer'),
			),
			'empty_trash_soon' => array(
				'title' => __('Empty trash every week', 'dragonizer'),
				'description' => __('You can shorten the time posts are kept in the trash, which is 30 days by default, to 1 week.', 'dragonizer'),
			),
			'capital_P_dangit' => array(
				'title' => __('capital_P_dangit', 'dragonizer'),
				'description' => __('Removes the filter that converts Wordpress to WordPress in every dang title, content or comment text.', 'dragonizer'),
			),
			'disable_editor' => array(
				'title' => __('Plugin and theme editor', 'dragonizer'),
				'description' => __('Disables the plugins and theme editor. A mostly useless tool that can be very dangerous in the wrong hands.', 'dragonizer'),
			),
			'medium_large_size' => array(
				'title' => __('medium_large thumbnail', 'dragonizer'),
				'description' => __('Prevents WordPress from generating the medium_large 768px thumbnail size of image uploads.', 'dragonizer'),
			),
			'comment_autolinks' => array(
				'title' => __('No comment autolinks', 'dragonizer'),
				'description' => __('URLs in comments are converted to links by default. This feature is often exploited by spammers.', 'dragonizer'),
			),
			'recentcomments' => array(
				'title' => __('recent_comments_style', 'dragonizer'),
				'description' => __('Removes a block of inline CSS used by old themes from the header.', 'dragonizer'),
			),
			'wp_resource_hints' => array(
				'title' => __('dns-prefetch', 'dragonizer'),
				'description' => __('Activating this option will remove DNS prefetch to s.w.org and may result in page load optimization.', 'dragonizer'),
			),
			'auto_linking' => array(
				'title' => __('Prevent auto-linking in comments', 'dragonizer'),
				'description' => __('This option will prevent auto-linking URLs in comments.', 'dragonizer'),
			),
			'blank_favicon' => array(
				'title' => __('Add Blank Favicon', 'dragonizer'),
				'description' => __('Adds a blank favicon to your WordPress header, which will prevent a missing favicon or 404 error. (If not exist)', 'dragonizer'),
			),
		);

		if (!DRFS::is_htaccess()) {
			unset($this->wp_optimizer_optimize['err_404']);
		}

		$this->wp_optimizer_tweaks = array(
			'json_api' => array(
				'title' => __('JSON API', 'dragonizer'),
				'description' => __('Remove the JSON-API links from page headers. Also require that API consumers be authenticated.<br><span style="color: #d94f4f">Be careful. Breaks the block editor and many plugins that use the REST API</span>', 'dragonizer'),
			),
			'xmlrpc' => array(
				'title' => __('XML-RPC', 'dragonizer'),
				'description' => __('Disable the XML-RPC interface. ', 'dragonizer'),
			),
			'performance_password' => array(
				'title' => __('Password Strength Meter', 'dragonizer'),
				'description' => __('Removes the WordPress and WooCommerce password strength meter scripts (over 400 KB) from non-essential pages.', 'dragonizer'),
			),
			'jquery_migrate' => array(
				'title' => __('remove jQuery-migrate', 'dragonizer'),
				'description' => __('jQuery-migrate provides diagnostics that can simplify upgrading to new versions of jQuery, you can safely disable it.<br><span style="color: #d94f4f">May break some themes and plugins that depend on legacy code</span>', 'dragonizer'),
			),
			'oembed_scripts' => array(
				'title' => __('Remove oEmbed Scripts', 'dragonizer'),
				'description' => __('Since WordPress 4.4, oEmbed is installed and available by default. If you don’t need oEmbed, you can remove it.', 'dragonizer'),
			),
			'wpcf7_refill' => array(
				'title' => __('Remove CF7 refill', 'dragonizer'),
				'description' => __('Disables the Contact Form 7 refill script. Saves one hit to wp-ajax.php per pageview on cached sites<br><span style="color: #d94f4f">Activate only if you are not using the reCAPTCHA Contact Form 7 field</span>', 'dragonizer'),
			),
			'jpeg_quality' => array(
				'title' => __('Reduce JPEG quality', 'dragonizer'),
				'description' => __('When WordPress generates a JPEG thumbnail it compresses the image to 82% quality. Check this to reduce the default quality to 72%. (It doesn\'t affect original image quality).', 'dragonizer'),
			),
			'gutenberg_css' => array(
				'title' => __('Remove block editor CSS', 'dragonizer'),
				'description' => __('Dequeues Gutenberg CSS stylesheets from the from the frontend.<br><span style="color: #d94f4f">Check this only if you are not using the block editor.</span>', 'dragonizer'),
			),
		);

		$this->wp_optimizer_other = array(
			'other_jetpack' => array(
				'title' => __('Jetpack promotions', 'dragonizer'),
				'description' => __('This option will disable Jetpack-related notices that promote services like the backup services VaultPress or WordPress Apps. Works only if you have Jetpack installed.', 'dragonizer'),
			),
			'other_skyVerge' => array(
				'title' => __('SkyVerge Dashboard', 'dragonizer'),
				'description' => __('This option will disable SkyVerge Dashboard. Works only if you are using SkyVerge plugins.', 'dragonizer'),
			),
			'other_elementor' => array(
				'title' => __('Elementor widget', 'dragonizer'),
				'description' => __('This option will disable Elementor overview Dashboard widget. Works only if you are using Elementor.', 'dragonizer'),
			),
			'other_persian_woocommerce_feed' => array(
				'title' => __('Persian woocommerce', 'dragonizer'),
				'description' => __('This option will disable Persian woocommerce Dashboard widget. Works only if you are using Elementor.', 'dragonizer'),
			),
			'other_redux_dashboard_widget' => array(
				'title' => __('Redux widget', 'dragonizer'),
				'description' => __('This option will disable Redux framework Dashboard widget. Works only if you are using Elementor.', 'dragonizer'),
			),
			'other_yith_dashboard_widget' => array(
				'title' => __('yith widget', 'dragonizer'),
				'description' => __("This option will disable all yith's Dashboard widgets. Works only if you are using any yith plugin.", 'dragonizer'),
			),
			'other_yoast_tweaks' => array(
				'title' => __('Yoast SEO Tweaks', 'dragonizer'),
				'description' => __('Customize your Yoast SEO experience. This single option allows you to disable Ads, Premium nags, Premium menu, remove Yoast SEO item from the WordPress Admin bar, remove HTML comments from the front-end, and remove the Yoast SEO dashboard widget.', 'dragonizer'),
			)
		);

		$this->lazy_load_settings = array(
			// 'mobile' => array(
			// 	'title' => __('Active on mobile', 'dragonizer'),
			// 	'description' => __('By enabling this option, lazy loading is also enabled on mobile devices.<br><span style="color: #d94f4f">It is better not to enable lazy loading on mobile devices</span>', 'dragonizer'),
			// ),
			'autosize' => array(
				'title' => __('Autosize', 'dragonizer'),
				'description' => __('This setting attempts to maintain aspect ratio of images being lazy-loaded to prevent blank spaces under the images after they\'re loaded or distortions in rendering. <span style="color: green">(Recommended)</span><br><span style="color: #d94f4f">May not be compatible with some themes</span>', 'dragonizer'),
			),
			'iframes' => array(
				'title' => __('iframes', 'dragonizer'),
				'description' => __('If enabled will also lazyload iframe elements.<br><span style="color: #d94f4f">Activate only if you use iframe on your site</span>', 'dragonizer'),
			),
			'media' => array(
				'title' => __('Multimedia', 'dragonizer'),
				'description' => __('If enabled will also lazyload video and audio elements.<br><span style="color: #d94f4f">Activate only if you use video and audio on your site</span>', 'dragonizer'),
			),
			'backgrounds' => array(
				'title' => __('Backgrounds', 'dragonizer'),
				'description' => __('Will lazyload background images defined in "style" attributes on HTML elements.<br><span style="color: #d94f4f">Activate only if when any images is used in css of your site</span>', 'dragonizer'),
			),
			'effects' => array(
				'title' => __('Fade in', 'dragonizer'),
				'description' => __('Enable to use fade-in effects when images are scrolled into view.<br><span style="color: #d94f4f">Not recommended</span>', 'dragonizer'),
			),
			'noscript' => array(
				'title' => __('Noscript Support', 'dragonizer'),
				'description' => __('Turn ON to activate Noscript tag as a fallback to show images for users who have JavaScript disabled in their browser.<br><span style="color: #d94f4f">Not recommended</span>', 'dragonizer'),
			),

		);

		$this->lazy_load_excludes = array(
			'excluded_leading' => array(
				'title' => __('Leading Images', 'dragonizer'),
				'description' => __('This number of images will not be lazy load from the page. <span style="color: #d94f4f">(Not recommended)</span>', 'dragonizer'),
			),
			'excluded_urls' => array(
				'title' => __('Exclude folders', 'dragonizer'),
				'type' => 'selector',
				'description' => __("The above will be preloaded<span style='color: green'>(There is no need to enter the full url, just a part of the url or name is enough)</span>", 'dragonizer'),
			),
			'excluded_class' => array(
				'title' => __('Exclude classes', 'dragonizer'),
				'type' => 'selector',
				'description' => __('Enter full class name', 'dragonizer'),
			),
		);

		$this->woo_optimizer_bloat = array(
			'core_user_experience' => array(
				'title' => __('Admin and Analytics', 'dragonizer'),
				'description' => __('Disabling this will remove core interface elements including the homescreen, analytics, navigation, and mobile experiences.', 'dragonizer'),
			),
			'sales_and_marketing' => array(
				'title' => __('Sales and Marketing', 'dragonizer'),
				'description' => __('This option will disable all features related to sales, coupons, and marketing efforts.<br><span style="color:green">Coupon menu entry will stay accessible the old way (WooCommerce -> Coupons)</span>', 'dragonizer'),
			),
			'product_management' => array(
				'title' => __('Product Management', 'dragonizer'),
				'description' => __('Disabling this will affect product imports, variation management, and sample product functionalities.', 'dragonizer'),
			),
			'shipping_and_orders' => array(
				'title' => __('Shipping and Orders', 'dragonizer'),
				'description' => __('Turns off shipping related features and settings crucial for order management.', 'dragonizer'),
			),
			'onboarding_and_education' => array(
				'title' => __('Onboarding and Education', 'dragonizer'),
				'description' => __('Disables features that assist with setting up and learning the platform.', 'dragonizer'),
			),
			'notifications_and_feedback' => array(
				'title' => __('Notifications and Feedback', 'dragonizer'),
				'description' => __('This controls all forms of notifications and feedback mechanisms.', 'dragonizer'),
			),
			'mobile_footer_text' => array(
				'title' => __('Footer massage from emails', 'dragonizer'),
				'description' => __('Remove the "Get the app" from WooCommerce emails footer.', 'dragonizer'),
			),
		);

		$this->woo_optimizer_interface = array(
			'block_external_requests' => array(
				'title' => __('Block External Requests', 'dragonizer'),
				'description' => __('Blocks unnecessary WooCommerce.com connections. Your admin dashboard normally makes 5-10 external requests for updates and suggestions, each taking 1-2 seconds. With this enabled, these requests are blocked, making your admin load instantly while keeping all core features.<br><span style="color:green">Safe to enable on all sites.</span>', 'dragonizer'),
			),
			'disable_tracking' => array(
				'title' => __('Disable Usage Tracking', 'dragonizer'),
				'description' => __('Disables all WooCommerce tracking features including usage tracking, email notifications, and merchant suggestions.', 'dragonizer'),
			),
			'toplevelcatsonly' => array(
				'title' => __('Disable Category Dropdown', 'dragonizer'),
				'description' => __('Removes the product category filter dropdown from the WooCommerce products admin list. This dropdown performs poorly with many categories.<br><span style="color:red">Only enable if you don\'t rely on filtering products by category in admin.</span>', 'dragonizer'),
			),
			'removecustommeta' => array(
				'title' => __('Disable Custom Meta Dropdown', 'dragonizer'),
				'description' => __('Removes the custom meta dropdown box from product editing screen. This box runs an inefficient query to list all possible meta keys.<br><span style="color:green">You can still edit meta by typing the key name.</span>', 'dragonizer'),
			),
			'interface_metabox' => array(
				'title' => __('Remove WooCommerce Dashboard Widget', 'dragonizer'),
				'description' => __('Disables the WooCommerce dashboard widget that shows order statistics. This widget performs heavy calculations that can slow down every admin page load by several seconds.<br><span style="color:green">All statistics remain available in WooCommerce → Reports.</span>', 'dragonizer'),
			),
			'interface_setup' => array(
				'title' => __('Dashboard Setup Widget', 'dragonizer'),
				'description' => __('Enabling this option will remove WooCommerce Dashboard Setup Widget from WordPress Dashboard.', 'dragonizer'),
			),
			'interface_suggestions' => array(
				'title' => __('Marketplace Suggestions', 'dragonizer'),
				'description' => __('This option will disable Marketplace Suggestions.', 'dragonizer'),
			),
			'interface_extensions' => array(
				'title' => __('Extensions', 'dragonizer'),
				'description' => __('Hide Extensions & My Subscriptions submenus in the WooCommerce menu in your admin panel menu.', 'dragonizer'),
			),
			'hide_payment_providers' => array(
				'title' => __('Hide marketplace link', 'dragonizer'),
				'description' => __('Hide Discover other payment providers link on the Payments Settings screen', 'dragonizer'),
			),
			'woocommerce_blocks' => array(
				'title' => __('WooCommerce Blocks', 'dragonizer'),
				'description' => __("Activating this option will disable WooCommerce Blocks scripts.", 'dragonizer'),
			)
		);

		$this->woo_optimizer_performance = array(
			'performance_scripts' => array(
				'title' => __('scripts and styles', 'dragonizer'),
				'description' => __('Use this option to disable WooCommerce scripts (javascript) and styles (CSS) everywhere except on product, cart and checkout pages.<br><span style="color: #d94f4f">Please check your home screen once after enabling this option</span>', 'dragonizer'),
			),
			'performance_cart' => array(
				'title' => __('Cart Fragments', 'dragonizer'),
				'description' => __('Disable The Cart Fragments feature that used to update the cart total without refreshing the page.<br><span style="color: #d94f4f">Disabling it will speed up your store, but may result in wrong calculations in mini cart. Use with caution.</span>', 'dragonizer'),
			),
			'performance_widgets' => array(
				'title' => __('Widgets', 'dragonizer'),
				'description' => __('WooCommerce by default comes with a lot of widgets installed. They often are not used at all, but can add backend load and front-end load. Use this option to disable the WooCommerce widgets.<br><span style="color: #d94f4f">Please make sure that you are not using any of WooCommerce Widgets anywhere in your site.</span>', 'dragonizer'),
			),
			'stripe_script' => array(
				'title' => __('Stripe scripts', 'dragonizer'),
				'description' => __("Enabling this option will disable Stripe Payment Request Button on all product pages. The Stripe scripts won't be loaded on the product pages so the pages should be loading faster.", 'dragonizer'),
			),
			'cacheshortcode_onsale' => array(
				'title' => __('Cache Sale Products', 'dragonizer'),
				'description' => __('Caches the [sale_products] shortcode output for 12 hours. If you display sale products on homepage or widgets, this reduces database load. WPML compatible.<br><span style="color:green">Automatically refreshes every 12 hours.</span>', 'dragonizer'),
			),
			'cacheshortcode_bestselling' => array(
				'title' => __('Cache Bestsellers', 'dragonizer'),
				'description' => __('Caches the [best_selling_products] shortcode output for 12 hours. Helps performance when displaying bestseller lists. WPML compatible.<br><span style="color:green">Updates automatically every 12 hours.</span>', 'dragonizer'),
			),
			'removeajaxvariationscalc' => array(
				'title' => __('Skip Variation Counts', 'dragonizer'),
				'description' => __('Stops WooCommerce from counting variations on the product page.<br><span style="color:green">Especially helpful for products with hundreds of variations.</span>', 'dragonizer'),
			),
		);

		$this->woo_optimizer_advanced = array(
			'optimize_meta_handling' => array(
				'title' => __('Optimize Meta Management', 'dragonizer'),
				'description' => __('Optimizes custom field handling by removing inefficient meta key queries. Particularly improves performance when editing products with many custom fields. Uses efficient database indexes for meta queries.<br><span style="color:green">Major performance boost for stores with lots of custom fields.</span>', 'dragonizer'),
			),
			'optimisewoodeleteoptions' => array(
				'title' => __('Optimize Database Cleanup', 'dragonizer'),
				'description' => __('Improves how WooCommerce cleans up temporary data from your database. Without this, cleanup operations can cause database locks lasting several minutes on large stores.<br><span style="color:green">Recommended for stores with over 10,000 products.</span>', 'dragonizer'),
			),
			'cacheorderdeliverydate' => array(
				'title' => __('Optimize Order Date Filter', 'dragonizer'),
				'description' => __('Caches queries that check order delivery dates instead of doing a full table scan for each request. The full table scan (SELECT YEAR(FROM_UNIXTIME(meta_value)) as year, MONTH(FROM_UNIXTIME(meta_value)) as month, meta_value FROM postmeta) is replaced with a cached result showing the last 15 months.<br><span style="color:green">Safe to enable - dramatically improves order admin page load time on stores with 10,000+ orders. Can reduce load time from 30+ seconds to under 1 second.</span>', 'dragonizer'),
			),
			'ajaxattributeedit' => array(
				'title' => __('Load Attributes via AJAX', 'dragonizer'),
				'description' => __('Changes how product attributes load in the edit screen. Instead of loading all terms at once, loads them via AJAX as needed.<br><span style="color:green">Essential for stores with thousands of attribute terms - prevents edit screen timeouts.</span>', 'dragonizer'),
			),
			'fixwoo_onboarding' => array(
				'title' => __('Cache Product Checks', 'dragonizer'),
				'description' => __('Caches WooCommerce\'s product existence checks by returning hardcoded values.<br><span style="color:red">Warning: This is an aggressive optimization that modifies core WooCommerce behavior. While it can reduce admin page load times by 10-70 seconds, it may cause issues with WooCommerce setup wizards, onboarding, and product status detection. Test thoroughly before enabling on production sites.</span>', 'dragonizer'),
			),
			'defertermcounting' => array(
				'title' => __('Defer Term Counting', 'dragonizer'),
				'description' => __('Instead of counting items in categories after every change, defers this to a nightly maintenance task.<br><span style="color:green">Dramatically speeds up imports and bulk edits. Categories show slightly outdated counts until nightly update.</span>', 'dragonizer'),
			),
			'cachepostcounts' => array(
				'title' => __('Cache Post Type Counts', 'dragonizer'),
				'description' => __('Caches the count of items for each post type.<br><span style="color:green">Automatically excludes orders to maintain accurate order counts while improving performance.</span>', 'dragonizer'),
			),
			'action_scheduler' => array(
				'title' => __('Clean Action Scheduler', 'dragonizer'),
				'description' => __('Automatically removes completed and failed background tasks daily. Prevents performance degradation from large Action Scheduler tables.<br><span style="color:green">Only removes already completed or failed tasks.</span>', 'dragonizer'),
			),
			'wpiperf_product_attributes_index_fix' => array(
				'title' => __('Optimize Attribute Queries', 'dragonizer'),
				'description' => __('Improves how WooCommerce queries product attributes.<br><span style="color:green">Makes attribute operations much faster, especially on large stores.</span>', 'dragonizer'),
			),
			'sortorder' => array(
				'title' => __('Natural Sort Order', 'dragonizer'),
				'description' => __('Uses database natural ordering instead of explicit sorting.<br><span style="color:red">Warning: Will override your configured sort options, but provides major performance gains. Test thoroughly before enabling.</span>', 'dragonizer'),
			),
			'calctotals' => array(
				'title' => __('Skip Total Counts (Frontend)', 'dragonizer'),
				'description' => __('Removes total result counting from frontend queries.<br><span style="color:red">Will affect pagination display ("Showing X of Y results"). Best used with infinite scroll.</span>', 'dragonizer'),
			),
			'calctotals_admin' => array(
				'title' => __('Skip Total Counts (Admin)', 'dragonizer'),
				'description' => __('Removes total result counting from admin queries.<br><span style="color:red">Changes pagination display in admin lists but significantly improves performance on large stores. Recommended for stores with over 10,000 products.</span>', 'dragonizer'),
			),
			'changetoexists' => array(
				'title' => __('Optimize Main Queries', 'dragonizer'),
				'description' => __('Uses EXISTS queries instead of JOINs for better performance.<br><span style="color:red">Warning: This is an experimental feature that can dramatically improve query speed but may cause unexpected behavior. Test thoroughly before enabling on live site.</span>', 'dragonizer'),
			),
			'optimisewoogroup' => array(
				'title' => __('Optimize GROUP BY', 'dragonizer'),
				'description' => __('Improves database query performance by optimizing or removing unnecessary GROUP BY clauses.<br><span style="color:green">Automatically chooses the most efficient approach based on query type.</span>', 'dragonizer'),
			),
			'optimiseprivatecheck' => array(
				'title' => __('Skip Private Post Checks', 'dragonizer'),
				'description' => __('Removes private post visibility checks for administrators on the frontend.<br><span style="color:red">Warning: Private posts will not be visible on frontend at all, even to administrators.</span>', 'dragonizer'),
			)
		);

		$this->default_settings_login_customizer = array(
			'template' => 'default',
		);

		$this->final_settings_login_customizer = empty($this->settings['login_customizer']) ? $this->default_settings_login_customizer : array_merge($this->default_settings_login_customizer, array_filter($this->get('login_customizer') ?: []));

		$this->default_settingsـmaintenance = array(
			'page_id' => '',
			'site_status' => 'online',
			'token' => strtoupper(substr(MD5(rand()), 0, 12)),
		);

		$this->final_settingsـmaintenance = empty($this->settings['maintenance']) ? $this->default_settingsـmaintenance : array_merge($this->default_settingsـmaintenance, array_filter($this->get('maintenance')));

		$this->preview_base_url = home_url('/?mct_preview=' . wp_create_nonce('maintenance_preview_nonce'));

		if ($this->final_settingsـmaintenance['page_id']) {
			$this->preview_url = $this->preview_base_url . '&mct_page_id=' . $this->final_settingsـmaintenance['page_id'];
		} else {
			$this->preview_url = $this->preview_base_url;
		}

		$this->magic_base_url = home_url('/?mct_token=');
		$this->magic_url      = home_url('/?mct_token=' . $this->final_settingsـmaintenance['token']);
	}

	public function all_options_checked($options, $section, $excludes = [])
	{
		foreach ($excludes as $exclude) {
			unset($options[$exclude]);
		}

		if (is_array($section)) {
			return count(array_intersect(array_keys($options), array_keys(call_user_func_array([$this, 'get'], $section) ?: []))) === count($options);
		} else {
			return count(array_intersect(array_keys($options), array_keys($this->get($section) ?: []))) === count($options);
		}
	}

	public function safe_wp_editor($content, $editor_id, $options = array())
	{
		ob_start();

		wp_editor($content, $editor_id, $options);

		if (wp_doing_ajax()) {
			ob_get_clean();
			\_WP_Editors::enqueue_scripts();
			print_footer_scripts();
			\_WP_Editors::editor_js();
		}

		if (@ob_get_length()) @ob_end_flush();
	}

	public function ajax_check_ssl_support()
	{
		if (!current_user_can('manage_options')) {
			wp_die(__('You do not have permission', 'dragonizer'));
		}

		ob_start();

		$responce_code = $this->has_ssl_support();

		if ($responce_code === 200) {
			$response = array('success' => true, 'http_code' => '200');
		} else {
			$error = sprintf('<i class="dashicons dashicons-no-alt"></i> ' . __('SSL is not supported. Website returned response code %s over SSL. Please ask your hosting provider to check for you.', 'dragonizer'), '<strong>' . $responce_code . '</strong>');
			$response = array('success' => false, 'http_code' => $responce_code, 'error' => $error);
		}

		$process = ob_get_clean();
		echo json_encode($response);

		exit();
	}

	public function ajax_enable_ssl()
	{
		if (!current_user_can('manage_options')) {
			wp_die(__('You do not have permission', 'dragonizer'));
		}

		$this->modules_status['ssl_secure'] = '1';
		$this->save_settings(array_merge(['modules_status' => $this->modules_status], ['ssl_secure' => ['enabled' => 'on']]));

		wp_cache_flush();

		exit();
	}

	public function deactivate_plugin()
	{
		if (!wp_verify_nonce($_GET['_wpnonce'], 'deactivate_plugin')) {
			wp_nonce_ays('');
		}

		if (!current_user_can('activate_plugins')) {
			$redirect_url = add_query_arg('pc_action', 'generic_permission_err', wp_get_referer());
			wp_safe_redirect(esc_url_raw($redirect_url));
			exit;
		}

		deactivate_plugins($_GET['plugin']);
		wp_safe_redirect(wp_get_referer());
		die();
	}

	public function ajax_purge_assets_cache_files()
	{
		$file_name = $_POST['file'];

		if (empty($file_name)) {
			$file_name = 'all-of-them';
		}

		if ($file_name === 'all-of-them') {
			$this->purge_assets_cache();
		} else {
			DRFS::delete(_dr(DRAGONIZER_ASSETS_CACHE_DIR, $file_name));
			$this->ajax_refresh_assets_cache_files();
		}

		wp_die();
	}

	public function ajax_assets_cache_file_log()
	{
		$file_name = $_POST['file'];

		if (empty($file_name)) {
			wp_die('', 400);
		}
?>
		<div class="drag-dr-modal-wrap dragonizer-tableview">
			<h3 style="margin-top:-30px"><?= $file_name ?></h3>
			<div class="drag-dr-modal-body dragonizer-tableview-holder">
				<table style="max-width:100%">
					<tbody>
						<?php
						$log_file    = DRFS::read(_dr(DRAGONIZER_CACHE_DIR, 'assets', $file_name) . '.log') ?? '';
						$access_file = DRFS::read(_dr(DRAGONIZER_CACHE_DIR, 'assets', $file_name) . '.accessed') ?? '';

						if ($log_file !== '') {
							preg_match_all('/(?:\h-\h.*?->\h)\K(.*\.\b(?:css|js)\b)(?=\h\(No need to minify\))?/', $log_file, $input_files);

							$saved_reque   = preg_match_all('/\((\d+) requests saved\)/m', $log_file, $reque) ? array_sum($reque[1]) : 0;
							$saved_space_k = preg_match_all('/\((\d+\.\d+)[K] saved\)|\((\d+)[K] saved\)/m', $log_file, $space_k) ? array_sum($space_k[1]) : 0;
							$saved_space_m = preg_match_all('/\((\d+\.\d+)[M] saved\)|\((\d+)[M] saved\)/m', $log_file, $space_m) ? array_sum($space_m[1]) * 1024 : 0;
							$saved_space   = $saved_space_k + $saved_space_m;

							foreach ($input_files[0] as $input_file) {
						?>
								<tr>
									<td><?= $input_file ?></td>
								</tr>
						<?php }
						} ?>
					</tbody>
				</table>
			</div>

			<div class="drag-dr-modal-footer">
				<?php
				if ($saved_reque > 0 && $saved_space > 0) { ?>

					<p><?= sprintf(__("Generating this file has optimized loading your site by reducing %1s requests and %2s KB.", 'dragonizer'), $saved_reque, $saved_space) ?></p>
				<?php } elseif ($saved_reque > 0 && $saved_space == 0) { ?>
					<p><?= sprintf(__("Generating this file has optimized loading your site by reducing %s KB.", 'dragonizer'), $saved_reque) ?></p>
				<?php } elseif ($saved_reque == 0 && $saved_space > 0) { ?>
					<p><?= sprintf(__("Generating this file has optimized loading your site by reducing %s requests.", 'dragonizer'), $saved_space) ?></p>
				<?php }

				if ($access_file !== '') {
					$date = dr_substr($access_file, '-', 1);
					$url = substr($access_file, strpos($access_file, "-") + 1);

					if ($date !== '' && $url !== '')
				?>
					<p><?= sprintf(__("This file was last used in <bdo style='direction:ltr'>%1s</bdo> at <a style='text-decoration:none' target='_blank' href='%2s'>this url</a>.", 'dragonizer'), dr_to_shamsi($date), $url) ?></p>
				<?php
				}
				?>
				<button type="button" class="drag-dr-cancel-modal drag-dr-button-secondary"><?php _e('Cancel', 'dragonizer'); ?></button>
			</div>
		</div>
	<?php

		wp_die();
	}

	public function ajax_preload_assets_cache_files()
	{
		$this->make_request(esc_url(add_query_arg(array('dragonizer-create-order-list' => 'true'), site_url())));

		$this->ajax_refresh_assets_cache_files();

		wp_die();
	}

	public function ajax_refresh_assets_cache_files()
	{
		$cached_asset_files = glob(DRAGONIZER_ASSETS_CACHE_DIR . '/*.{js,css}', GLOB_BRACE); ?>
		<div class="dragonizer-tableview-holder">
			<table>
				<thead>
					<tr align="center" valign="middle">
						<td style="width:10%" caption="<?= __('Type', 'dragonizer') ?>"></td>
						<td style="width:40%" caption="<?= __('File Name', 'dragonizer') ?>"></td>
						<td style="width:20%" class="hidden-on-mobile" caption="<?= __('Creation Time', 'dragonizer') ?>"></td>
						<td style="width:20%" class="hidden-on-mobile" caption="<?= __('Last Used Time', 'dragonizer') ?>"></td>
						<td style="width:10%" caption="<?= __('Purge/Log', 'dragonizer') ?>"></td>
					</tr>
				</thead>
				<tbody>
					<?php
					if (count($cached_asset_files) > 0) {

						foreach ($cached_asset_files as $value) {
							$file_name = basename($value);
							if ($file_name === 'global-styles.css') continue;
							$cached_asset_file_log = DRFS::read($value . '.log') ?? '';

							if (!$cached_asset_file_log) continue;

							if (preg_match('/\d{4}\/\d{1,2}\/\d{1,2}\h\d{1,2}\:\d{1,2}:\d{1,2}/', $cached_asset_file_log, $output_array) === false) continue;

							$create_time = $output_array[count($output_array) - 1];

							$accessed_time = __('Unknown', 'dragonizer');
							if (file_exists($value . '.accessed')) {
								$accessed_time = DRFS::read($value . '.accessed');
								$accessed_time = dr_substr($accessed_time, '-', 1);
								if (strtotime('today') <= $accessed_time) {
									$accessed_time = __('Today', 'dragonizer');
								} elseif (strtotime('yesterday') <= $accessed_time) {
									$accessed_time = __('Yesterday', 'dragonizer');
								} elseif (strtotime('this week') <= $accessed_time) {
									$accessed_time = __('This Week', 'dragonizer');
								} elseif (strtotime('this month') <= $accessed_time) {
									$accessed_time = __('This Month', 'dragonizer');
								} else {
									$accessed_time = dr_to_shamsi($accessed_time);
									$accessed_time = "<bdo style=\"direction:ltr\"><?= $accessed_time ?></bdo>";
								}
							}

					?>
							<tr align="center" valign="middle">
								<td>
									<div>
										<?php
										if (dr_ends_with($value, '.js')) { ?>
											<img src="<?= _dr(DRAGONIZER_URL, '/assets/images/other/listview-js.png') ?>" />
										<?php
										} else { ?>
											<img src="<?= _dr(DRAGONIZER_URL, '/assets/images/other/listview-css.png') ?>" />
										<?php
										}
										?>
									</div>
								</td>
								<td>
									<a target="_blank" href="<?= DRFS::local_to_url($value) ?>"><?= $file_name ?></a>
								</td>
								<td class="hidden-on-mobile"><bdo style="direction:ltr"><?= $create_time ?></bdo></td>
								<td class="hidden-on-mobile"><?= $accessed_time ?></td>
								<td>
									<div>
										<img data-file="<?= $file_name ?>" title="<?= __('Purge', 'dragonizer') ?>" class="linked purge-single" src="<?= _dr(DRAGONIZER_URL, '/assets/images/other/listview-purge.png') ?>" />
										<img data-file="<?= $file_name ?>" title="<?= __('Log', 'dragonizer') ?>" class="linked log-single" src="<?= _dr(DRAGONIZER_URL, '/assets/images/other/listview-log.png') ?>" />
									</div>
								</td>
							</tr>
						<?php
						}
					} else {
						?>
						<tr>
							<td colspan="5"><?= __('No files have been cached yet', 'dragonizer') ?></td>
						</tr>
					<?php
					}
					?>

				</tbody>

				<tfoot>
					<tr>
						<td colspan="4">
							<div class="fixed">
								<?php if (count($cached_asset_files) > 0) { ?>
									<img id="purge-all" title="<?= __('Purge all', 'dragonizer') ?>" class="linked" style="width:40px;height:40px" src="<?= _dr(DRAGONIZER_URL, '/assets/images/other/listview-purg-all.png') ?>" />
								<?php
								}
								?>
								<img id="refresh-all" title="<?= __('Refresh', 'dragonizer') ?>" class="linked" style="width:40px;height:40px" src="<?= _dr(DRAGONIZER_URL, '/assets/images/other/listview-refresh.png') ?>" />
								<!-- preload img -->
							</div>
						</td>
					</tr>
				</tfoot>

			</table>
		</div>
<?php

		wp_die();
	}
}
