<?php

// If user not in admin area, abort.
defined('DRAGONIZER_ADMIN_INIT') || die();

class Dragonizer_Menus extends Dragonizer_Core
{
    public $settings_class;

    public function __construct()
    {
        parent::__construct();

        $font = 'default';

        if (
            $this->true('modules_status', 'wp_tweaks') &&
            $this->true('wp_tweaks', 'font', 'status')
        ) {

            $font = $this->get('wp_tweaks', 'font', 'value') ?: 'default';

            // Fix Farsi Digit Fonts in DB
            if (strpos($font, '-FD') !== false) {
                $font = str_replace('-FD', '', $font);
                $settings['wp_tweaks'] = $this->settings['wp_tweaks'];
                $settings['wp_tweaks']['font']['value'] = $font;
                $settings['wp_tweaks']['persian_numbers'] = 'on';
                $this->save_settings($settings);
            }

            if ($this->true('wp_tweaks', 'persian_numbers')) {
                $font .= '-FD';
            }

            $font .= '-Regular';
        }

        $hidden_menus = $this->hidden_menus();
        $plugin_admin = new Dragonizer_Admin($hidden_menus, $font);

        add_action('admin_enqueue_scripts', [$plugin_admin, 'enqueue_styles'], PHP_INT_MAX);
        add_action('admin_enqueue_scripts', [$plugin_admin, 'enqueue_scripts'], PHP_INT_MAX);

        if (!current_user_can('manage_options')) return;

        // Change tab with ajax request
        add_action('wp_ajax_dragonizer_menu_content', [$this, 'dragonizer_menus_content_ajax']);

        // Change module status with ajax request
        add_action('wp_ajax_dragonizer_module_status', [$this, 'dragonizer_module_status_ajax']);

        // Change module status and Change tab content with ajax request
        add_action('wp_ajax_dragonizer_content_status', [$this, 'dragonizer_content_status_ajax']);

        // if (current_user_can('manage_options')) {
        //     add_action('in_plugin_update_message-dragonizer/dragonizer.php', function ($data, $response) {
        //         if (isset($data['upgrade_notice'])) {
        //             echo '<br/><strong style="color: red;">' . strip_tags($data['upgrade_notice']) . '</strong>';
        //         }
        //     }, 10, 2);
        // }

        $this->settings_class = new Dragonizer_Settings();

        add_action('admin_menu', array($this, 'admin_menu'));
        add_filter('plugin_action_links_' . DRAGONIZER_BASE, array($this, 'plugin_action_links'));
        add_action('wp_ajax_dragonizer_submit-uninstall-reason', [$this, 'uninstall_reason_submission']);
        add_action('wp_ajax_dragonizer_submit-uninstall-normal', [$this, 'uninstall_reason_normal']);

        add_action('admin_footer', array($this, 'deactivate_scripts'));

        // delete default dragonizer icon colors when admin color scheme changed
        add_action('admin_color_scheme_picker', function () {
            $this->delete_settings('colors');
        });

        // add_action('in_plugin_update_message-' . plugin_basename(__FILE__), function (){
        //     echo '<div class="update-message">fsdfsdf</div>';
        // }, 10);

        add_filter('plugin_row_meta', [$this, 'add_plugin_meta_links_votes'], 10, 2);

        // Content specific to Dragonizer admin pages.
        add_action(
            'current_screen',
            function () {
                if (false === strpos(get_current_screen()->id, 'dragonizer')) {
                    return;
                }

                // Dragonizer pages footer credits.
                add_filter(
                    'admin_footer_text',
                    function () {
                        return ' ' . sprintf(__('If you like <strong>Dragonizer</strong>, Please leave us a rating of 5&starf; in %1$srtl-theme.com%2$s, Thank you', 'dragonizer'), '<a href="https://www.rtl-theme.com/dragonizer-wordpress-plugin/discussions/" target="_blank">', '</a>') . ' ';
                    },
                    9999
                );

                add_filter('update_footer', function () {
                    return __('Powered by Dynamatic', 'dragonizer');
                }, 9999);
            }
        );

        // Add "settings" link to Dragonizer in the plugin list.
        add_filter(
            'plugin_action_links',
            function ($plugin_actions, $plugin_file) {
                $new_actions = array();
                if (DRAGONIZER_BASE === $plugin_file) {
                    $new_actions['sc_settings'] = sprintf('<a class="attention" href="%s">' . __('Empowering', 'dragonizer') . '</a>', esc_url(add_query_arg(array('page' => 'dragonizer_main'), admin_url('admin.php'))));
                }
                return array_merge($new_actions, $plugin_actions);
            },
            10,
            2
        );

        if ($this->true('modules_status', 'shamsi')) {

            if (get_locale() != 'fa_IR' && get_locale() != 'fa_AF') {
                add_action('admin_notices', function () {

                    $url_main   = esc_url(add_query_arg(array('page' => "dragonizer_about"), admin_url('admin.php')));
                    $url_role   = get_admin_url() . 'options-general.php#WPLANG';

                    $html = '<div class="notice drag_notice notice-warning" id="dragonizer_notice_no_farsi">';
                    $html .= '<div style="display: flex; align-items: center;"> <a href="' . $url_main . '"> <img style="width:74px;margin-top:1em; margin-left: 1em; margin-right: 1em;" src="' . _dr(DRAGONIZER_URL, '/assets/images/logo/main.png') . '?ver=' . DRAGONIZER_VER . '" alt=""> </a> <div> <h2 style="font-weight: bold; font-size: 2em; ">' . __('Dragonizer', 'dragonizer') . '</h2> <p style="margin-top:-1em; display: flex; align-items: center;">' . __('Your assistant to make WordPress more powerful', 'dragonizer') . '</p> </div> </div> <br>';
                    $html .= '<div style="line-height:2;white-space: pre-line;text-align:justify">' . __("It seems that you have activated <span style='font-weight:700'>Farsi & Shamsi</span> section in <span style='color:#9d0110; font-weight:700'>Dragonizer</span> settings, but the language of your site is not Persian.\nPlease change language of your site to Persian for better performance of this section", 'dragonizer') . '</div><br>';
                    $html .= '<div style="text-align: center;"><a style="background-color: aliceblue;" target="_blank" href="' . $url_role . '" class="button">' . __('Change language', 'dragonizer') . '</a></div><br>';
                    $html .= '</div>';


                    echo $html;
                }, 12);
            }

            if (function_exists('wp_timezone_string')) {
                $zone = wp_timezone_string();
                if ((get_locale() == 'fa_IR' || get_locale() == 'fa_AF') && $zone != 'Asia/Tehran' && $zone != 'Asia/Kabul' && $zone != '+03:30' && $zone != '+04:30') {
                    add_action('admin_notices', function () {
                        // Check if the user has already dismissed the notice
                        if (get_user_meta(get_current_user_id(), 'dismiss_dragonizer_notice', true) === 'yes') {
                            return; // They have, so don't display the notice
                        }

                        $url_main   = esc_url(add_query_arg(array('page' => "dragonizer_about"), admin_url('admin.php')));
                        $url_zone   = get_admin_url() . 'options-general.php#timezone_string';

                        $html = '<div class="notice drag_notice notice-warning is-dismissible" id="dragonizer_notice_no_farsi">';
                        $html .= '<div style="display: flex; align-items: center;"> <a href="' . $url_main . '"> <img style="width:74px;margin-top:1em; margin-left: 1em; margin-right: 1em;" src="' . _dr(DRAGONIZER_URL, '/assets/images/logo/main.png') . '?ver=' . DRAGONIZER_VER . '" alt=""> </a> <div> <h2 style="font-weight: bold; font-size: 2em; ">' . __('Dragonizer', 'dragonizer') . '</h2> <p style="margin-top:-1em; display: flex; align-items: center;">' . __('Your assistant to make WordPress more powerful', 'dragonizer') . '</p> </div> </div> <br>';
                        $html .= '<div style="line-height:2;white-space: pre-line;text-align:justify">' . __('For better performance of Dragonizer\'s <span style="font-weight:700">Farsi & Shamsi</span> section, you should change the time zone to Tehran', 'dragonizer') . '</div><br>';
                        $html .= '<div style="text-align: center;"><a style="background-color: aliceblue;" target="_blank" href="' . $url_zone . '" class="button">' . __('Change Timezone', 'dragonizer') . '</a></div><br>';
                        $html .= '</div>';

                        echo $html;
                    }, 12);

                    add_action('admin_enqueue_scripts', function () {
                        wp_enqueue_script('jquery');
                        wp_enqueue_script('wp-util'); // This allows you to use wp.ajax in your script

                        // Define the nonce and pass it to the inline script
                        $nonce = wp_create_nonce('dismiss_dragonizer_notice_nonce');

                        // Inline script for dismissing notice
                        wp_add_inline_script('wp-util', '
                            jQuery(document).ready(function($) {
                                var dismiss_dragonizer_notice_nonce = "' . $nonce . '";
                                $(document).on("click", ".drag_notice .notice-dismiss", function() {
                                    wp.ajax.send("dismiss_dragonizer_notice", {
                                        data: {
                                            _ajax_nonce: dismiss_dragonizer_notice_nonce
                                        },
                                        success: function() {
                                            // Notice dismissed
                                        },
                                        error: function() {
                                            // Error handling
                                        }
                                    });
                                });
                            });
                        ');
                    });

                    add_action('wp_ajax_dismiss_dragonizer_notice', function () {
                        check_ajax_referer('dismiss_dragonizer_notice_nonce'); // Check the nonce for security
                        update_user_meta(get_current_user_id(), 'dismiss_dragonizer_notice', 'yes');
                        wp_send_json_success(); // Send a success response back to the JavaScript
                    });
                }
            }
        }

        // add_action('admin_notices', [$this, 'admin_notices'], 10);
        // add_action('wp_ajax_drag_dismiss_notice', [$this, 'dismiss_notice']);

        if ('pending' === get_option('dragonizer_activation_welcome')) {
            $link = "";
            if (is_multisite() && is_network_admin()) {
                $link = add_query_arg(array('page' => 'dragonizer_main'), network_admin_url('admin.php'));
            } elseif (!is_multisite()) {
                $link = add_query_arg(array('page' => 'dragonizer_main'), admin_url('admin.php'));
            }
            delete_option('dragonizer_activation_welcome');
            wp_redirect($link);
            exit;
        }

        if (!wp_doing_ajax()) {

            $module = $_GET['dragonizer_module_change_status'] ?? null;

            $setting = $_GET['dragonizer_setting_change_status'] ?? null;

            if ($module && check_admin_referer('dragonizer_' . $module, 'dragonizer_secret')) {

                $this->modules_status[$module] = !$this->modules_status[$module];

                $this->save_settings(['modules_status' => $this->modules_status]);

                $url = esc_url(add_query_arg(array('page' => "dragonizer_main#dragonizer_$module"), admin_url('admin.php')));

                header("Location: $url");
            }

            if ($setting && check_admin_referer('dragonizer_' . $setting, 'dragonizer_secret')) {

                $this->modules_status[$setting] = !$this->modules_status[$setting];

                $this->save_settings(['modules_status' => $this->modules_status]);

                $url = esc_url(add_query_arg(array('page' => "dragonizer_$setting"), admin_url('admin.php')));

                header("Location: $url");
            }
        }
    }


    public function format_filesize($bytes, $decimals = 2)
    {
        $units = array('B', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB');

        for ($i = 0; ($bytes / 1024) > 0.9; $i++, $bytes /= 1024) {
        }

        return sprintf("%1.{$decimals}f %s", round($bytes, $decimals), $units[$i]);
    }

    private function get_site_name()
    {
        $site_name = get_bloginfo('name');

        if (empty($site_name)) {
            $site_name = get_bloginfo('description');
            $site_name = wp_trim_words($site_name, 3, '');
        }

        if (empty($site_name)) {
            $site_name = esc_url(home_url());
        }

        return $site_name;
    }

    private function get_all_plugins()
    {
        // Ensure get_plugins function is loaded
        if (!function_exists('get_plugins')) {
            include ABSPATH . '/wp-admin/includes/plugin.php';
        }

        $plugins             = get_plugins();
        $active_plugins_keys = get_option('active_plugins', array());
        $active_plugins      = array();

        foreach ($plugins as $k => $v) {
            // Take care of formatting the data how we want it.
            $formatted         = array();
            $formatted['name'] = strip_tags($v['Name']);

            if (isset($v['Version'])) {
                $formatted['version'] = strip_tags($v['Version']);
            }

            if (isset($v['Author'])) {
                $formatted['author'] = strip_tags($v['Author']);
            }

            if (isset($v['Network'])) {
                $formatted['network'] = strip_tags($v['Network']);
            }

            if (isset($v['PluginURI'])) {
                $formatted['plugin_uri'] = strip_tags($v['PluginURI']);
            }

            if (in_array($k, $active_plugins_keys)) {
                // Remove active plugins from list so we can show active and inactive separately
                unset($plugins[$k]);
                $active_plugins[$k] = $formatted;
            } else {
                $plugins[$k] = $formatted;
            }
        }

        return array('active_plugins' => $active_plugins, 'inactive_plugins' => $plugins);
    }

    private static function get_server_info()
    {
        global $wpdb;

        $server_data = array();

        if (isset($_SERVER['SERVER_SOFTWARE']) && !empty($_SERVER['SERVER_SOFTWARE'])) {
            $server_data['software'] = $_SERVER['SERVER_SOFTWARE'];
        }

        if (function_exists('phpversion')) {
            $server_data['php_version'] = phpversion();
        }

        $server_data['mysql_version'] = $wpdb->db_version();

        $server_data['php_max_upload_size']  = size_format(wp_max_upload_size());
        $server_data['php_default_timezone'] = date_default_timezone_get();
        $server_data['php_soap']             = class_exists('SoapClient') ? 'Yes' : 'No';
        $server_data['php_fsockopen']        = function_exists('fsockopen') ? 'Yes' : 'No';
        $server_data['php_curl']             = function_exists('curl_init') ? 'Yes' : 'No';

        return $server_data;
    }

    private function get_wp_info()
    {
        $wp_data = array();

        $wp_data['memory_limit'] = WP_MEMORY_LIMIT;
        $wp_data['debug_mode']   = (defined('WP_DEBUG') && WP_DEBUG) ? 'Yes' : 'No';
        $wp_data['locale']       = get_locale();
        $wp_data['version']      = get_bloginfo('version');
        $wp_data['multisite']    = is_multisite() ? 'Yes' : 'No';
        $wp_data['theme_slug']   = get_stylesheet();

        $theme = wp_get_theme($wp_data['theme_slug']);

        $wp_data['theme_name']    = $theme->get('Name');
        $wp_data['theme_version'] = $theme->get('Version');
        $wp_data['theme_uri']     = $theme->get('ThemeURI');
        $wp_data['theme_author']  = $theme->get('Author');

        return $wp_data;
    }

    public function get_user_counts()
    {
        $user_count          = array();
        $user_count_data     = count_users();
        $user_count['total'] = $user_count_data['total_users'];

        // Get user count based on user role
        foreach ($user_count_data['avail_roles'] as $role => $count) {
            if (!$count) {
                continue;
            }

            $user_count[$role] = $count;
        }

        return $user_count;
    }

    private function get_user_ip_address()
    {
        $response = wp_remote_get('https://icanhazip.com/');

        if (is_wp_error($response)) {
            return '';
        }

        $ip = trim(wp_remote_retrieve_body($response));

        if (!filter_var($ip, FILTER_VALIDATE_IP)) {
            return '';
        }

        return $ip;
    }

    protected function get_tracking_data()
    {
        $all_plugins = $this->get_all_plugins();

        $users = get_users(array(
            'role'    => 'administrator',
            'orderby' => 'ID',
            'order'   => 'ASC',
            'number'  => 1,
            'paged'   => 1,
        ));

        $admin_user =  (is_array($users) && !empty($users)) ? $users[0] : false;
        $first_name = $last_name = '';

        if ($admin_user) {
            $first_name = $admin_user->first_name ? $admin_user->first_name : $admin_user->display_name;
            $last_name  = $admin_user->last_name;
        }

        $ip = $this->get_user_ip_address();

        $data = array(
            'url'              => esc_url(home_url()),
            'site'             => $this->get_site_name(),
            'admin_email'      => get_option('admin_email'),
            'first_name'       => $first_name,
            'last_name'        => $last_name,
            'server'           => serialize($this->get_server_info()),
            'wp'               => serialize($this->get_wp_info()),
            'users'            => serialize($this->get_user_counts()),
            'active_plugins'   => count($all_plugins['active_plugins']),
            'inactive_plugins' => count($all_plugins['inactive_plugins']),
            'ip_address'       => $ip,
            'project_version'  => DRAGONIZER_VER,
            'hash'             => md5($ip . DRAGONIZER_VER . 'ardyn')
        );

        return $data;
    }

    public function uninstall_reason_normal()
    {
        if (!isset($_POST['clean_settings'])) {
            wp_send_json_error();
        }

        if ($_POST['clean_settings'] === 'true') {
            add_option('dragonizer_deactivation_clean', 'true');
        }

        wp_send_json_success();
    }

    public function uninstall_reason_submission()
    {
        if (!isset($_POST['reason_id'])) {
            wp_send_json_error();
        }

        $data                = $this->get_tracking_data();
        $data['reason_id']   = sanitize_text_field($_POST['reason_id']);
        $data['reason_info'] = isset($_REQUEST['reason_info']) ? trim(stripslashes($_REQUEST['reason_info'])) : '';

        if ($_POST['clean_settings'] === 'true') {
            add_option('dragonizer_deactivation_clean', 'true');
        }

        dr_send_data($data, 'https://ardyn.ir/api/dragonizer/v1/deactive');

        wp_send_json_success();
    }

    public function send_request($params, $blocking = false)
    {
        $url =  trailingslashit('https://ardyn.ir/api/dragonizer/v1/deactive');

        $headers = array(
            'X-Requested-With' => 'XMLHttpRequest',
            'user-agent'       => 'Appsero/' . md5(esc_url(home_url())) . ';',
            'Accept'           => 'application/json',
        );

        $response = wp_remote_post($url, array(
            'method'      => 'POST',
            'data_format' => 'body',
            'timeout'     => 5,
            'redirection' => 5,
            'httpversion' => '1.0',
            'blocking'    => $blocking,
            'headers'     => $headers,
            'body'        => $params,
            'cookies'     => array()
        ));

        return $response;
    }

    private function deactivation_modal_styles()
    { ?>
        <style type="text/css">
            .drag-dr-modal {
                position: fixed;
                z-index: 99999999;
                top: 0;
                right: 0;
                bottom: 0;
                left: 0;
                background: -webkit-radial-gradient(top left, rgba(0, 0, 0, 0.6), rgba(0, 0, 0, 0.05));
                background: -moz-radial-gradient(top left, rgba(0, 0, 0, 0.6), rgba(0, 0, 0, 0.05));
                background: radial-gradient(to bottom right, rgba(0, 0, 0, 0.6), rgba(0, 0, 0, 0.05));
                backdrop-filter: blur(3px);
                display: none;
                box-sizing: border-box;
                overflow: hidden
            }

            .drag-dr-modal * {
                box-sizing: border-box
            }

            .drag-dr-modal-wrap {
                max-width: 780px;
                width: 100%;
                position: relative;
                margin: 10% auto;
                background: #fff;
                border-radius: 8px;
                overflow: hidden
            }

            .drag-dr-modal-header {
                border-bottom: 1px solid #E8E8E8;
                padding: 20px 20px 18px 20px
            }

            .drag-dr-modal-header h3 {
                line-height: 1.8;
                margin: 0;
                color: #4A5568
            }

            .drag-dr-modal-body {
                padding: 5px 20px 20px 20px
            }

            .drag-dr-modal-body .reason-input {
                margin-top: 5px;
                margin-left: 20px
            }

            .drag-dr-modal-footer {
                border-top: 1px solid #E8E8E8;
                padding: 20px;
                text-align: right
            }

            .drag-dr-modal-reasons-bottom {
                margin: 0
            }

            ul.drag-de-reasons {
                display: flex;
                margin: 0 -5px 0 -5px;
                padding: 15px 0 20px 0
            }

            ul.drag-de-reasons.drag-de-others-reasons {
                padding-top: 0;
                display: none
            }

            ul.drag-de-reasons li {
                padding: 0 5px;
                margin: 0;
                width: 16.66%
            }

            ul.drag-de-reasons label {
                position: relative;
                border: 1px solid #E8E8E8;
                border-radius: 4px;
                display: block;
                text-align: center;
                height: 100%;
                padding: 15px 3px 8px 3px
            }

            ul.drag-de-reasons label:after {
                width: 0;
                height: 0;
                border-left: 8px solid transparent;
                border-right: 8px solid transparent;
                border-top: 10px solid #9d0110;
                position: absolute;
                left: 50%;
                top: 100%;
                margin-left: -8px
            }

            ul.drag-de-reasons label input[type="radio"] {
                position: absolute;
                left: 0;
                right: 0;
                visibility: hidden
            }

            .drag-de-reason-text {
                color: #4A5568;
                font-size: 13px
            }

            .drag-de-reason-icon {
                margin-bottom: 7px
            }

            ul.drag-de-reasons li.drag-de-reason-selected label {
                background-color: #9d0110;
                border-color: #dd0000
            }

            li.drag-de-reason-selected .drag-de-reason-icon svg,
            li.drag-de-reason-selected .drag-de-reason-icon svg g {
                fill: #fff
            }

            li.drag-de-reason-selected .drag-de-reason-text {
                color: #fff
            }

            ul.drag-de-reasons li.drag-de-reason-selected label:after {
                content: ""
            }

            .drag-dr-modal-reason-input {
                margin-bottom: 15px;
                display: none
            }

            .drag-dr-modal-reason-input textarea {
                background: #FAFAFA;
                border: 1px solid #287EB8;
                border-radius: 4px;
                width: 100%;
                height: 100px;
                color: #524242;
                font-size: 13px;
                line-height: 1.4;
                padding: 11px 15px;
                resize: none
            }

            .drag-dr-modal-reason-input textarea:focus {
                outline: 0 none;
                box-shadow: 0 0 0
            }

            .drag-dr-button-secondary,
            .drag-dr-button-secondary:hover {
                border: 1px solid #EBEBEB;
                border-radius: 3px;
                font-size: 13px;
                line-height: 1.5;
                color: #718096;
                padding: 5px 12px;
                cursor: pointer;
                background-color: transparent;
                text-decoration: none
            }

            .drag-dr-submit-modal,
            .drag-dr-submit-modal:hover {
                border: 1px solid #9d0110;
                background-color: #9d0110;
                border-radius: 3px;
                font-size: 13px;
                line-height: 1.5;
                color: #fff;
                padding: 5px 12px;
                cursor: pointer;
                margin-left: 4px
            }

            .drag-dr-hidden {
                opacity: 0;
                display: none
            }

            .drag-dr-over-disabled {
                height: 100%;
                width: 100%;
                opacity: 0.5;
                background-color: #c3c4c7;
                position: absolute;
                z-index: 999999
            }
        </style>
    <?php
    }

    private function get_uninstall_reasons()
    {
        $reasons = array(
            array(
                'id'          => 'could-not-understand',
                'text'        => __("Couldn't understand", 'dragonizer'),
                'placeholder' => __('Would you like us to assist you?', 'dragonizer'),
                'icon'        => '<svg xmlns="http://www.w3.org/2000/svg" width="23" height="23" viewBox="0 0 23 23"><g fill="none"><g fill="#9d0110"><path d="M11.5 0C17.9 0 23 5.1 23 11.5 23 17.9 17.9 23 11.5 23 10.6 23 9.6 22.9 8.8 22.7L8.8 22.6C9.3 22.5 9.7 22.3 10 21.9 10.3 21.6 10.4 21.3 10.4 20.9 10.8 21 11.1 21 11.5 21 16.7 21 21 16.7 21 11.5 21 6.3 16.7 2 11.5 2 6.3 2 2 6.3 2 11.5 2 13 2.3 14.3 2.9 15.6 2.7 16 2.4 16.3 2.2 16.8L2.1 17.1 2.1 17.3C2 17.5 2 17.7 2 18 0.7 16.1 0 13.9 0 11.5 0 5.1 5.1 0 11.5 0ZM6 13.6C6 13.7 6.1 13.8 6.1 13.9 6.3 14.5 6.2 15.7 6.1 16.4 6.1 16.6 6 16.9 6 17.1 6 17.1 6.1 17.1 6.1 17.1 7.1 16.9 8.2 16 9.3 15.5 9.8 15.2 10.4 15 10.9 15 11.2 15 11.4 15 11.6 15.2 11.9 15.4 12.1 16 11.6 16.4 11.5 16.5 11.3 16.6 11.1 16.7 10.5 17 9.9 17.4 9.3 17.7 9 17.9 9 18.1 9.1 18.5 9.2 18.9 9.3 19.4 9.3 19.8 9.4 20.3 9.3 20.8 9 21.2 8.8 21.5 8.5 21.6 8.1 21.7 7.9 21.8 7.6 21.9 7.3 21.9L6.5 22C6.3 22 6 21.9 5.8 21.9 5 21.8 4.4 21.5 3.9 20.9 3.3 20.4 3.1 19.6 3 18.8L3 18.5C3 18.2 3 17.9 3.1 17.7L3.1 17.6C3.2 17.1 3.5 16.7 3.7 16.3 4 15.9 4.2 15.4 4.3 15 4.4 14.6 4.4 14.5 4.6 14.2 4.6 13.9 4.7 13.7 4.9 13.6 5.2 13.2 5.7 13.2 6 13.6ZM11.7 11.2C13.1 11.2 14.3 11.7 15.2 12.9 15.3 13 15.4 13.1 15.4 13.2 15.4 13.4 15.3 13.8 15.2 13.8 15 13.9 14.9 13.8 14.8 13.7 14.6 13.5 14.4 13.2 14.1 13.1 13.5 12.6 12.8 12.3 12 12.2 10.7 12.1 9.5 12.3 8.4 12.8 8.3 12.8 8.2 12.8 8.1 12.8 7.9 12.8 7.8 12.4 7.8 12.2 7.7 12.1 7.8 11.9 8 11.8 8.4 11.7 8.8 11.5 9.2 11.4 10 11.2 10.9 11.1 11.7 11.2ZM16.3 5.9C17.3 5.9 18 6.6 18 7.6 18 8.5 17.3 9.3 16.3 9.3 15.4 9.3 14.7 8.5 14.7 7.6 14.7 6.6 15.4 5.9 16.3 5.9ZM8.3 5C9.2 5 9.9 5.8 9.9 6.7 9.9 7.7 9.2 8.4 8.2 8.4 7.3 8.4 6.6 7.7 6.6 6.7 6.6 5.8 7.3 5 8.3 5Z"></path></g></g></svg>'
            ),
            array(
                'id'          => 'found-better-plugin',
                'text'        => __('Found a better plugin', 'dragonizer'),
                'placeholder' => __('Which plugin?', 'dragonizer'),
                'icon'        => '<svg xmlns="http://www.w3.org/2000/svg" width="23" height="23" viewBox="0 0 23 23"><g fill="none"><g fill="#9d0110"><path d="M17.1 14L22.4 19.3C23.2 20.2 23.2 21.5 22.4 22.4 21.5 23.2 20.2 23.2 19.3 22.4L19.3 22.4 14 17.1C15.3 16.3 16.3 15.3 17.1 14L17.1 14ZM8.6 0C13.4 0 17.3 3.9 17.3 8.6 17.3 13.4 13.4 17.2 8.6 17.2 3.9 17.2 0 13.4 0 8.6 0 3.9 3.9 0 8.6 0ZM8.6 2.2C5.1 2.2 2.2 5.1 2.2 8.6 2.2 12.2 5.1 15.1 8.6 15.1 12.2 15.1 15.1 12.2 15.1 8.6 15.1 5.1 12.2 2.2 8.6 2.2ZM8.6 3.6L8.6 5C6.6 5 5 6.6 5 8.6L5 8.6 3.6 8.6C3.6 5.9 5.9 3.6 8.6 3.6L8.6 3.6Z"></path></g></g></svg>',
            ),
            array(
                'id'          => 'not-have-that-feature',
                'text'        => __("Missing a specific feature", 'dragonizer'),
                'placeholder' => __('Could you tell us more about that feature?', 'dragonizer'),
                'icon'        => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="17" viewBox="0 0 24 17"><g fill="none"><g fill="#9d0110"><path d="M19.4 0C19.7 0.6 19.8 1.3 19.8 2 19.8 3.2 19.4 4.4 18.5 5.3 17.6 6.2 16.5 6.7 15.2 6.7 15.2 6.7 15.2 6.7 15.2 6.7 14 6.7 12.9 6.2 12 5.3 11.2 4.4 10.7 3.3 10.7 2 10.7 1.3 10.8 0.6 11.1 0L7.6 0 7 0 6.5 0 6.5 5.7C6.3 5.6 5.9 5.3 5.6 5.1 5 4.6 4.3 4.3 3.5 4.3 3.5 4.3 3.5 4.3 3.4 4.3 1.6 4.4 0 5.9 0 7.9 0 8.6 0.2 9.2 0.5 9.7 1.1 10.8 2.2 11.5 3.5 11.5 4.3 11.5 5 11.2 5.6 10.8 6 10.5 6.3 10.3 6.5 10.2L6.5 10.2 6.5 17 6.5 17 7 17 7.6 17 22.5 17C23.3 17 24 16.3 24 15.5L24 0 19.4 0Z"></path></g></g></svg>',
            ),
            array(
                'id'          => 'is-not-working',
                'text'        => __('Not working', 'dragonizer'),
                'placeholder' => __('Could you tell us a bit more whats not working?', 'dragonizer'),
                'icon'        => '<svg xmlns="http://www.w3.org/2000/svg" width="23" height="23" viewBox="0 0 23 23"><g fill="none"><g fill="#9d0110"><path d="M11.5 0C17.9 0 23 5.1 23 11.5 23 17.9 17.9 23 11.5 23 5.1 23 0 17.9 0 11.5 0 5.1 5.1 0 11.5 0ZM11.5 2C6.3 2 2 6.3 2 11.5 2 16.7 6.3 21 11.5 21 16.7 21 21 16.7 21 11.5 21 6.3 16.7 2 11.5 2ZM12.5 12.9L12.7 5 10.2 5 10.5 12.9 12.5 12.9ZM11.5 17.4C12.4 17.4 13 16.8 13 15.9 13 15 12.4 14.4 11.5 14.4 10.6 14.4 10 15 10 15.9 10 16.8 10.6 17.4 11.5 17.4Z"></path></g></g></svg>',
            ),
            array(
                'id'          => 'looking-for-other',
                'text'        => __("Not what I was looking", 'dragonizer'),
                'placeholder' => __('Could you tell us a bit more?', 'dragonizer'),
                'icon'        => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="17" viewBox="0 0 24 17"><g fill="none"><g fill="#9d0110"><path d="M23.5 9C23.5 9 23.5 8.9 23.5 8.9 23.5 8.9 23.5 8.9 23.5 8.9 23.4 8.6 23.2 8.3 23 8 22.2 6.5 20.6 3.7 19.8 2.6 18.8 1.3 17.7 0 16.1 0 15.7 0 15.3 0.1 14.9 0.2 13.8 0.6 12.6 1.2 12.3 2.7L11.7 2.7C11.4 1.2 10.2 0.6 9.1 0.2 8.7 0.1 8.3 0 7.9 0 6.3 0 5.2 1.3 4.2 2.6 3.4 3.7 1.8 6.5 1 8 0.8 8.3 0.6 8.6 0.5 8.9 0.5 8.9 0.5 8.9 0.5 8.9 0.5 8.9 0.5 9 0.5 9 0.2 9.7 0 10.5 0 11.3 0 14.4 2.5 17 5.5 17 7.3 17 8.8 16.1 9.8 14.8L14.2 14.8C15.2 16.1 16.7 17 18.5 17 21.5 17 24 14.4 24 11.3 24 10.5 23.8 9.7 23.5 9ZM5.5 15C3.6 15 2 13.2 2 11 2 8.8 3.6 7 5.5 7 7.4 7 9 8.8 9 11 9 13.2 7.4 15 5.5 15ZM18.5 15C16.6 15 15 13.2 15 11 15 8.8 16.6 7 18.5 7 20.4 7 22 8.8 22 11 22 13.2 20.4 15 18.5 15Z"></path></g></g></svg>',
            ),
            array(
                'id'          => 'temporary-deactivation',
                'text'        => __('Temporary deactivation', 'dragonizer'),
                'placeholder' => __('Tell us your suggestions for making Dragonizer great.', 'dragonizer'),
                'icon'        => '<svg xmlns="http://www.w3.org/2000/svg" fill="none" width="24" height="24" viewBox="0 0 24 24"><g fill="#9d0110"><path d="M8.5 11a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3Zm7.947 2.106a1 1 0 0 1 .447 1.341L16 14l.894.447-.001.003-.002.004-.005.01-.015.029a4.907 4.907 0 0 1-.226.374 5.57 5.57 0 0 1-.688.84C15.348 16.317 14.36 17 13 17c-1.173 0-2.075-.294-2.697-.606a4.696 4.696 0 0 1-.716-.438 3.412 3.412 0 0 1-.26-.215l-.02-.02-.008-.008-.003-.003-.002-.002.698-.7-.698.7a1 1 0 0 1 1.403-1.425l.008.007a2.691 2.691 0 0 0 .492.315c.378.19.976.395 1.803.395.641 0 1.152-.316 1.543-.707a3.56 3.56 0 0 0 .563-.741l.002-.004a1 1 0 0 1 1.34-.442ZM14 9a1 1 0 1 0 0 2h2a1 1 0 1 0 0-2h-2Z" /><path d="M12 23c6.075 0 11-4.925 11-11S18.075 1 12 1 1 5.925 1 12s4.925 11 11 11Zm0-2.007a8.993 8.993 0 1 1 0-17.986 8.993 8.993 0 0 1 0 17.986Z" fill-rule="evenodd" clip-rule="evenodd"/></g></svg>',
            ),
        );

        return $reasons;
    }

    public function plugin_action_links($links)
    {

        if (array_key_exists('deactivate', $links)) {
            $links['deactivate'] = str_replace('<a', '<a class="' . DRAGONIZER_NAME . '-deactivate-link"', $links['deactivate']);
        }

        return $links;
    }

    public function deactivate_scripts()
    {
        // preload - beta
        /*echo '<style>
            .dragonpreload {
                background: url("data:image/gif;base64,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") center no-repeat #fff;
                width: 100%;
                height: 100%;
                position: fixed;
                top: 0;
                left: 0;
                z-index: 999999999;
            }
            body {
                overflow:hidden;
            }
        </style>
        <script>
            jQuery(document).ready((function(){jQuery(".dragonpreload").fadeOut("slow"),document.body.style.overflow="auto"})),jQuery(window).bind("beforeunload",(function(){jQuery(".dragonpreload").fadeIn(),document.body.style.overflow="hidden"}));            </script>
        <div class="dragonpreload"></div>';*/

        global $pagenow;

        if ('plugins.php' != $pagenow) {
            return;
        }

        global $pagenow;

        if (false && !is_plugin_active('rtl-theme/rtl-theme.php')) {

            // add_action('in_plugin_update_message-' . DRAGONIZER_BASE, function ($currentPluginMetadata, $newPluginMetadata) {
            //     echo 'asdasd';
            // }, 10, 2);

            // $path = DRAGONIZER_BASE;
            // add_action("after_plugin_row_{$path}", function () {

            //     $url    = 'https://www.rtl-theme.com/dragonizer-wordpress-plugin/';
            //     $header = stream_context_create(array('http' => array('timeout' => 10, 'header'  => "User-Agent: Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36",)));
            //     $html   = @DRFS::read($url, false, $header) ?: false;

            //     if (!$html) return;

            //     libxml_use_internal_errors(true);
            //     $domdocument = new DOMDocument();
            //     $domdocument->loadHTML($html);
            //     $finder = new DOMXPath($domdocument);
            //     $dom = @$finder->query('//section[starts-with(@class,"widgets product-attributes")]/table[@class = "attributes-table"]/tr/td[@class = "value"]');
            //     $version = @$dom->item(0)->nodeValue ?? '-1';
            //     $pdate = @$dom->item(1)->getAttribute('title') ?? '-1';

            //     if ($version === '-1' || $pdate === '-1' || version_compare(DRAGONIZER_VER, $version, '>=')) return;

            //     $wp_list_table = _get_list_table('WP_MS_Themes_List_Table');

            //     echo '<tr class="plugin-update-tr active"><td colspan="' . $wp_list_table->get_column_count() . '" class="plugin-update colspanchange">';

            //     echo '<div class="update-message notice inline notice-warning notice-alt"><p>';

            //     if (Get_bloginfo('language') === 'fa-IR') {
            //         printf(__('Version %1$s Dragonizer was released on %2$s. To update, you must install <a href="https://www.rtl-theme.com/updater/" target="_blank">rtl-theme auto-updater</a> plugin.', 'dragonizer'), $version, $pdate);
            //     } else {
            //         printf(__('Version %1$s Dragonizer is available. You must install <a href="https://www.rtl-theme.com/updater/" target="_blank">rtl-theme auto-updater</a> plugin to update.', 'dragonizer'), $version);
            //     }
            //     echo '</p></div></td></tr>';
            // });
        }


        $this->deactivation_modal_styles();
        $reasons        = $this->get_uninstall_reasons();
        $custom_reasons = apply_filters('appsero_custom_deactivation_reasons', []);
    ?>

        <div class="drag-dr-modal" id="dragonizer-drag-dr-modal">
            <div class="drag-dr-modal-wrap">
                <div class="drag-dr-over-disabled drag-dr-hidden"></div>
                <div class="drag-dr-modal-header">
                    <h3><?php _e('Goodbyes are always hard. If you have a moment, please let us know how we can improve.', 'dragonizer'); ?></h3>
                </div>

                <div class="drag-dr-modal-body">
                    <ul class="drag-de-reasons">
                        <?php foreach ($reasons as $reason) { ?>
                            <li data-placeholder="<?php echo esc_attr($reason['placeholder']); ?>">
                                <label>
                                    <input type="radio" name="selected-reason" value="<?php echo $reason['id']; ?>">
                                    <div class="drag-de-reason-icon"><?php echo $reason['icon']; ?></div>
                                    <div class="drag-de-reason-text"><?php echo $reason['text']; ?></div>
                                </label>
                            </li>
                        <?php } ?>
                    </ul>
                    <?php if ($custom_reasons && is_array($custom_reasons)) : ?>
                        <ul class="drag-de-reasons drag-de-others-reasons">
                            <?php foreach ($custom_reasons as $reason) { ?>
                                <li data-placeholder="<?php echo esc_attr($reason['placeholder']); ?>" data-customreason="true">
                                    <label>
                                        <input type="radio" name="selected-reason" value="<?php echo $reason['id']; ?>">
                                        <div class="drag-de-reason-icon"><?php echo $reason['icon']; ?></div>
                                        <div class="drag-de-reason-text"><?php echo $reason['text']; ?></div>
                                    </label>
                                </li>
                            <?php } ?>
                        </ul>
                    <?php endif; ?>
                    <div class="drag-dr-modal-reason-input"><textarea></textarea></div>
                    <p class="drag-dr-modal-reasons-bottom">
                        <?php
                        echo __('Your data will be shared with the Dragonizer developer to troubleshoot issues and improve the product.', 'dragonizer');
                        ?>
                    </p>
                    <br>
                    <label for="dragonizer_deactivation_clean">
                        <input name="dragonizer_deactivation_clean" type="checkbox" id="dragonizer_deactivation_clean">
                        <?php
                        echo __('Also remove all dragonizer settings (No rollback)', 'dragonizer');
                        ?>
                    </label>
                </div>

                <div class="drag-dr-modal-footer">
                    <p class="drag-dr-modal-reasons-bottom">
                        <?php
                        echo __('<span style="color: #d94f4f">Notice: </span>If you need help, you can send us a request to configure Dragonizer with <a href="https://www.rtl-theme.com/dashboard/#/ticket-send/" target="_blank">ticket</a> on rtl-theme.com <span style="color: green">(Free)</span>', 'dragonizer');
                        ?>
                    </p>
                    <br>
                    <a href="#" class="dont-bother-me drag-dr-button-secondary"><?php _e("Skip & Deactivate", 'dragonizer'); ?></a>
                    <button class="drag-dr-button-secondary drag-dr-cancel-modal"><?php _e('Cancel', 'dragonizer'); ?></button>
                    <button class="drag-dr-submit-modal"><?php _e('Submit & Deactivate', 'dragonizer'); ?></button>
                    <span class="drag-dr-hidden" style="font-size:90%; color:#9d0110"> <?= __('Select a option from list above', 'dragonizer') ?></span>
                </div>
            </div>
        </div>

        <script type="text/javascript">
            (function($) {
                $(function() {
                    $.fn.shake = function(interval = 100, distance = 10, times = 4) {
                        var jTarget = $(this);
                        jTarget.css('position', 'relative');
                        for (var iter = 0; iter < (times + 1); iter++) {
                            jTarget.animate({
                                left: ((iter % 2 == 0 ? distance : distance * -1))
                            }, interval);
                        }
                        return jTarget.animate({
                            left: 0
                        }, interval);
                    }

                    var modal = $('#dragonizer-drag-dr-modal');
                    var wrap = $('.drag-dr-modal-wrap');
                    var deactivateLink = '';

                    // Open modal
                    $('#the-list').on('click', 'a.dragonizer-deactivate-link', function(e) {
                        e.preventDefault();
                        modal.fadeIn('250');
                        deactivateLink = $(this).attr('href');
                        modal.find('a.dont-bother-me').attr('href', deactivateLink).css('float', 'left');
                    });

                    // Close modal; Cancel
                    modal.on('click', 'button.drag-dr-cancel-modal', function(e) {
                        e.preventDefault();
                        modal.fadeOut('250');
                    })

                    modal.on('click', function(e) {
                        e.preventDefault();
                        wrap.shake();
                    }).on('click', 'div', function(e) {
                        e.stopPropagation();
                    });

                    // Reason change
                    modal.on('click', 'input[type="radio"]', function() {
                        $(".drag-dr-modal-footer").find('span').first().attr('class', 'drag-dr-hidden');
                        var parent = $(this).parents('li');
                        var isCustomReason = parent.data('customreason');
                        var inputValue = $(this).val();

                        if (isCustomReason) {
                            $('ul.drag-de-reasons.drag-de-others-reasons li').removeClass('drag-de-reason-selected');
                        } else {
                            $('ul.drag-de-reasons li').removeClass('drag-de-reason-selected');

                            if ("other" != inputValue) {
                                $('ul.drag-de-reasons.drag-de-others-reasons').css('display', 'none');
                            }
                        }

                        // Show if has custom reasons
                        if ("other" == inputValue) {
                            $('ul.drag-de-reasons.drag-de-others-reasons').css('display', 'flex');
                        }

                        parent.addClass('drag-de-reason-selected');
                        $('.drag-dr-modal-reason-input').show();

                        $('.drag-dr-modal-reason-input textarea').attr('placeholder', parent.data('placeholder')).focus();
                    });

                    // Submit response
                    modal.on('click', 'button.drag-dr-submit-modal', function(e) {
                        e.preventDefault();

                        var button = $(this);

                        if (button.hasClass('disabled')) {
                            return;
                        }

                        if ($("ul.drag-de-reasons").find('li.drag-de-reason-selected').length === 0) {
                            $(".drag-dr-modal-footer").find('span').first().attr('class', '');
                            return;
                        }

                        modal.off('click');

                        $(".drag-dr-modal-wrap").find("div").first().removeClass("drag-dr-hidden");

                        var $radio = $('input[type="radio"]:checked', modal);
                        var $input = $('.drag-dr-modal-reason-input textarea');

                        var $clean = $('#dragonizer_deactivation_clean').is(':checked');

                        $.ajax({
                            url: ajaxurl,
                            type: 'POST',
                            data: {
                                action: 'dragonizer_submit-uninstall-reason',
                                reason_id: (0 === $radio.length) ? 'none' : $radio.val(),
                                reason_info: (0 !== $input.length) ? $input.val().trim() : '',
                                clean_settings: $clean
                            },
                            beforeSend: function() {
                                button.addClass('disabled');
                                button.text('<?= __('Processing...', 'dragonizer') ?>');
                            },
                            complete: function() {
                                window.location.href = deactivateLink;
                            }
                        });
                    });

                    // Submit normal
                    modal.on('click', 'a.drag-dr-button-secondary', function(e) {
                        e.preventDefault();

                        var button = $(this);

                        if (button.hasClass('disabled')) {
                            return;
                        }

                        modal.off('click');

                        $(".drag-dr-modal-wrap").find("div").first().removeClass("drag-dr-hidden");

                        var $clean = $('#dragonizer_deactivation_clean').is(':checked');

                        $.ajax({
                            url: ajaxurl,
                            type: 'POST',
                            data: {
                                action: 'dragonizer_submit-uninstall-normal',
                                clean_settings: $clean
                            },
                            beforeSend: function() {
                                button.addClass('disabled');
                                button.text('<?= __('Processing...', 'dragonizer') ?>');
                            },
                            complete: function() {
                                window.location.href = deactivateLink;
                            }
                        });

                    });
                });
            }(jQuery));
        </script>

    <?php
    }

    public function admin_notices()
    {
        if ($this->is_dragonizer_page()) return;
        if ($this->is_dismiss('all')) return;

        $screen_id = get_current_screen()->id ?: '';

        if (strpos($screen_id, 'plugins') !== false)  return;

        foreach ($this->notices() as $notice) {
            if ($notice['condition'] == false || $this->is_dismiss($notice['id'])) continue;
            echo $notice['content'];
            break;
        }
    ?>
        <script type="text/javascript">
            jQuery(document).ready(function($) {
                $('#wpwrap').on('click', '#drag_dragonizer_about button.notice-dismiss', function() {
                    let notice = $(this).closest('.drag_notice');
                    notice = notice.attr('id');
                    if (notice !== 'undefined' && notice.indexOf('drag_') !== -1) {
                        notice = notice.replace('drag_', '');
                        $.ajax({
                            url: "<?php echo admin_url('admin-ajax.php') ?>",
                            type: 'post',
                            data: {
                                notice: notice,
                                action: 'drag_dismiss_notice',
                                nonce: "<?php echo wp_create_nonce('drag_dismiss_notice'); ?>"
                            }
                        });
                    }
                });
            });
        </script>
<?php
    }

    public function notices(): array
    {
        $url_main = esc_url(add_query_arg(array('page' => "dragonizer_about"), admin_url('admin.php')));
        $url_about = 'https://www.rtl-theme.com/dashboard/#/ticket-send/';
        $url_rate = 'https://www.rtl-theme.com/dragonizer-wordpress-plugin/discussions/';

        $html = '<div class="notice drag_notice notice-info is-dismissible" id="drag_dragonizer_about">';
        $html .= '<div style="display: flex; align-items: center;"> <a href="' . $url_main . '"> <img style="width:74px;margin-top:1em; margin-left: 1em; margin-right: 1em;" src="' . _dr(DRAGONIZER_URL, '/assets/images/logo/main.png') . '?ver=' . DRAGONIZER_VER . '" alt=""> </a> <div> <h2 style="font-weight: bold; font-size: 2em; ">' . __('Dragonizer', 'dragonizer') . '</h2> <p style="margin-top:-1em; display: flex; align-items: center;">' . __('Your assistant to make WordPress more powerful', 'dragonizer') . '</p> </div> </div> <br>';
        $html .= '<div style="line-height:2;white-space: pre-line;text-align:justify">' . __('We are proud that you are also a member of the <span style="color:#9d0110; font-weight:700">Dragonizer</span> family. We hope you find this plugin useful and enjoy using it.
		Designing, coding, testing and adding features in this plugin has taken more than <span style="font-weight:700">2000 hours</span> so far. If you enjoy the features of this plugin and are aware of the great effort that has been put into the development of this plugin, we are happy to spend just 2 minutes of your valuable time to keep the development of this plugin alive and rate plugin on the rtl-theme.com site.
		<span style="color:#9d0110; font-weight:700">Dragonizer</span> programming has been done very obsessively but we are still at the beginning of the road, so please <span style="color:#FF1493; font-weight:700">be kind</span> to it and let us know if you see any problem in it, we will fix the reported problems and consider your suggestions as soon as possible and then offer a new version.
		Finally, thank you for using <span style="color:#9d0110; font-weight:700">Dragonizer</span>, Good luck.', 'dragonizer') . '</div><br>';
        $html .= '<div style="text-align: center;"><a style="background-color: aliceblue;" target="_blank" href="' . $url_rate . '" class="button">' . __('Vote the plugin', 'dragonizer') . '</a> <a target="_blank" href="' . $url_about . '" class="button">' . __('Request support or make suggestions', 'dragonizer') . '</a></div><br>';
        $html .= '</div>';

        return [
            [
                'id' => 'dragonizer_about',
                'content' => $html,
                'condition' => true,
                'dismiss' => 6 * MONTH_IN_SECONDS,
            ],
        ];
    }

    public function dismiss_notice()
    {
        check_ajax_referer('drag_dismiss_notice', 'nonce');

        $this->set_dismiss($_POST['notice']);

        wp_die();
    }

    public function set_dismiss($notice_id)
    {
        $notices = wp_list_pluck($this->notices(), 'dismiss', 'id');

        if (isset($notices[$notice_id]) && $notices[$notice_id]) {
            set_transient('drag_notice_' . $notice_id, 'DISMISS', intval($notices[$notice_id]));
            set_transient('drag_notice_all', 'DISMISS', HOUR_IN_SECONDS);
        }
    }

    public function is_dismiss($notice_id): bool
    {
        return get_transient('drag_notice_' . $notice_id) !== false;
    }

    public function add_plugin_meta_links_votes($meta_fields, $file)
    {
        if (DRAGONIZER_BASE == $file) {
            $svg_ = "<svg xmlns='http://www.w3.org/2000/svg' width='15' height='15' fill='none' stroke='currentColor' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' class='feather feather-star' viewBox='0 0 24 24'><path d='m12 2 3 6.3 7 1-5 4.8 1.2 7-6.2-3.3L5.8 21 7 14.1 2 9.3l7-1L12 2z'/></svg>";

            $meta_fields[] = "<a href='https://www.rtl-theme.com/dragonizer-wordpress-plugin/discussions/' target='_blank' title='Rate'>"
                . __('Support us', 'dragonizer')
                . "  <i class='ct-rate-stars'>$svg_$svg_$svg_$svg_$svg_</i></a>";

            $stars_color = "#ffb900";

            echo "<style>"
                . ".ct-rate-stars{display:inline-block;color:" . $stars_color . ";position:relative;top:3px;}"
                . ".ct-rate-stars svg{fill:" . $stars_color . ";}"
                . ".ct-rate-stars svg:hover{fill:" . $stars_color . "}"
                . ".ct-rate-stars svg:hover ~ svg{fill:none;}"
                . "</style>";
        }

        return $meta_fields;
    }

    public function admin_menu(): void
    {
        //The icon in Base64 format
        $icon_base64 = 'PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCA5MTggODU3IiBmaWxsPSIjY2NjIj48cGF0aCBkPSJNMzYxIDBoN2M3MCAzIDE0MCAxNSAyMDIgNDggMjggMTYgNTQgMzYgNzcgNTkgMTggMTUgNDYgMjMgNjcgMTAgMTMtMTIgMTYtMzAgMTktNDYgOSAxMCAxMSAyMyAxNiAzNSAyNSA2OCA0MSAxMzkgNzYgMjAzIDQgMTEgMTYgMjEgMTMgMzQtNSA0MC0xIDg0IDIwIDEyMCA2IDEyIDE2IDI3IDMyIDI1IDgtNCA4LTE0IDEyLTIxIDkgMjcgMTQgNTYgMTYgODV2MTNjLTIgMzQtOCA2OC0yNiA5Ny00IDctMTEtMS0xNS00LTEzLTYtMjMtMTYtMzUtMjQtNCAyMC0yNiAyOC00NCAyNC00Ni02LTg4LTI3LTEzMC00NS0zLTMtOC00LTEwLTkgMTctNSAzNy00IDUxLTE3IDYtMTAgMi0yNC01LTMyLTE2LTE5LTM4LTMyLTU5LTQ1LTMwLTE4LTYwLTM1LTkyLTQ5LTM1LTUtNzAgMTAtOTggMzEtMTcgMTItMjUgMzItMzUgNDktMTQgMzYtOCA3OSAxMyAxMTEgMzcgNTggMTA2IDg2IDE3MyA5NiAzMiA3IDY1IDUgOTcgOGE0ODcgNDg3IDAgMCAxLTI3NCAxMDFoLTZjLTUwLTItOTktMTItMTQ0LTM0LTQ1LTMwLTkzLTU3LTEyNS0xMDEtNjYtODItODYtMTk1LTYzLTI5NyAxLTkgNi0xOSAyLTI5LTI3LTE3LTYyLTEzLTkzLTExdi0zYzIxLTUzIDU4LTEwMSAxMDYtMTMyIDM0LTI1IDc2LTMyIDExNi00MCA1LTEgNC04IDAtMTAtMzktMjQtODQtMzItMTI4LTQxIDItNSA2LTcgMTAtMTAgNjMtNDAgMTM3LTYyIDIxMi02MyAyMi0yIDQ0IDIgNjcgMCAxLTctNS0xMy05LTE4LTIyLTMwLTU3LTQ3LTkxLTYwbDEtMmMyNS01IDUxLTQgNzctNm0zNzYgMjU0YzIgNyA4IDEyIDkgMTkgNCAyNC03IDQ3LTUgNzEgMTEgOSAyOSA5IDM5IDE5IDggMTggMTEgMzggMTkgNTUtMi0xNi0yLTMzLTItNDktMS0xMyAxOS04IDIwLTIwLTMtNS05LTYtMTMtOS0xNC0xMy0xOC0zMi0yOC00Ny05LTE2LTIwLTM1LTM5LTM5bTk0IDI4MyAxOSA3YzEzIDggMTQgMjkgMjggMzUgNC0xOCAwLTQwLTEwLTU2LTEwLTE3LTQwLTMtMzcgMTRaIi8+PC9zdmc+';

        //The icon in the data URI scheme
        $icon_data_uri = 'data:image/svg+xml;base64,' . $icon_base64;

        add_menu_page('dragonizer', __('Dragonizer', 'dragonizer'), 'administrator', 'dragonizer_main', array($this, 'settings_main'), $icon_data_uri, '2.00001');
        foreach ($this->get_tabs() as $key => $val) {
            if ($key === 'about' || $key === 'main') {
                add_submenu_page('dragonizer_main', $val['title'], '<span style="color: ' . $this->admin_colors['colors']['hover_color'] . '">' . $val['title'] . '</span>', 'administrator', 'dragonizer_' . $key, array($this, 'settings_main'));
            } else {
                add_submenu_page('dragonizer_main', $val['title'], $val['title'], 'administrator', 'dragonizer_' . $key, array($this, 'settings_main'));
            }
        }
    }

    public function settings_main(): void
    {
        include_once _dr(DRAGONIZER_PAR_DIR, 'dragonizer-settings-main.php');
        function_exists('display_main') && display_main($this);
    }

    public function temp_echo($tab_name): string
    {
        $referer = add_query_arg(array('page' => "dragonizer_$tab_name"), admin_url('admin.php'));
        $backurl = wp_nonce_url(admin_url('admin-post.php?action=dragonizer_disable&dragonizer_disable=false&_wp_http_referer=' . $referer), 'dragonizer-secret');

        $ena_dis = $this->true('disabled') ? "true" : "false";

        $temp_disable = '
                    <script type="text/javascript">
                        jQuery(document).ready(function($) {
                            if ($("#loader-wrapper").hasClass("loaded") && ' . $ena_dis . ') $("#disabled-wrapper").removeClass("loaded");
                            $("#temporary_activate").on("click", function(e) {
                                $(".dragonizer_tab_group #disabled-wrapper").addClass("loaded");
                                $(".dragonizer_tab_group #loader-wrapper").removeClass("loaded");
                            });
                        });
                    </script>

                    <div id="disabled-wrapper" class="loaded">
                        <div id="disabled-container">
                            <p style="color:white;font-size:18px;font-weight:700">' . __("Dragonizer has been temporarily disabled at your request", "dragonizer") . '</p>
                            <a href="' . $backurl . '">
                                <input style="margin-top: 15px;border: 0;" type="button" id="temporary_activate" class="button button-primary" value="' . __('Reactivation', 'dragonizer') . '">
                            </a>
                        </div>
                    </div>
                    ';

        return $temp_disable;
    }

    public function generate_all_modules($tab_name, $page_title): string
    {
        $all_modules_status = $this->modules_status;
        $modules_html = '<h1 class="dragon-hidden" id="' . $tab_name . '" style="margin-bottom: 30px"> ' . $page_title . '</h1> <div class="feature-section">';
        foreach ($this->get_tabs() as $module => $data) {
            if (!array_key_exists('description', $data) || in_array($module, $this->get_soon_tabs()) && !$this->is_pro_installed()) continue;
            $modules_html .= $this->generate_single_module($module, $data, $all_modules_status[$module]);
        }
        return $modules_html . '</div>';
    }

    public function generate_single_module($module, $data, $module_status, bool $ajax_request = false): string
    {
        $nonce = wp_create_nonce('dragonizer_' . $module);
        $change_status_url = esc_url(add_query_arg(array('page' => 'dragonizer_' . $module, 'dragonizer_module_change_status' => $module, 'dragonizer_secret' => $nonce), admin_url('admin.php')));
        $setting_page_url = esc_url(add_query_arg(array('page' => 'dragonizer_' . $module), admin_url('admin.php')));
        $module_title = $data['title'];
        $module_description = $data['description'];
        $module_image = $data['image'];
        $status = 'active';
        $btn_status = '';
        $ribbon = '';
        // $ribbon = '<div class="dragonizer_module-active-indicator">' . __('Active', 'dragonizer') . '</div>';

        $callback = is_multisite() ? 'is_plugin_active_for_network' : 'is_plugin_active';

        switch ($module_status) {
            case '0':
                if ($module === 'object_cache') {
                    $plugins = array_filter($this->bad_plugins['object_cache'], $callback);

                    if (count($plugins) > 0 && !$this->true('disabled')) {
                        $btn_status = '';
                    } else {
                        $btn_status = '<a class="button" href="' . $change_status_url . '" id="' . $module . '" data-slide="status">' . __('Activate', 'dragonizer') . '</a>';
                    }
                } elseif ($module === 'lazy_load' || $module === 'minify' || $module === 'caching') {
                    $plugins = array_filter($this->bad_plugins['optimizer'], $callback);

                    if (count($plugins) > 0 && !$this->true('disabled')) {
                        $btn_status = '';
                    } else {
                        $btn_status = '<a class="button" href="' . $change_status_url . '" id="' . $module . '" data-slide="status">' . __('Activate', 'dragonizer') . '</a>';
                    }
                } elseif ($module === 'shamsi') {
                    $plugins = array_filter($this->bad_plugins['shamsi'], $callback);

                    if (count($plugins) > 0 && !$this->true('disabled')) {
                        $btn_status = '';
                    } else {
                        $btn_status = '<a class="button" href="' . $change_status_url . '" id="' . $module . '" data-slide="status">' . __('Activate', 'dragonizer') . '</a>';
                    }
                } elseif ($module === 'preloading') {

                    if (!$this->true('modules_status', 'caching')) {
                        $btn_status = '';
                    } else {
                        $btn_status = '<a class="button" href="' . $change_status_url . '" id="' . $module . '" data-slide="status">' . __('Activate', 'dragonizer') . '</a>';
                    }
                } elseif ($module !== 'woo_optimizer' || dr_is_woocommerce()) {
                    $btn_status = '<a class="button" href="' . $change_status_url . '" id="' . $module . '" data-slide="status">' . __('Activate', 'dragonizer') . '</a>';
                }
                $status = 'inactive';
                $ribbon = '';
                break;

            case '1':
                if ($module === 'object_cache') {
                    $plugins = array_filter($this->bad_plugins['object_cache'], $callback);

                    if (count($plugins) > 0 && !$this->true('disabled')) {
                        $btn_status = '';
                        $status = 'inactive';
                        $ribbon = '';

                        if ($module === 'object_cache') {
                            $this->modules_status['caching'] = '0';
                            $this->save_settings(['modules_status' => $this->modules_status]);
                        }
                    } else {
                        $btn_status = '<a class="button" href="' . $change_status_url . '" id="' . $module . '" data-slide="status">' . __('Deactivate', 'dragonizer') . '</a>';
                    }
                } elseif ($module === 'ssl_secure') {
                    $plugins = array_filter($this->bad_plugins['ssl'], $callback);

                    if (count($plugins) > 0 && !$this->true('disabled')) {
                        $btn_status = '';
                        $status = 'inactive';
                        $ribbon = '';

                        if ($module === 'ssl_secure') {
                            $this->modules_status['ssl_secure'] = '0';
                            $this->save_settings(array_merge(['modules_status' => $this->modules_status], ['ssl_secure' => ['enabled' => 'off']]));
                        }
                    } else {
                        $btn_status = '<a class="button" href="' . $change_status_url . '" id="' . $module . '" data-slide="status">' . __('Deactivate', 'dragonizer') . '</a>';
                    }
                } elseif ($module === 'lazy_load' || $module === 'minify' || $module === 'caching') {
                    $plugins = array_filter($this->bad_plugins['optimizer'], $callback);

                    if (count($plugins) > 0 && !$this->true('disabled')) {
                        $btn_status = '';
                        $status = 'inactive';
                        $ribbon = '';
                        if ($module === 'lazy_load') {
                            $this->modules_status['lazy_load'] = '0';
                            $this->save_settings(['modules_status' => $this->modules_status]);
                        }

                        if ($module === 'minify') {
                            $this->modules_status['minify'] = '0';
                            $this->save_settings(['modules_status' => $this->modules_status]);
                        }

                        if ($module === 'caching') {
                            $this->modules_status['caching'] = '0';
                            $this->save_settings(['modules_status' => $this->modules_status]);
                        }
                    } else {
                        $btn_status = '<a class="button" href="' . $change_status_url . '" id="' . $module . '" data-slide="status">' . __('Deactivate', 'dragonizer') . '</a>';
                    }
                } elseif ($module === 'shamsi') {
                    $plugins = array_filter($this->bad_plugins['shamsi'], $callback);

                    if (count($plugins) > 0 && !$this->true('disabled')) {
                        $btn_status = '';
                        $status = 'inactive';
                        $ribbon = '';
                        $this->modules_status['shamsi'] = '0';
                        $this->save_settings(['modules_status' => $this->modules_status]);
                    } else {
                        $btn_status = '<a class="button" href="' . $change_status_url . '" id="' . $module . '" data-slide="status">' . __('Deactivate', 'dragonizer') . '</a>';
                    }
                } elseif ($module === 'preloading') {
                    if (!$this->true('modules_status', 'caching') || defined('DR_NO_SIMPLEXML') || defined('DR_PRELOAD_ISSUE')) {
                        $btn_status = '';
                        $status = 'inactive';
                        $ribbon = '';
                        $this->modules_status['preloading'] = '0';
                        $this->save_settings(['modules_status' => $this->modules_status]);
                    } else {
                        $btn_status = '<a class="button" href="' . $change_status_url . '" id="' . $module . '" data-slide="status">' . __('Deactivate', 'dragonizer') . '</a>';
                    }
                } elseif ($module !== 'woo_optimizer' || dr_is_woocommerce()) {
                    $btn_status = '<a class="button" href="' . $change_status_url . '" id="' . $module . '" data-slide="status">' . __('Deactivate', 'dragonizer') . '</a>';
                } else {
                    $this->modules_status['woo_optimizer'] = '0';
                    $this->save_settings(['modules_status' => $this->modules_status]);
                    $status = 'inactive';
                    $ribbon = '';
                }
                break;

            case '3':
                if (
                    ($module === 'maintenance' && !in_array($this->get('maintenance', 'site_status'), ['coming_soon', 'maintenance']))
                ) {
                    $status = 'inactive';
                    $ribbon = '';
                }
                break;

                // case '4':
                //     $status = 'inactive';
                //     $ribbon = '<div style="background: orange" class="dragonizer_module-active-indicator comming-soon">' . __('Soon', 'dragonizer') . '</div>';
                //     break;
        }

        if (!$ajax_request) {
            $div_module_list_A = '<div class="dragonizer_module-list"  id="dragonizer_' . $module . '">';
            $div_module_list_B = '</div>';
        } else {
            $div_module_list_A = '';
            $div_module_list_B = '';
        }

        return $div_module_list_A . '
                        <div class="dragon-hidden dragonizer_module-wrap">
                            <div class="dragonizer_module cleanup-module module-is-' . $status . '">

                                <a class="dragonizer_module-image" href="' . $setting_page_url . '">
                                    <img src="' . $module_image . '">
                                </a>

                                <div class="dragonizer_module-text">
                                    <h3><a href=" ' . $setting_page_url . '" >' . $module_title . '</a></h3>

                                    <div class="dragonizer_module-description">' . $module_description . '</div>
                                    ' . $ribbon . '
                                </div>

                                <div class="dragonizer_module-bottom">
                                    <div class="dragonizer_module-toggle-active">
                                        ' . $btn_status . '
                                        <a class="button" href="' . $setting_page_url . '" data-slide="setting" id="' . $module . '">' . __('Settings', 'dragonizer') . '</a>
                                    </div>
                                </div>

                            </div>
                        </div> ' .
            $div_module_list_B;
    }

    public function generate_settings($tab_name, $page_title)
    {
        $this->settings_class->dragonizer_settings_register();
        $callback = is_multisite() ? 'is_plugin_active_for_network' : 'is_plugin_active';

        $page_status = $this->modules_status[$tab_name];

        $disabled_options = ['div' => '', 'fieldset' => '', 'button' => true, 'activation' => '', 'woo' => ''];

        if ($tab_name === 'preloading' && !$this->true('modules_status', 'caching')) {
            $disabled_options['div'] = ' pro-disabled';
            $disabled_options['fieldset'] = ' disabled';
            $disabled_options['button'] = false;
            $disabled_options['woo'] = '<span class="dragonizer_security_badge dragonizer_danger_badge">' . esc_html__('To use this section, the page cache section must be active', 'dragonizer') . '</span>';

            if ($page_status == '1') {
                $this->modules_status['preloading'] = '0';
                $this->save_settings(['modules_status' => $this->modules_status]);
            }
        } elseif ($tab_name === 'maintenance' && defined('DRAGONIZER_SANDBOX')) {
            $disabled_options['button'] = false;
        } elseif ($tab_name === 'preloading' && defined('DR_NO_SIMPLEXML')) {
            $disabled_options['div'] = ' pro-disabled';
            $disabled_options['fieldset'] = ' disabled';
            $disabled_options['button'] = false;
            $disabled_options['woo'] = '<span class="dragonizer_security_badge dragonizer_danger_badge">' . esc_html__('SimpleXML extension is not loaded. Please install it', 'dragonizer') . '</span>';

            if ($page_status == '1') {
                $this->modules_status['preloading'] = '0';
                $this->save_settings(['modules_status' => $this->modules_status]);
            }
        } elseif ($tab_name === 'preloading' && defined('DR_PRELOAD_ISSUE')) {
            $disabled_options['div'] = ' pro-disabled';
            $disabled_options['fieldset'] = ' disabled';
            $disabled_options['button'] = false;
            $disabled_options['woo'] = '<span class="dragonizer_security_badge dragonizer_danger_badge">' . esc_html__('There is a problem in receiving links from sitemap', 'dragonizer') . '</span>';

            if ($page_status == '1') {
                $this->modules_status['preloading'] = '0';
                $this->save_settings(['modules_status' => $this->modules_status]);
            }
        } elseif ($tab_name === 'woo_optimizer' && !dr_is_woocommerce()) {
            $disabled_options['div'] = ' pro-disabled';
            $disabled_options['fieldset'] = ' disabled';
            $disabled_options['button'] = false;
            $disabled_options['woo'] = '<span class="dragonizer_security_badge dragonizer_danger_badge">' . esc_html__('WooCommerce plugin not enabled', 'dragonizer') . '</span>';

            if ($page_status == '1') {
                $this->modules_status['woo_optimizer'] = '0';
                $this->save_settings(['modules_status' => $this->modules_status]);
            }
        } elseif ($tab_name === 'shamsi' && count(array_filter($this->bad_plugins['shamsi'], $callback)) > 0) {
            $disabled_options['button'] = false;

            if ($page_status == '1') {
                $this->modules_status['shamsi'] = '0';
                $this->save_settings(['modules_status' => $this->modules_status]);
            }
        } else {
            if (
                $this->is_pro_installed() !== true && in_array($tab_name, $this->get_soon_tabs())
                || in_array($tab_name, $this->get_soon_tabs())
            ) {
                $disabled_options = ['div' => ' pro-disabled', 'fieldset' => ' disabled', 'button' => false, 'activation' => '', 'woo' => ''];
            } elseif ($page_status == '1' || $page_status == '0') {

                $nonce = wp_create_nonce('dragonizer_' . $tab_name);
                $change_status_url = esc_url(add_query_arg(array('page' => 'dragonizer_' . $tab_name, 'dragonizer_setting_change_status' => $tab_name, 'dragonizer_secret' => $nonce), admin_url('admin.php')));
                $active = $page_status == '1' ? 'active' : '';

                $disabled_options['activation'] = '
                                <div class="toggle-btn ' . $active . '">
                                    <input onclick="window.location.href = \'' . $change_status_url . '\';" type="checkbox" class="cb-value" />
                                    <span class="round-btn"></span>
                                </div>';

                if ($page_status == '0') {
                    $disabled_options['div'] = ' pro-disabled';
                    $disabled_options['fieldset'] = ' disabled';
                    $disabled_options['button'] = false;
                }

                if ($page_status == '1' && ($tab_name === 'db_optimizer' || $tab_name === 'benchmark' || $tab_name === 'debugging')) {
                    $disabled_options['button'] = false;
                }
            } elseif ($page_status == '2') {
                $disabled_options['button'] = false;
            } elseif ($page_status == '3') {
                $disabled_options['button'] = true;
            }
        }

        if ($disabled_options['woo'] === '' && $this->true('modules_status', $tab_name) && empty($this->get($tab_name)) && !in_array($tab_name, ['db_optimizer', 'benchmark', 'debugging', 'settings', 'about'])) {
            $disabled_options['woo'] = '<span class="dragonizer_security_badge dragonizer_danger_badge">' . esc_html__('Please save the settings on this page and reload the page (F5)', 'dragonizer') . '</span>';
        }

        $float = is_rtl() ? 'left' : 'right';

        $nonce = wp_nonce_field('my_delete_action');
        echo '

                        <table class="dragon-hidden" style="width: 100%; border-collapse: collapse; table-layout: fixed; margin-bottom: 30px;">
                            <tr id="sag">
                                <td style="width: 100%">
                                    <h1 id="' . $tab_name . '" > ' . $page_title . $disabled_options['woo'] . ' </h1> 
                                </td>
                                <td style="float:' . $float . ';">
                                    ' . $disabled_options['activation'] . '
                                </td>
                            </tr>
                        </table>

                        <div class="feature-section ' . $disabled_options['div'] . '">
                            <form style="width:100%" class="main-options-form" method="post" action="options.php">
                        ' . $nonce . '
                        <fieldset style="display:block" ' . $disabled_options['fieldset'] . '>';

        wp_enqueue_script('wp-color-picker');
        wp_enqueue_style('wp-color-picker');

        settings_fields("dragonizer_{$tab_name}");
        do_settings_sections("dragonizer_{$tab_name}");

        if ($disabled_options['button'])
            submit_button(__('Save Settings', 'dragonizer'), 'button button-primary dragon-hidden');

        echo '</fieldset>
			</form>
		</div>';
    }

    public function dragonizer_content_status_ajax(): void
    {
        $selected_module = $_POST['selected_module'];

        if (array_key_exists($selected_module, $this->get_tabs())) {

            $this->modules_status[$selected_module] = $this->modules_status[$selected_module] == '1' ? '0' : '1';

            $this->save_settings(['modules_status' => $this->modules_status]);

            $page_title = $this->get_tabs()[$selected_module]['title'];

            echo $this->generate_settings($selected_module, $page_title);
        }

        wp_die();
    }

    public function dragonizer_menus_content_ajax(): void
    {
        $tab_name = $_POST['tab_class_name'];
        $page_title = $this->get_tabs()[str_replace('tab-', '', $tab_name)]['title'];

        if ($tab_name === 'tab-main') {
            echo $this->temp_echo(str_replace('tab-', '', $tab_name));
            echo $this->generate_all_modules($tab_name, $page_title);
        } else {
            echo $this->temp_echo(str_replace('tab-', '', $tab_name));
            echo $this->generate_settings(str_replace('tab-', '', $tab_name), $page_title);
        }

        wp_die();
    }

    public function dragonizer_module_status_ajax(): void
    {
        $selected_module = $_POST['selected_module'];

        if (array_key_exists($selected_module, $this->get_tabs())) {

            $this->modules_status[$selected_module] = $this->modules_status[$selected_module] == '1' ? '0' : '1';

            $this->save_settings(['modules_status' => $this->modules_status]);

            echo $this->generate_single_module($selected_module, $this->get_tabs()[$selected_module], $this->modules_status[$selected_module], true);
        }

        wp_die();
    }

    public function get_new_tabs(): array
    {
        return array(
            // 'benchmark'
        );
    }

    public function get_soon_tabs(): array
    {
        return array(
            // 'smtp',
            // 'cdn',
        );
    }

    public function get_disabled_modules(): array
    {
        $status = $this->modules_status;

        if (!in_array($this->get('maintenance', 'site_status'), ['coming_soon', 'maintenance'])) $status['maintenance'] = 0;

        return array_keys(array_filter($status, function ($v) {
            return $v == '0';
        }));
    }

    public function hidden_menus(): array
    {
        $pro_items = $this->is_pro_installed() ? [] : $this->get_soon_tabs();
        return array_merge($pro_items, $this->get_disabled_modules());
    }

    public function is_pro_installed(): bool
    {
        return false;
    }
}

new Dragonizer_Menus();
